/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.camel.dataformat.bindy.Format;

public abstract class AbstractNumberFormat<T extends Number>
implements Format<T> {
    private boolean impliedDecimalPosition;
    private int precision;
    private DecimalFormat format;
    private int multiplier;

    public AbstractNumberFormat() {
        this(false, 0, null);
    }

    public AbstractNumberFormat(boolean impliedDecimalPosition, int precision, Locale locale) {
        this.impliedDecimalPosition = impliedDecimalPosition;
        this.precision = precision > 0 ? precision : 0;
        this.format = null;
        this.multiplier = 1;
        this.format = new DecimalFormat();
        this.format.setGroupingUsed(false);
        this.format.setDecimalSeparatorAlwaysShown(false);
        if (locale != null) {
            this.format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(locale));
        }
        if (this.impliedDecimalPosition) {
            this.format.setMinimumFractionDigits(0);
            this.format.setMaximumFractionDigits(0);
            this.multiplier = (int)Math.pow(10.0, precision);
        } else {
            this.format.setMinimumFractionDigits(this.precision);
            this.format.setMaximumFractionDigits(this.precision);
        }
    }

    protected boolean hasImpliedDecimalPosition() {
        return this.impliedDecimalPosition;
    }

    protected int getPrecision() {
        return this.precision;
    }

    protected DecimalFormat getFormat() {
        return this.format;
    }

    protected int getMultiplier() {
        return this.multiplier;
    }
}

