/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.dataformat.bindy.BindyFactory;
import org.apache.camel.dataformat.bindy.util.AnnotationModelLoader;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BindyAbstractFactory
implements BindyFactory {
    private static final transient Log LOG = LogFactory.getLog(BindyAbstractFactory.class);
    protected Set<Class<?>> models;
    protected Map<String, List<Field>> annotedLinkFields = new LinkedHashMap<String, List<Field>>();
    protected List<Field> linkFields = new ArrayList<Field>();
    protected String crlf;
    private AnnotationModelLoader modelsLoader;
    private String[] packageNames;

    public BindyAbstractFactory(PackageScanClassResolver resolver, String ... packageNames) throws Exception {
        this.modelsLoader = new AnnotationModelLoader(resolver);
        this.packageNames = packageNames;
        if (LOG.isDebugEnabled()) {
            for (String str : this.packageNames) {
                LOG.debug((Object)("Package name : " + str));
            }
        }
        this.initModel();
    }

    @Override
    public void initModel() throws Exception {
        this.initModelClasses(this.packageNames);
    }

    private void initModelClasses(String ... packageNames) throws Exception {
        this.models = this.modelsLoader.loadModels(packageNames);
    }

    public abstract void initAnnotedFields() throws Exception;

    @Override
    public abstract void bind(List<String> var1, Map<String, Object> var2, int var3) throws Exception;

    @Override
    public abstract String unbind(Map<String, Object> var1) throws Exception;

    public void link(Map<String, Object> model) throws Exception {
        for (String link : this.annotedLinkFields.keySet()) {
            List<Field> linkFields = this.annotedLinkFields.get(link);
            for (Field field : linkFields) {
                field.setAccessible(true);
                String toClassName = field.getType().getName();
                Object to = model.get(toClassName);
                ObjectHelper.notNull((Object)to, (String)"No @link annotation has been defined for the oject to link");
                field.set(model.get(field.getDeclaringClass().getName()), to);
            }
        }
    }

    public Map<String, Object> factory() throws Exception {
        HashMap<String, Object> mapModel = new HashMap<String, Object>();
        for (Class<?> cl : this.models) {
            Object obj = ObjectHelper.newInstance(cl);
            mapModel.put(obj.getClass().getName(), obj);
        }
        return mapModel;
    }

    protected static Integer generateKey(Integer key1, Integer key2) {
        String key2Formated = BindyAbstractFactory.getNumberFormat().format(key2.intValue());
        String keyGenerated = String.valueOf(key1) + key2Formated;
        return Integer.valueOf(keyGenerated);
    }

    private static NumberFormat getNumberFormat() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumIntegerDigits(3);
        nf.setMinimumIntegerDigits(3);
        return nf;
    }

    public static Object getDefaultValueforPrimitive(Class<?> clazz) throws Exception {
        if (clazz == Byte.TYPE) {
            return (byte)-128;
        }
        if (clazz == Short.TYPE) {
            return (short)Short.MIN_VALUE;
        }
        if (clazz == Integer.TYPE) {
            return Integer.MIN_VALUE;
        }
        if (clazz == Long.TYPE) {
            return Long.MIN_VALUE;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(Float.MIN_VALUE);
        }
        if (clazz == Double.TYPE) {
            return Double.MIN_VALUE;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    public String getCarriageReturn() {
        return this.crlf;
    }
}

