/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.camel.dataformat.bindy.PatternFormat;
import org.apache.camel.dataformat.bindy.format.FormatException;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatePatternFormat
implements PatternFormat<Date> {
    private static final transient Log LOG = LogFactory.getLog(DatePatternFormat.class);
    private String pattern;

    public DatePatternFormat() {
    }

    public DatePatternFormat(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String format(Date object) throws Exception {
        ObjectHelper.notNull((Object)this.pattern, (String)"pattern");
        return this.getDateFormat().format(object);
    }

    @Override
    public Date parse(String string) throws Exception {
        DateFormat df = this.getDateFormat();
        ObjectHelper.notNull((Object)this.pattern, (String)"pattern");
        if (string.length() <= this.pattern.length()) {
            df.setLenient(false);
            Date date = df.parse(string);
            return date;
        }
        throw new FormatException("Date provided does not fit the pattern defined");
    }

    protected DateFormat getDateFormat() {
        return new SimpleDateFormat(this.pattern, Locale.FRANCE);
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

