/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.fixed;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.bindy.BindyFixedLengthFactory;
import org.apache.camel.dataformat.bindy.util.Converter;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BindyFixedLengthDataFormat
implements DataFormat {
    private static final transient Log LOG = LogFactory.getLog(BindyFixedLengthDataFormat.class);
    private String[] packages;
    private BindyFixedLengthFactory modelFactory;

    public BindyFixedLengthDataFormat() {
    }

    public BindyFixedLengthDataFormat(String ... packages) {
        this.packages = packages;
    }

    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        ArrayList models;
        BindyFixedLengthFactory factory = this.getFactory(exchange.getContext().getPackageScanClassResolver());
        ObjectHelper.notNull((Object)factory, (String)"not instantiated");
        byte[] bytesCRLF = Converter.getByteReturn(factory.getCarriageReturn());
        if (exchange.getContext().getTypeConverter().convertTo(List.class, body) == null) {
            models = new ArrayList();
            Iterator it = ObjectHelper.createIterator((Object)body);
            while (it.hasNext()) {
                Object e = it.next();
                String name = e.getClass().getName();
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put(name, body);
                models.add(row);
            }
        } else {
            models = (ArrayList)body;
        }
        for (Map map : models) {
            String result = factory.unbind(map);
            byte[] bytes = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, (Object)result);
            outputStream.write(bytes);
            outputStream.write(bytesCRLF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        BindyFixedLengthFactory factory = this.getFactory(exchange.getContext().getPackageScanClassResolver());
        ObjectHelper.notNull((Object)factory, (String)"not instantiated");
        ArrayList<Map<String, Object>> models = new ArrayList<Map<String, Object>>();
        InputStreamReader in = new InputStreamReader(inputStream);
        Scanner scanner = new Scanner(in);
        int count = 0;
        try {
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (ObjectHelper.isEmpty((Object)line)) continue;
                ++count;
                if (line.length() < factory.recordLength() || line.length() > factory.recordLength()) {
                    throw new IllegalArgumentException("Size of the record : " + line.length() + " is not equal to the value provided in the model : " + factory.recordLength() + " !");
                }
                Map<String, Object> model = factory.factory();
                factory.bind(line, model, count);
                factory.link(model);
                models.add(model);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Graph of objects created : " + model));
            }
            if (models.size() == 0) {
                throw new IllegalArgumentException("No records have been defined in the message !");
            }
            ArrayList<Map<String, Object>> arrayList = models;
            return arrayList;
        }
        finally {
            scanner.close();
            ObjectHelper.close((Closeable)in, (String)"in", (Log)LOG);
        }
    }

    public BindyFixedLengthFactory getFactory(PackageScanClassResolver resolver) throws Exception {
        if (this.modelFactory == null) {
            this.modelFactory = new BindyFixedLengthFactory(resolver, this.packages);
        }
        return this.modelFactory;
    }

    public void setModelFactory(BindyFixedLengthFactory modelFactory) {
        this.modelFactory = modelFactory;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }
}

