/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.BindyFactory;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormatFactory;
import org.apache.camel.dataformat.bindy.annotation.DataField;
import org.apache.camel.dataformat.bindy.annotation.FixedLengthRecord;
import org.apache.camel.dataformat.bindy.annotation.Link;
import org.apache.camel.dataformat.bindy.format.FormatException;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindyFixedLengthFactory
extends BindyAbstractFactory
implements BindyFactory {
    private static final transient Log LOG = LogFactory.getLog(BindyFixedLengthFactory.class);
    boolean isOneToMany;
    private Map<Integer, DataField> dataFields = new LinkedHashMap<Integer, DataField>();
    private Map<Integer, Field> annotedFields = new LinkedHashMap<Integer, Field>();
    private Map<Integer, List> results;
    private int numberOptionalFields;
    private int numberMandatoryFields;
    private int totalFields;
    private boolean hasHeader;
    private boolean hasFooter;
    private char paddingChar;
    private int recordLength;

    public BindyFixedLengthFactory(PackageScanClassResolver resolver, String ... packageNames) throws Exception {
        super(resolver, packageNames);
        this.initFixedLengthModel();
    }

    public void initFixedLengthModel() throws Exception {
        this.initAnnotedFields();
        this.initFixedLengthRecordParameters();
    }

    @Override
    public void initAnnotedFields() {
        for (Class cl : this.models) {
            ArrayList<Field> linkFields = new ArrayList<Field>();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Class retrieved : " + cl.getName()));
            }
            for (Field field : cl.getDeclaredFields()) {
                Link linkField;
                DataField dataField = field.getAnnotation(DataField.class);
                if (dataField != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Position defined in the class : " + cl.getName() + ", position : " + dataField.pos() + ", Field : " + dataField.toString()));
                    }
                    if (dataField.required()) {
                        ++this.numberMandatoryFields;
                    } else {
                        ++this.numberOptionalFields;
                    }
                    this.dataFields.put(dataField.pos(), dataField);
                    this.annotedFields.put(dataField.pos(), field);
                }
                if ((linkField = field.getAnnotation(Link.class)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Class linked  : " + cl.getName() + ", Field" + field.toString()));
                }
                linkFields.add(field);
            }
            if (!linkFields.isEmpty()) {
                this.annotedLinkFields.put(cl.getName(), linkFields);
            }
            this.totalFields = this.numberMandatoryFields + this.numberOptionalFields;
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Number of optional fields : " + this.numberOptionalFields));
            LOG.debug((Object)("Number of mandatory fields : " + this.numberMandatoryFields));
            LOG.debug((Object)("Total : " + this.totalFields));
        }
    }

    @Override
    public void bind(List<String> data, Map<String, Object> model, int line) throws Exception {
    }

    public void bind(String record, Map<String, Object> model, int line) throws Exception {
        int pos = 1;
        int counterMandatoryFields = 0;
        StringBuilder result = new StringBuilder();
        Collection<DataField> c = this.dataFields.values();
        for (DataField dataField : c) {
            int offset = dataField.pos();
            int length = dataField.length();
            ObjectHelper.notNull((Object)offset, (String)("Position/offset is not defined for  the  field " + dataField.toString()));
            ObjectHelper.notNull((Object)offset, (String)("Length is not defined for the  field " + dataField.toString()));
            if (offset - 1 <= -1) {
                throw new IllegalArgumentException("Offset / Position of the field " + dataField.toString() + " cannot be negative !");
            }
            String token = record.substring(offset - 1, offset + length - 1);
            if (dataField.required()) {
                ++counterMandatoryFields;
                if (token.equals("")) {
                    throw new IllegalArgumentException("The mandatory field defined at the position " + pos + " is empty for the line : " + line);
                }
            }
            Field field = this.annotedFields.get(offset);
            field.setAccessible(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Pos/Offset : " + offset + ", Data : " + token + ", Field type : " + field.getType()));
            }
            String pattern = dataField.pattern();
            Format<?> format = FormatFactory.getFormat(field.getType(), pattern, dataField.precision());
            Object modelField = model.get(field.getDeclaringClass().getName());
            Object value = null;
            if (!token.equals("")) {
                try {
                    value = format.parse(token);
                }
                catch (FormatException ie) {
                    throw new IllegalArgumentException(ie.getMessage() + ", position : " + offset + ", line : " + line, ie);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Parsing error detected for field defined at the position/offset : " + offset + ", line : " + line, e);
                }
            } else {
                value = BindyFixedLengthFactory.getDefaultValueForPrimitive(field.getType());
            }
            field.set(modelField, value);
            ++pos;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Counter mandatory fields : " + counterMandatoryFields));
        }
        if (pos < this.totalFields) {
            throw new IllegalArgumentException("Some fields are missing (optional or mandatory), line : " + line);
        }
        if (counterMandatoryFields < this.numberMandatoryFields) {
            throw new IllegalArgumentException("Some mandatory fields are missing, line : " + line);
        }
    }

    @Override
    public String unbind(Map<String, Object> model) throws Exception {
        StringBuilder buffer = new StringBuilder();
        this.results = new HashMap<Integer, List>();
        for (Class clazz : this.models) {
            if (!model.containsKey(clazz.getName())) continue;
            Object obj = model.get(clazz.getName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Model object : " + obj + ", class : " + obj.getClass().getName()));
            }
            if (obj == null) continue;
            this.generateFixedLengthPositionMap(clazz, obj);
        }
        TreeMap<Integer, List> sortValues = new TreeMap<Integer, List>(this.results);
        ArrayList temp = new ArrayList();
        for (Integer key : sortValues.keySet()) {
            List val = sortValues.get(key);
            String value = (String)val.get(0);
            buffer.append(value);
        }
        return buffer.toString();
    }

    private void generateFixedLengthPositionMap(Class clazz, Object obj) throws Exception {
        String result = "";
        for (Field field : clazz.getDeclaredFields()) {
            LinkedList list;
            field.setAccessible(true);
            DataField datafield = field.getAnnotation(DataField.class);
            if (datafield == null) continue;
            if (obj != null) {
                Class<?> type = field.getType();
                String pattern = datafield.pattern();
                int precision = datafield.precision();
                Format<?> format = FormatFactory.getFormat(type, pattern, precision);
                Object value = field.get(obj);
                result = this.formatString(format, value);
                int fieldLength = datafield.length();
                String align = datafield.align();
                char paddCharField = datafield.paddingChar();
                if (fieldLength > 0) {
                    StringBuilder temp = new StringBuilder();
                    if (result.length() < fieldLength) {
                        char paddChar = paddCharField == '\u0000' ? this.paddingChar : paddCharField;
                        if (align.contains("R")) {
                            temp.append(this.generatePaddingChars(paddChar, fieldLength, result.length()));
                            temp.append(result);
                        } else if (align.contains("L")) {
                            temp.append(result);
                            temp.append(this.generatePaddingChars(paddChar, fieldLength, result.length()));
                        } else {
                            throw new IllegalArgumentException("Alignement for the " + field.getName() + " must be equal to R for RIGHT or L for LEFT !");
                        }
                        result = temp.toString();
                    }
                } else {
                    throw new IllegalArgumentException("Lenght of the field : " + field.getName() + " is a mandatory field and cannot be equal to zero or to be negative !");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Value to be formatted : " + value + ", position : " + datafield.pos() + ", and its formated value : " + result));
                }
            } else {
                result = "";
            }
            Integer key = datafield.pos();
            if (!this.results.containsKey(key)) {
                list = new LinkedList();
                list.add(result);
                this.results.put(key, list);
                continue;
            }
            list = (LinkedList)this.results.get(key);
            list.add(result);
        }
    }

    private String generatePaddingChars(char pad, int lengthField, int lengthString) {
        StringBuilder buffer = new StringBuilder();
        int size = lengthField - lengthString;
        for (int i = 0; i < size; ++i) {
            buffer.append(Character.toString(pad));
        }
        return buffer.toString();
    }

    private void initFixedLengthRecordParameters() {
        for (Class cl : this.models) {
            FixedLengthRecord record = cl.getAnnotation(FixedLengthRecord.class);
            if (record == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Fixed length record : " + record.toString()));
            }
            this.crlf = record.crlf();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Carriage return defined for the CSV : " + this.crlf));
            }
            this.hasHeader = record.hasHeader();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Has Header :  " + this.hasHeader));
            }
            this.hasFooter = record.hasFooter();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Has Footer :  " + this.hasFooter));
            }
            this.paddingChar = record.paddingChar();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Padding char :  " + this.paddingChar));
            }
            this.recordLength = record.length();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Length of the record :  " + this.recordLength));
        }
    }

    public boolean hasHeader() {
        return this.hasHeader;
    }

    public boolean hasFooter() {
        return this.hasFooter;
    }

    public char paddingchar() {
        return this.paddingChar;
    }

    public int recordLength() {
        return this.recordLength;
    }
}

