/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.camel.dataformat.bindy.PatternFormat;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NumberPatternFormat<T>
implements PatternFormat<T> {
    private String pattern;
    private Locale locale = Locale.getDefault();

    public NumberPatternFormat() {
    }

    public NumberPatternFormat(String pattern, Locale locale) {
        this.pattern = pattern;
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    @Override
    public String format(T object) throws Exception {
        ObjectHelper.notNull((Object)this.pattern, (String)"pattern");
        return this.getNumberFormat().format(object);
    }

    @Override
    public T parse(String string) throws Exception {
        ObjectHelper.notNull((Object)this.pattern, (String)"pattern");
        return (T)this.getNumberFormat().parse(string);
    }

    protected NumberFormat getNumberFormat() {
        NumberFormat format = NumberFormat.getNumberInstance(this.locale);
        if (format instanceof DecimalFormat) {
            ((DecimalFormat)format).applyLocalizedPattern(this.pattern);
        }
        return format;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

