/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.BindyFactory;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormatFactory;
import org.apache.camel.dataformat.bindy.annotation.KeyValuePairField;
import org.apache.camel.dataformat.bindy.annotation.Link;
import org.apache.camel.dataformat.bindy.annotation.Message;
import org.apache.camel.dataformat.bindy.annotation.OneToMany;
import org.apache.camel.dataformat.bindy.annotation.Section;
import org.apache.camel.dataformat.bindy.util.Converter;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindyKeyValuePairFactory
extends BindyAbstractFactory
implements BindyFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(BindyKeyValuePairFactory.class);
    private Map<Integer, KeyValuePairField> keyValuePairFields = new LinkedHashMap<Integer, KeyValuePairField>();
    private Map<Integer, Field> annotedFields = new LinkedHashMap<Integer, Field>();
    private Map<String, Integer> sections = new HashMap<String, Integer>();
    private Map<String, List> lists = new HashMap<String, List>();
    private String keyValuePairSeparator;
    private String pairSeparator;
    private boolean messageOrdered;

    public BindyKeyValuePairFactory(PackageScanClassResolver resolver, String ... packageNames) throws Exception {
        super(resolver, packageNames);
        this.initKeyValuePairModel();
    }

    public void initKeyValuePairModel() throws Exception {
        this.initAnnotatedFields();
        this.initMessageParameters();
    }

    @Override
    public void initAnnotatedFields() {
        for (Class cl : this.models) {
            ArrayList<Field> linkFields = new ArrayList<Field>();
            for (Field field : cl.getDeclaredFields()) {
                Link linkField;
                KeyValuePairField keyValuePairField = field.getAnnotation(KeyValuePairField.class);
                if (keyValuePairField != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Key declared in the class : {}, key : {}, Field : {}", new Object[]{cl.getName(), keyValuePairField.tag(), keyValuePairField});
                    }
                    this.keyValuePairFields.put(keyValuePairField.tag(), keyValuePairField);
                    this.annotedFields.put(keyValuePairField.tag(), field);
                }
                if ((linkField = field.getAnnotation(Link.class)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Class linked  : {}, Field {}", (Object)cl.getName(), (Object)field);
                }
                linkFields.add(field);
            }
            if (linkFields.isEmpty()) continue;
            this.annotatedLinkFields.put(cl.getName(), linkFields);
        }
    }

    @Override
    public void bind(List<String> data, Map<String, Object> model, int line) throws Exception {
        HashMap<Integer, List> results = new HashMap<Integer, List>();
        LOG.debug("Key value pairs data : {}", data);
        ObjectHelper.notNull((Object)this.keyValuePairSeparator, (String)"Key Value Pair not defined in the @Message annotation");
        for (String s : data) {
            LinkedList list;
            String[] keyValuePair = s.split(this.getKeyValuePairSeparator());
            int key = Integer.parseInt(keyValuePair[0]);
            String value = keyValuePair[1];
            LOG.debug("Key : {}, value : {}", (Object)key, (Object)value);
            if (!results.containsKey(key)) {
                list = new LinkedList();
                list.add(value);
                results.put(key, list);
                continue;
            }
            list = (LinkedList)results.get(key);
            list.add(value);
        }
        for (Class clazz : this.models) {
            Object obj = model.get(clazz.getName());
            if (obj == null) continue;
            this.generateModelFromKeyValueMap(clazz, obj, results, line);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateModelFromKeyValueMap(Class clazz, Object obj, Map<Integer, List> results, int line) throws Exception {
        for (Field field : clazz.getDeclaredFields()) {
            OneToMany oneToMany;
            field.setAccessible(true);
            KeyValuePairField keyValuePairField = field.getAnnotation(KeyValuePairField.class);
            if (keyValuePairField != null) {
                List l;
                Object result;
                int key = keyValuePairField.tag();
                List values = results.get(key);
                String value = null;
                if (values == null) {
                    if (obj != null) {
                        if (keyValuePairField.required()) {
                            throw new IllegalArgumentException("The mandatory key/tag : " + key + " has not been defined !");
                        }
                        result = BindyKeyValuePairFactory.getDefaultValueForPrimitive(field.getType());
                        try {
                            field.set(obj, result);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Setting of field " + field + " failed for object : " + obj + " and result : " + result);
                        }
                    }
                    l = this.lists.get(clazz.getName());
                    if (l == null) throw new IllegalArgumentException("The list of values is empty for the following key : " + key + " defined in the class : " + clazz.getName());
                    obj = !l.isEmpty() ? l.get(0) : clazz.newInstance();
                    Object result2 = BindyKeyValuePairFactory.getDefaultValueForPrimitive(field.getType());
                    try {
                        field.set(obj, result2);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Setting of field " + field + " failed for object : " + obj + " and result : " + result2);
                    }
                    if (!l.isEmpty()) {
                        l.set(0, obj);
                    } else {
                        l.add(0, obj);
                    }
                    this.lists.put(clazz.getName(), l);
                    obj = null;
                } else if (values.size() >= 1) {
                    if (obj != null) {
                        value = (String)values.get(0);
                        result = null;
                        if (value != null) {
                            String pattern = keyValuePairField.pattern();
                            Format<?> format = FormatFactory.getFormat(field.getType(), pattern, this.getLocale(), keyValuePairField.precision());
                            result = this.formatField(format, value, key, line);
                            LOG.debug("Value formated : {}", result);
                        } else {
                            result = BindyKeyValuePairFactory.getDefaultValueForPrimitive(field.getType());
                        }
                        try {
                            field.set(obj, result);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Setting of field " + field + " failed for object : " + obj + " and result : " + result);
                        }
                    }
                    l = this.lists.get(clazz.getName());
                    if (l == null) throw new IllegalArgumentException("The list of values is empty for the following key : " + key + " defined in the class : " + clazz.getName());
                    for (int i = 0; i < values.size(); ++i) {
                        obj = !l.isEmpty() && l.size() > i ? l.get(i) : clazz.newInstance();
                        value = (String)values.get(i);
                        String pattern = keyValuePairField.pattern();
                        Format<?> format = FormatFactory.getFormat(field.getType(), pattern, this.getLocale(), keyValuePairField.precision());
                        Object result3 = this.formatField(format, value, key, line);
                        LOG.debug("Value formated : {}", result3);
                        try {
                            if (value != null) {
                                field.set(obj, result3);
                            } else {
                                field.set(obj, BindyKeyValuePairFactory.getDefaultValueForPrimitive(field.getType()));
                            }
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Setting of field " + field + " failed for object : " + obj + " and result : " + result3);
                        }
                        if (!l.isEmpty() && l.size() > i) {
                            l.set(i, obj);
                        } else {
                            l.add(i, obj);
                        }
                        this.lists.put(clazz.getName(), l);
                        obj = null;
                    }
                } else {
                    result = BindyKeyValuePairFactory.getDefaultValueForPrimitive(field.getType());
                    try {
                        field.set(obj, result);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Setting of field " + field + " failed for object : " + obj + " and result : " + result);
                    }
                }
            }
            if ((oneToMany = field.getAnnotation(OneToMany.class)) == null) continue;
            String targetClass = oneToMany.mappedTo();
            if (targetClass.equals("")) throw new IllegalArgumentException("No target class has been defined in @OneToMany annotation !");
            Class<?> cl = null;
            try {
                cl = Thread.currentThread().getContextClassLoader().loadClass(targetClass);
            }
            catch (ClassNotFoundException e) {
                cl = this.getClass().getClassLoader().loadClass(targetClass);
            }
            if (!this.lists.containsKey(cl.getName())) {
                this.lists.put(cl.getName(), new ArrayList());
            }
            this.generateModelFromKeyValueMap(cl, null, results, line);
            field.set(obj, this.lists.get(cl.getName()));
        }
    }

    @Override
    public String unbind(Map<String, Object> model) throws Exception {
        StringBuilder builder = new StringBuilder();
        TreeMap<Integer, KeyValuePairField> keyValuePairFieldsSorted = new TreeMap<Integer, KeyValuePairField>(this.keyValuePairFields);
        Iterator it = keyValuePairFieldsSorted.keySet().iterator();
        TreeMap<Integer, String> positions = new TreeMap<Integer, String>();
        ObjectHelper.notNull((Object)this.pairSeparator, (String)"The pair separator has not been instantiated or property not defined in the @Message annotation");
        char separator = Converter.getCharDelimitor(this.getPairSeparator());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Separator converted : '0x{}', from : {}", (Object)Integer.toHexString(separator), (Object)this.getPairSeparator());
        }
        while (it.hasNext()) {
            String valueFormated;
            KeyValuePairField keyValuePairField = (KeyValuePairField)keyValuePairFieldsSorted.get(it.next());
            ObjectHelper.notNull((Object)keyValuePairField, (String)"KeyValuePair is null !");
            Field field = this.annotedFields.get(keyValuePairField.tag());
            field.setAccessible(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Tag : {}, Field type : {}, class : {}", new Object[]{keyValuePairField.tag(), field.getType(), field.getDeclaringClass().getName()});
            }
            Class<?> type = field.getType();
            String pattern = keyValuePairField.pattern();
            int precision = keyValuePairField.precision();
            Format<?> format = FormatFactory.getFormat(type, pattern, this.getLocale(), precision);
            Object obj = model.get(field.getDeclaringClass().getName());
            if (obj == null) continue;
            Object keyValue = field.get(obj);
            if (this.isMessageOrdered()) {
                String valueFormated2;
                Integer key1 = this.sections.get(obj.getClass().getName());
                Integer key2 = keyValuePairField.position();
                LOG.debug("Key of the section : {}, and the field  : {}", (Object)key1, (Object)key2);
                Integer keyGenerated = BindyKeyValuePairFactory.generateKey(key1, key2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Key generated : {}, for section : {}", (Object)String.valueOf(keyGenerated), (Object)key1);
                }
                if (keyValue == null) continue;
                try {
                    valueFormated2 = format.format(keyValue);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Formating error detected for the tag : " + keyValuePairField.tag(), e);
                }
                String value = keyValuePairField.tag() + this.getKeyValuePairSeparator() + valueFormated2;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Value to be formatted : {}, for the tag : {}, and its formated value : {}", new Object[]{keyValue, keyValuePairField.tag(), valueFormated2});
                }
                positions.put(keyGenerated, value);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Positions size : {}", (Object)positions.size());
                continue;
            }
            if (keyValue == null) continue;
            try {
                valueFormated = format.format(keyValue);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Formating error detected for the tag : " + keyValuePairField.tag(), e);
            }
            String value = keyValuePairField.tag() + this.getKeyValuePairSeparator() + valueFormated + separator;
            builder.append(value);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Value added : {}{}{}{}", new Object[]{keyValuePairField.tag(), this.getKeyValuePairSeparator(), valueFormated, Character.valueOf(separator)});
        }
        if (this.isMessageOrdered()) {
            Iterator posit = positions.keySet().iterator();
            while (posit.hasNext()) {
                String value = (String)positions.get(posit.next());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Value added at the position ({}) : {}{}", new Object[]{posit, value, Character.valueOf(separator)});
                }
                builder.append(value + separator);
            }
        }
        return builder.toString();
    }

    private Object formatField(Format format, String value, int tag, int line) throws Exception {
        Object obj = null;
        if (value != null) {
            try {
                obj = format.parse(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Parsing error detected for field defined at the tag : " + tag + ", line : " + line, e);
            }
        }
        return obj;
    }

    public String getPairSeparator() {
        return this.pairSeparator;
    }

    public String getKeyValuePairSeparator() {
        return this.keyValuePairSeparator;
    }

    public boolean isMessageOrdered() {
        return this.messageOrdered;
    }

    private void initMessageParameters() {
        if (this.pairSeparator == null || this.keyValuePairSeparator == null) {
            for (Class cl : this.models) {
                Message message = cl.getAnnotation(Message.class);
                Section section = cl.getAnnotation(Section.class);
                if (message != null) {
                    ObjectHelper.notNull((Object)message.pairSeparator(), (String)"No Pair Separator has been defined in the @Message annotation !");
                    this.pairSeparator = message.pairSeparator();
                    LOG.debug("Pair Separator defined for the message : {}", (Object)this.pairSeparator);
                    ObjectHelper.notNull((Object)message.keyValuePairSeparator(), (String)"No Key Value Pair Separator has been defined in the @Message annotation !");
                    this.keyValuePairSeparator = message.keyValuePairSeparator();
                    LOG.debug("Key Value Pair Separator defined for the message : {}", (Object)this.keyValuePairSeparator);
                    this.crlf = message.crlf();
                    LOG.debug("Carriage return defined for the message : {}", (Object)this.crlf);
                    this.messageOrdered = message.isOrdered();
                    LOG.debug("Is the message ordered in output : {}", (Object)this.messageOrdered);
                }
                if (section == null) continue;
                ObjectHelper.notNull((Object)section.number(), (String)"No number has been defined for the section !");
                this.sections.put(cl.getName(), section.number());
            }
        }
    }
}

