/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import org.apache.camel.CamelContext;
import org.apache.camel.core.osgi.OsgiLanguageResolver;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class BlueprintLanguageResolver
extends OsgiLanguageResolver {
    private static final transient Log LOG = LogFactory.getLog(BlueprintLanguageResolver.class);

    public BlueprintLanguageResolver(BundleContext bundleContext) {
        super(bundleContext);
    }

    public Language resolveLanguage(String name, CamelContext context) {
        try {
            Object bean = context.getRegistry().lookup(".camelBlueprint.languageResolver." + name);
            if (bean instanceof LanguageResolver) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found language resolver: " + name + " in registry: " + bean));
                }
                return ((LanguageResolver)bean).resolveLanguage(name, context);
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Ignored error looking up bean: " + name + ". Error: " + e));
        }
        return super.resolveLanguage(name, context);
    }
}

