/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.aries.blueprint.ExtendedBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableReferenceMetadata;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.spi.Registry;
import org.osgi.framework.Bundle;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.NoSuchComponentException;

public class BlueprintContainerRegistry
implements Registry {
    private final BlueprintContainer blueprintContainer;

    public BlueprintContainerRegistry(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public Object lookup(String name) {
        return this.blueprintContainer.getComponentInstance(name);
    }

    public <T> T lookup(String name, Class<T> type) {
        Object answer;
        try {
            answer = this.blueprintContainer.getComponentInstance(name);
        }
        catch (NoSuchComponentException e) {
            return null;
        }
        if (answer == null) {
            return null;
        }
        try {
            return type.cast(answer);
        }
        catch (Throwable e) {
            String msg = "Found bean: " + name + " in BlueprintContainer: " + this.blueprintContainer + " of type: " + answer.getClass().getName() + " expected type was: " + type;
            throw new NoSuchBeanException(name, msg, e);
        }
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return BlueprintContainerRegistry.lookupByType(this.blueprintContainer, type);
    }

    public static <T> Map<String, T> lookupByType(BlueprintContainer blueprintContainer, Class<T> type) {
        Object o;
        Bundle bundle;
        Class cl;
        LinkedHashMap<String, T> objects = new LinkedHashMap<String, T>();
        for (ExtendedBeanMetadata metadata : blueprintContainer.getMetadata(ExtendedBeanMetadata.class)) {
            try {
                cl = metadata.getRuntimeClass();
                if (cl == null && metadata.getClassName() != null) {
                    bundle = (Bundle)blueprintContainer.getComponentInstance("blueprintBundle");
                    cl = bundle.loadClass(metadata.getClassName());
                }
                if (cl != null && !type.isAssignableFrom(cl)) continue;
                o = blueprintContainer.getComponentInstance(metadata.getId());
                objects.put(metadata.getId(), type.cast(o));
            }
            catch (Throwable t) {}
        }
        for (ExtendedBeanMetadata metadata : blueprintContainer.getMetadata(MutableReferenceMetadata.class)) {
            try {
                cl = metadata.getRuntimeInterface();
                if (cl == null && metadata.getInterface() != null) {
                    bundle = (Bundle)blueprintContainer.getComponentInstance("blueprintBundle");
                    cl = bundle.loadClass(metadata.getInterface());
                }
                if (cl != null && !type.isAssignableFrom(cl)) continue;
                o = blueprintContainer.getComponentInstance(metadata.getId());
                objects.put(metadata.getId(), type.cast(o));
            }
            catch (Throwable t) {}
        }
        return objects;
    }
}

