/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bonita.api.util;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.apache.camel.component.bonita.api.filter.BonitaAuthFilter;
import org.apache.camel.component.bonita.api.filter.JsonClientFilter;
import org.apache.camel.component.bonita.api.model.FileInput;
import org.apache.camel.component.bonita.api.model.ProcessDefinitionResponse;
import org.apache.camel.component.bonita.api.model.UploadFileResponse;
import org.apache.camel.component.bonita.api.util.BonitaAPIConfig;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.AttachmentBuilder;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;

public class BonitaAPIUtil {
    private static BonitaAPIUtil instance;
    private WebTarget webTarget;

    public static BonitaAPIUtil getInstance(BonitaAPIConfig bonitaAPIConfig) {
        if (instance == null) {
            instance = new BonitaAPIUtil();
            ClientBuilder clientBuilder = ClientBuilder.newBuilder();
            Client client = clientBuilder.build();
            client.register(JacksonJsonProvider.class);
            client.register((Object)new JsonClientFilter());
            client.register((Object)new BonitaAuthFilter(bonitaAPIConfig));
            instance.setWebTarget(client.target(bonitaAPIConfig.getBaseBonitaURI()));
        }
        return instance;
    }

    public UploadFileResponse uploadFile(ProcessDefinitionResponse processDefinition, FileInput file) throws Exception {
        WebTarget resource = this.webTarget.path("portal/resource/process/{processName}/{processVersion}/API/formFileUpload").resolveTemplate("processName", (Object)processDefinition.getName()).resolveTemplate("processVersion", (Object)processDefinition.getVersion());
        File tempFile = Files.createTempFile("tempFile", ".tmp", new FileAttribute[0]).toFile();
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            fos.write(file.getContent());
        }
        String dispositionValue = String.format("form-data;filename=%s;name=file", tempFile.getName());
        Attachment attachment = new AttachmentBuilder().object((Object)new ByteArrayInputStream(file.getContent())).contentDisposition(new ContentDisposition(dispositionValue)).build();
        return (UploadFileResponse)resource.request().accept(new String[]{"application/json"}).post(Entity.entity((Object)attachment, (String)"multipart/form-data"), UploadFileResponse.class);
    }

    public Map<String, Serializable> prepareInputs(ProcessDefinitionResponse processDefinition, Map<String, Serializable> inputs) throws Exception {
        for (Map.Entry<String, Serializable> entry : inputs.entrySet()) {
            if (!(entry.getValue() instanceof FileInput)) continue;
            FileInput file = (FileInput)entry.getValue();
            String tmpFile = this.uploadFile(processDefinition, file).getTempPath();
            HashMap<String, String> fileInput = new HashMap<String, String>();
            fileInput.put("filename", file.getFilename());
            fileInput.put("tempPath", tmpFile);
            entry.setValue(fileInput);
        }
        return inputs;
    }

    public WebTarget getWebTarget() {
        return this.webTarget;
    }

    public void setWebTarget(WebTarget webTarget) {
        this.webTarget = webTarget;
    }
}

