/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.EventListener;
import com.box.sdk.EventStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxEventsManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxEventsManager.class);
    private BoxAPIConnection boxConnection;
    private EventStream eventStream;

    public BoxEventsManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public void listen(EventListener listener, Long startingPosition) {
        try {
            LOG.debug("Listening for events with listener=" + listener + " at startingPosition=" + startingPosition);
            if (listener == null) {
                LOG.debug("Parameter 'listener' is null: will not listen for events");
                return;
            }
            this.eventStream = startingPosition != null ? new EventStream(this.boxConnection, startingPosition.longValue()) : new EventStream(this.boxConnection);
            this.eventStream.addListener(listener);
            this.eventStream.start();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public void stopListening() {
        if (this.eventStream != null && this.eventStream.isStarted()) {
            this.eventStream.stop();
        }
        this.eventStream = null;
    }
}

