/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.osgi.DefaultMaven2OsgiConverter;
import org.apache.maven.shared.osgi.Maven2OsgiConverter;

@Mojo(name="cleanVersions", threadSafe=true)
public class VersionCleanerPlugin
extends AbstractMojo {
    @Parameter
    private Map<String, String> versions = new LinkedHashMap<String, String>();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    private Maven2OsgiConverter maven2OsgiConverter = new DefaultMaven2OsgiConverter();

    public Maven2OsgiConverter getMaven2OsgiConverter() {
        return this.maven2OsgiConverter;
    }

    public void setMaven2OsgiConverter(Maven2OsgiConverter maven2OsgiConverter) {
        this.maven2OsgiConverter = maven2OsgiConverter;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (Map.Entry<String, String> entry : this.versions.entrySet()) {
            String name = entry.getKey();
            String version = entry.getValue();
            String osgi = this.maven2OsgiConverter.getVersion(version);
            this.project.getProperties().put(name, osgi);
        }
    }
}

