/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine;

public enum EvictionType {
    SIZE_BASED("size_based"),
    TIME_BASED("time_based");

    private static EvictionType[] values;
    private final String type;

    private EvictionType(String type) {
        this.type = type;
    }

    public static EvictionType getEvictionType(String name) {
        if (name == null) {
            return null;
        }
        for (EvictionType evictionType : values) {
            if (!evictionType.toString().equalsIgnoreCase(name) && !evictionType.name().equalsIgnoreCase(name)) continue;
            return evictionType;
        }
        throw new IllegalArgumentException(String.format("Eviction type '%s' is not supported by this component.", name));
    }

    public String toString() {
        return this.type;
    }

    static {
        values = EvictionType.values();
    }
}

