/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cassandra;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.cassandra.CassandraEndpoint;
import org.apache.camel.component.cassandra.ResultSetConversionStrategies;
import org.apache.camel.component.cassandra.ResultSetConversionStrategy;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.StringHelper;

public class CassandraComponent
extends DefaultComponent {
    public CassandraComponent() {
        this(null);
    }

    public CassandraComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String beanRef = null;
        String hosts = null;
        String port = null;
        String keyspace = null;
        int pos = remaining.lastIndexOf("/");
        if (pos > 0) {
            keyspace = remaining.substring(pos + 1);
            remaining = remaining.substring(0, pos);
        }
        if (remaining.startsWith("bean:")) {
            beanRef = remaining.substring(5);
        } else if (remaining.contains(":")) {
            port = StringHelper.after((String)remaining, (String)":");
            hosts = StringHelper.before((String)remaining, (String)":");
        } else {
            hosts = remaining;
        }
        ResultSetConversionStrategy rs = null;
        String strategy = (String)this.getAndRemoveParameter(parameters, "resultSetConversionStrategy", String.class);
        if (strategy != null) {
            rs = ResultSetConversionStrategies.fromName(strategy);
        }
        CassandraEndpoint endpoint = new CassandraEndpoint(uri, (Component)this);
        endpoint.setBean(beanRef);
        endpoint.setHosts(hosts);
        if (port != null) {
            int num = CamelContextHelper.parseInteger((CamelContext)this.getCamelContext(), (String)port);
            endpoint.setPort(num);
        }
        endpoint.setKeyspace(keyspace);
        if (rs != null) {
            endpoint.setResultSetConversionStrategy(rs);
        }
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }
}

