/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.maven;

import groovy.grape.Grape;
import groovy.lang.GroovyClassLoader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.camel.catalog.VersionManager;
import org.apache.camel.catalog.maven.TimeoutHttpClientHandler;
import org.apache.ivy.util.url.URLHandler;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenVersionManager
implements VersionManager,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenVersionManager.class);
    private ClassLoader classLoader;
    private final ClassLoader groovyClassLoader = new GroovyClassLoader();
    private final TimeoutHttpClientHandler httpClient = new TimeoutHttpClientHandler();
    private String version;
    private String runtimeProviderVersion;
    private String cacheDirectory;
    private boolean log;

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setCacheDirectory(String directory) {
        this.cacheDirectory = directory;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public void setHttpClientTimeout(int timeout) {
        this.httpClient.setTimeout(timeout);
    }

    public void addMavenRepository(String name, String url) {
        HashMap<String, String> repo = new HashMap<String, String>();
        repo.put("name", name);
        repo.put("root", url);
        Grape.addResolver(repo);
    }

    public String getLoadedVersion() {
        return this.version;
    }

    public boolean loadVersion(String version) {
        try {
            URLHandlerRegistry.setDefault((URLHandler)this.httpClient);
            if (this.cacheDirectory != null) {
                System.setProperty("grape.root", this.cacheDirectory);
            }
            Grape.setEnableAutoDownload((boolean)true);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("classLoader", this.groovyClassLoader);
            param.put("group", "org.apache.camel");
            param.put("module", "camel-catalog");
            param.put("version", version);
            Grape.grab(param);
            this.version = version;
            return true;
        }
        catch (Exception e) {
            if (this.log) {
                LOGGER.warn("Cannot load version {} due {}", new Object[]{version, e.getMessage(), e});
            }
            return false;
        }
    }

    public String getRuntimeProviderLoadedVersion() {
        return this.runtimeProviderVersion;
    }

    public boolean loadRuntimeProviderVersion(String groupId, String artifactId, String version) {
        try {
            URLHandlerRegistry.setDefault((URLHandler)this.httpClient);
            Grape.setEnableAutoDownload((boolean)true);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("classLoader", this.groovyClassLoader);
            param.put("group", groupId);
            param.put("module", artifactId);
            param.put("version", version);
            Grape.grab(param);
            this.runtimeProviderVersion = version;
            return true;
        }
        catch (Exception e) {
            if (this.log) {
                LOGGER.warn("Cannot load runtime provider version {} due {}", new Object[]{version, e.getMessage(), e});
            }
            return false;
        }
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is = null;
        if (this.runtimeProviderVersion != null) {
            is = this.doGetResourceAsStream(name, this.runtimeProviderVersion);
        }
        if (is == null && this.version != null) {
            is = this.doGetResourceAsStream(name, this.version);
        }
        if (this.classLoader != null && is == null) {
            is = this.classLoader.getResourceAsStream(name);
        }
        if (is == null) {
            is = MavenVersionManager.class.getClassLoader().getResourceAsStream(name);
        }
        if (is == null) {
            is = this.groovyClassLoader.getResourceAsStream(name);
        }
        return is;
    }

    private InputStream doGetResourceAsStream(String name, String version) {
        block5: {
            if (version == null) {
                return null;
            }
            try {
                URL found = null;
                Enumeration<URL> urls = this.groovyClassLoader.getResources(name);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    if (!url.getPath().contains(version)) continue;
                    found = url;
                    break;
                }
                if (found != null) {
                    return found.openStream();
                }
            }
            catch (IOException e) {
                if (!this.log) break block5;
                LOGGER.warn("Cannot open resource {} and version {} due {}", new Object[]{name, version, e.getMessage(), e});
            }
        }
        return null;
    }

    @Override
    public void close() {
    }
}

