/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.nexus;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.Set;
import org.apache.camel.catalog.CatalogHelper;
import org.apache.camel.catalog.CollectionStringBuffer;
import org.apache.camel.catalog.connector.CamelConnectorCatalog;
import org.apache.camel.catalog.nexus.BaseNexusRepository;
import org.apache.camel.catalog.nexus.NexusArtifactDto;

public class ConnectorCatalogNexusRepository
extends BaseNexusRepository {
    private CamelConnectorCatalog camelConnectorCatalog;

    public ConnectorCatalogNexusRepository() {
        super("connector");
    }

    public CamelConnectorCatalog getCamelConnectorCatalog() {
        return this.camelConnectorCatalog;
    }

    public void setCamelConnectorCatalog(CamelConnectorCatalog camelConnectorCatalog) {
        this.camelConnectorCatalog = camelConnectorCatalog;
    }

    @Override
    public void start() {
        if (this.camelConnectorCatalog == null) {
            throw new IllegalArgumentException("CamelConnectorCatalog must be configured");
        }
        super.start();
    }

    @Override
    public void onNewArtifacts(Set<NexusArtifactDto> newArtifacts) {
        for (NexusArtifactDto dto : newArtifacts) {
            try {
                this.logger.debug("Processing new artifact: {}:{}:{}", new Object[]{dto.getGroupId(), dto.getArtifactId(), dto.getVersion()});
                String url = this.createArtifactURL(dto);
                URL jarUrl = new URL(url);
                this.addCustomCamelConnectorFromArtifact(dto, jarUrl);
            }
            catch (Throwable e) {
                this.logger.warn("Error downloading connector JAR " + dto.getArtifactLink() + ". This exception is ignored. " + e.getMessage());
            }
        }
    }

    protected void addConnector(NexusArtifactDto dto, String name, String scheme, String javaType, String description, String labels, String connectorJson, String connectorSchemaJson, String componentSchemaJson) {
        String groupId = dto.getGroupId();
        String artifactId = dto.getArtifactId();
        String version = dto.getVersion();
        this.camelConnectorCatalog.addConnector(groupId, artifactId, version, name, scheme, javaType, description, labels, connectorJson, connectorSchemaJson, componentSchemaJson);
        this.logger.info("Added connector: {}:{}:{}", new Object[]{dto.getGroupId(), dto.getArtifactId(), dto.getVersion()});
    }

    private void addCustomCamelConnectorFromArtifact(NexusArtifactDto dto, URL jarUrl) {
        try (URLClassLoader classLoader = new URLClassLoader(new URL[]{jarUrl});){
            String[] json = this.loadConnectorJSonSchema(classLoader);
            if (json != null) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode tree = mapper.readTree(json[0]);
                String name = tree.get("name").textValue();
                String scheme = tree.get("scheme").textValue();
                String javaType = tree.get("javaType").textValue();
                String description = tree.get("description").textValue();
                Iterator it = tree.withArray("labels").iterator();
                CollectionStringBuffer csb = new CollectionStringBuffer(",");
                while (it.hasNext()) {
                    String text = ((JsonNode)it.next()).textValue();
                    csb.append((Object)text);
                }
                this.addConnector(dto, name, scheme, javaType, description, csb.toString(), json[0], json[1], json[2]);
            }
        }
        catch (IOException e) {
            this.logger.warn("Error scanning JAR for custom Camel connectors", (Throwable)e);
        }
    }

    private String[] loadConnectorJSonSchema(ClassLoader classLoader) {
        InputStream is;
        String[] answer = new String[3];
        String path = "camel-connector.json";
        try {
            is = classLoader.getResourceAsStream(path);
            if (is != null) {
                answer[0] = CatalogHelper.loadText((InputStream)is);
            }
        }
        catch (Throwable e) {
            this.logger.warn("Error loading " + path + " file", e);
            return null;
        }
        path = "camel-connector-schema.json";
        try {
            is = classLoader.getResourceAsStream(path);
            if (is != null) {
                answer[1] = CatalogHelper.loadText((InputStream)is);
            }
        }
        catch (Throwable e) {
            this.logger.warn("Error loading " + path + " file", e);
            return null;
        }
        path = "camel-component-schema.json";
        try {
            is = classLoader.getResourceAsStream(path);
            if (is != null) {
                answer[2] = CatalogHelper.loadText((InputStream)is);
            }
        }
        catch (Throwable e) {
            this.logger.warn("Error loading " + path + " file", e);
            return null;
        }
        return answer;
    }
}

