/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.camel.catalog.connector.CamelConnectorCatalog;
import org.apache.camel.catalog.connector.ConnectorDto;
import org.apache.camel.catalog.connector.DefaultCamelConnectorCatalog;
import org.apache.camel.catalog.maven.DefaultMavenArtifactProvider;
import org.apache.camel.catalog.maven.MavenArtifactProvider;

@Api(value="/camel-connector-catalog", description="Camel Connector Catalog REST API")
@Path(value="/camel-connector-catalog")
public class CamelConnectorCatalogRest {
    private CamelConnectorCatalog catalog = new DefaultCamelConnectorCatalog();
    private MavenArtifactProvider maven = new DefaultMavenArtifactProvider();

    public CamelConnectorCatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(CamelConnectorCatalog catalog) {
        this.catalog = catalog;
    }

    @GET
    @Path(value="/findConnector")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all the connectors from the catalog")
    public List<ConnectorDto> findConnector(@ApiParam(value="Whether to include latest version only", defaultValue="true") @QueryParam(value="latestVersionOnly") Boolean latestVersionOnly) {
        boolean latest = latestVersionOnly != null ? latestVersionOnly : true;
        return this.catalog.findConnector(latest);
    }

    @GET
    @Path(value="/findConnector/{filter}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all the connectors from the catalog")
    public List<ConnectorDto> findConnector(@ApiParam(value="Filter the connector matching by name, description or labels") @PathParam(value="filter") String filter, @ApiParam(value="Whether to include latest version only", defaultValue="true") @QueryParam(value="latestVersionOnly") Boolean latestVersionOnly) {
        boolean latest = latestVersionOnly != null ? latestVersionOnly : true;
        return this.catalog.findConnector(latest);
    }

    @GET
    @Path(value="/connectorJSon/{groupId}/{artifactId}/{version}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns the camel-connector json file for the given connector with the Maven coordinate")
    public String connectorJSon(@ApiParam(value="Maven groupdId of the connector", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="Maven artifactId of the connector", required=true) @PathParam(value="artifactId") String artifactId, @ApiParam(value="Maven version of the connector", required=true) @PathParam(value="version") String version) {
        return this.catalog.connectorJSon(groupId, artifactId, version);
    }

    @GET
    @Path(value="/connectorSchemaJSon/{groupId}/{artifactId}/{version}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns the camel-connector-schema json file for the given connector with the Maven coordinate")
    public String connectorSchemaJSon(@ApiParam(value="Maven groupdId of the connector", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="Maven artifactId of the connector", required=true) @PathParam(value="artifactId") String artifactId, @ApiParam(value="Maven version of the connector", required=true) @PathParam(value="version") String version) {
        return this.catalog.connectorSchemaJSon(groupId, artifactId, version);
    }

    @POST
    @Path(value="/asEndpointUri/{scheme}")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates an endpoint uri in Java style configured using the provided options in the JSon body")
    public String asEndpointUri(@ApiParam(value="The component scheme", readOnly=true) @PathParam(value="scheme") String scheme, @ApiParam(value="The options as a JSon map with key/value pairs", required=true) String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(json, Map.class);
            return this.catalog.asEndpointUri(scheme, map, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    @POST
    @Path(value="/asEndpointUriXml/{scheme}")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates an endpoint uri in XML style configured using the provided options in the JSon body")
    public String asEndpointUriXml(@ApiParam(value="The component scheme", readOnly=true) @PathParam(value="scheme") String scheme, @ApiParam(value="The options as a JSon map with key/value pairs", required=true) String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(json, Map.class);
            return this.catalog.asEndpointUriXml(scheme, map, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    @POST
    @Path(value="/mavenCacheDirectory/{name}")
    @ApiOperation(value="Configures the Maven cache directory to use when downloading artifacts")
    public void mavenCacheDirectory(@ApiParam(value="The name of the cache directory", required=true) @PathParam(value="name") String name) {
        this.maven.setCacheDirectory(name);
    }

    @POST
    @Path(value="/addMavenRepository/{name}/{url}")
    @ApiOperation(value="Adds a third party Maven repository to use for downloading Maven artifacts")
    public void addMavenRepository(@ApiParam(value="The name of the Maven repository", required=true) @PathParam(value="name") String name, @ApiParam(value="The URL of the Maven repository", required=true) @PathParam(value="url") String url) {
        this.maven.addMavenRepository(name, url);
    }

    @POST
    @Path(value="/addConnectorFromMavenArtifact/{groupId}/{artifactId}/{version}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Downloads the Maven artifact and scan for custom Camel connectors which will be added to the catalog and returns the names of the found connectors")
    public Set<String> addConnectorFromMavenArtifact(@ApiParam(value="The Maven groupId", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="The Maven artifactId", required=true) @PathParam(value="artifactId") String artifactId, @ApiParam(value="The Maven version", required=true) @PathParam(value="version") String version) {
        return this.maven.addArtifactToCatalog(null, this.catalog, groupId, artifactId, version);
    }
}

