/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.catalog.URISupport;

public class EndpointValidationResult
implements Serializable {
    private final String uri;
    private int errors;
    private String syntaxError;
    private String unknownComponent;
    private String incapable;
    private Set<String> unknown;
    private Map<String, String[]> unknownSuggestions;
    private Set<String> lenient;
    private Set<String> notConsumerOnly;
    private Set<String> notProducerOnly;
    private Set<String> required;
    private Set<String> deprecated;
    private Map<String, String> invalidEnum;
    private Map<String, String[]> invalidEnumChoices;
    private Map<String, String[]> invalidEnumSuggestions;
    private Map<String, String> invalidReference;
    private Map<String, String> invalidBoolean;
    private Map<String, String> invalidInteger;
    private Map<String, String> invalidNumber;
    private Map<String, String> defaultValues;

    public EndpointValidationResult() {
        this(null);
    }

    public EndpointValidationResult(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean hasErrors() {
        return this.errors > 0;
    }

    public int getNumberOfErrors() {
        return this.errors;
    }

    public boolean isSuccess() {
        boolean ok;
        boolean bl = ok = this.syntaxError == null && this.unknownComponent == null && this.incapable == null && this.unknown == null && this.required == null;
        if (ok) {
            boolean bl2 = ok = this.notConsumerOnly == null && this.notProducerOnly == null;
        }
        if (ok) {
            ok = this.invalidEnum == null && this.invalidEnumChoices == null && this.invalidReference == null && this.invalidBoolean == null && this.invalidInteger == null && this.invalidNumber == null;
        }
        return ok;
    }

    public void addSyntaxError(String syntaxError) {
        this.syntaxError = syntaxError;
        ++this.errors;
    }

    public void addIncapable(String uri) {
        this.incapable = uri;
        ++this.errors;
    }

    public void addUnknownComponent(String name) {
        this.unknownComponent = name;
        ++this.errors;
    }

    public void addUnknown(String name) {
        if (this.unknown == null) {
            this.unknown = new LinkedHashSet<String>();
        }
        if (!this.unknown.contains(name)) {
            this.unknown.add(name);
            ++this.errors;
        }
    }

    public void addUnknownSuggestions(String name, String[] suggestions) {
        if (this.unknownSuggestions == null) {
            this.unknownSuggestions = new LinkedHashMap<String, String[]>();
        }
        this.unknownSuggestions.put(name, suggestions);
    }

    public void addLenient(String name) {
        if (this.lenient == null) {
            this.lenient = new LinkedHashSet<String>();
        }
        if (!this.lenient.contains(name)) {
            this.lenient.add(name);
        }
    }

    public void addRequired(String name) {
        if (this.required == null) {
            this.required = new LinkedHashSet<String>();
        }
        if (!this.required.contains(name)) {
            this.required.add(name);
            ++this.errors;
        }
    }

    public void addDeprecated(String name) {
        if (this.deprecated == null) {
            this.deprecated = new LinkedHashSet<String>();
        }
        if (!this.deprecated.contains(name)) {
            this.deprecated.add(name);
        }
    }

    public void addInvalidEnum(String name, String value) {
        if (this.invalidEnum == null) {
            this.invalidEnum = new LinkedHashMap<String, String>();
        }
        if (!this.invalidEnum.containsKey(name)) {
            this.invalidEnum.put(name, value);
            ++this.errors;
        }
    }

    public void addInvalidEnumChoices(String name, String[] choices) {
        if (this.invalidEnumChoices == null) {
            this.invalidEnumChoices = new LinkedHashMap<String, String[]>();
        }
        this.invalidEnumChoices.put(name, choices);
    }

    public void addInvalidEnumSuggestions(String name, String[] suggestions) {
        if (this.invalidEnumSuggestions == null) {
            this.invalidEnumSuggestions = new LinkedHashMap<String, String[]>();
        }
        this.invalidEnumSuggestions.put(name, suggestions);
    }

    public void addInvalidReference(String name, String value) {
        if (this.invalidReference == null) {
            this.invalidReference = new LinkedHashMap<String, String>();
        }
        if (!this.invalidReference.containsKey(name)) {
            this.invalidReference.put(name, value);
            ++this.errors;
        }
    }

    public void addInvalidBoolean(String name, String value) {
        if (this.invalidBoolean == null) {
            this.invalidBoolean = new LinkedHashMap<String, String>();
        }
        if (!this.invalidBoolean.containsKey(name)) {
            this.invalidBoolean.put(name, value);
            ++this.errors;
        }
    }

    public void addInvalidInteger(String name, String value) {
        if (this.invalidInteger == null) {
            this.invalidInteger = new LinkedHashMap<String, String>();
        }
        if (!this.invalidInteger.containsKey(name)) {
            this.invalidInteger.put(name, value);
            ++this.errors;
        }
    }

    public void addInvalidNumber(String name, String value) {
        if (this.invalidNumber == null) {
            this.invalidNumber = new LinkedHashMap<String, String>();
        }
        if (!this.invalidNumber.containsKey(name)) {
            this.invalidNumber.put(name, value);
            ++this.errors;
        }
    }

    public void addDefaultValue(String name, String value) {
        if (this.defaultValues == null) {
            this.defaultValues = new LinkedHashMap<String, String>();
        }
        this.defaultValues.put(name, value);
    }

    public void addNotConsumerOnly(String name) {
        if (this.notConsumerOnly == null) {
            this.notConsumerOnly = new LinkedHashSet<String>();
        }
        if (!this.notConsumerOnly.contains(name)) {
            this.notConsumerOnly.add(name);
            ++this.errors;
        }
    }

    public void addNotProducerOnly(String name) {
        if (this.notProducerOnly == null) {
            this.notProducerOnly = new LinkedHashSet<String>();
        }
        if (!this.notProducerOnly.contains(name)) {
            this.notProducerOnly.add(name);
            ++this.errors;
        }
    }

    public String getSyntaxError() {
        return this.syntaxError;
    }

    public String getIncapable() {
        return this.incapable;
    }

    public Set<String> getUnknown() {
        return this.unknown;
    }

    public Set<String> getLenient() {
        return this.lenient;
    }

    public Map<String, String[]> getUnknownSuggestions() {
        return this.unknownSuggestions;
    }

    public String getUnknownComponent() {
        return this.unknownComponent;
    }

    public Set<String> getRequired() {
        return this.required;
    }

    public Set<String> getDeprecated() {
        return this.deprecated;
    }

    public Map<String, String> getInvalidEnum() {
        return this.invalidEnum;
    }

    public Map<String, String[]> getInvalidEnumChoices() {
        return this.invalidEnumChoices;
    }

    public List<String> getEnumChoices(String optionName) {
        String[] enums;
        if (this.invalidEnumChoices != null && (enums = this.invalidEnumChoices.get(optionName)) != null) {
            return Arrays.asList(enums);
        }
        return Collections.emptyList();
    }

    public Map<String, String> getInvalidReference() {
        return this.invalidReference;
    }

    public Map<String, String> getInvalidBoolean() {
        return this.invalidBoolean;
    }

    public Map<String, String> getInvalidInteger() {
        return this.invalidInteger;
    }

    public Map<String, String> getInvalidNumber() {
        return this.invalidNumber;
    }

    public Map<String, String> getDefaultValues() {
        return this.defaultValues;
    }

    public Set<String> getNotConsumerOnly() {
        return this.notConsumerOnly;
    }

    public Set<String> getNotProducerOnly() {
        return this.notProducerOnly;
    }

    public String summaryErrorMessage(boolean includeHeader) {
        return this.summaryErrorMessage(includeHeader, true);
    }

    public String summaryErrorMessage(boolean includeHeader, boolean ignoreDeprecated) {
        boolean ok = this.isSuccess();
        if (ok && !ignoreDeprecated) {
            boolean bl = ok = this.deprecated == null;
        }
        if (ok) {
            return null;
        }
        if (this.incapable != null) {
            return "\tIncapable of parsing uri: " + this.incapable;
        }
        if (this.syntaxError != null) {
            return "\tSyntax error: " + this.syntaxError;
        }
        if (this.unknownComponent != null) {
            return "\tUnknown component: " + this.unknownComponent;
        }
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        if (this.unknown != null) {
            for (String string : this.unknown) {
                if (this.unknownSuggestions != null && this.unknownSuggestions.containsKey(string)) {
                    String[] suggestions = this.unknownSuggestions.get(string);
                    if (suggestions != null && suggestions.length > 0) {
                        String str = Arrays.asList(suggestions).toString();
                        options.put(string, "Unknown option. Did you mean: " + str);
                        continue;
                    }
                    options.put(string, "Unknown option");
                    continue;
                }
                options.put(string, "Unknown option");
            }
        }
        if (this.notConsumerOnly != null) {
            for (String string : this.notConsumerOnly) {
                options.put(string, "Option not applicable in consumer only mode");
            }
        }
        if (this.notProducerOnly != null) {
            for (String string : this.notProducerOnly) {
                options.put(string, "Option not applicable in producer only mode");
            }
        }
        if (this.required != null) {
            for (String string : this.required) {
                options.put(string, "Missing required option");
            }
        }
        if (this.deprecated != null) {
            for (String string : this.deprecated) {
                options.put(string, "Deprecated option");
            }
        }
        if (this.invalidEnum != null) {
            for (Map.Entry entry : this.invalidEnum.entrySet()) {
                String[] suggestions;
                String name = (String)entry.getKey();
                String[] choices = this.invalidEnumChoices.get(name);
                String defaultValue = this.defaultValues != null ? this.defaultValues.get(entry.getKey()) : null;
                String str = Arrays.asList(choices).toString();
                String msg = "Invalid enum value: " + (String)entry.getValue() + ". Possible values: " + str;
                if (this.invalidEnumSuggestions != null && (suggestions = this.invalidEnumSuggestions.get(name)) != null && suggestions.length > 0) {
                    str = Arrays.asList(suggestions).toString();
                    msg = msg + ". Did you mean: " + str;
                }
                if (defaultValue != null) {
                    msg = msg + ". Default value: " + defaultValue;
                }
                options.put((String)entry.getKey(), msg);
            }
        }
        if (this.invalidReference != null) {
            for (Map.Entry entry : this.invalidReference.entrySet()) {
                boolean empty = URISupport.isEmpty(entry.getValue());
                if (empty) {
                    options.put((String)entry.getKey(), "Empty reference value");
                    continue;
                }
                if (!((String)entry.getValue()).startsWith("#")) {
                    options.put((String)entry.getKey(), "Invalid reference value: " + (String)entry.getValue() + " must start with #");
                    continue;
                }
                options.put((String)entry.getKey(), "Invalid reference value: " + (String)entry.getValue());
            }
        }
        if (this.invalidBoolean != null) {
            for (Map.Entry entry : this.invalidBoolean.entrySet()) {
                boolean empty = URISupport.isEmpty(entry.getValue());
                if (empty) {
                    options.put((String)entry.getKey(), "Empty boolean value");
                    continue;
                }
                options.put((String)entry.getKey(), "Invalid boolean value: " + (String)entry.getValue());
            }
        }
        if (this.invalidInteger != null) {
            for (Map.Entry entry : this.invalidInteger.entrySet()) {
                boolean empty = URISupport.isEmpty(entry.getValue());
                if (empty) {
                    options.put((String)entry.getKey(), "Empty integer value");
                    continue;
                }
                options.put((String)entry.getKey(), "Invalid integer value: " + (String)entry.getValue());
            }
        }
        if (this.invalidNumber != null) {
            for (Map.Entry entry : this.invalidNumber.entrySet()) {
                boolean empty = URISupport.isEmpty(entry.getValue());
                if (empty) {
                    options.put((String)entry.getKey(), "Empty number value");
                    continue;
                }
                options.put((String)entry.getKey(), "Invalid number value: " + (String)entry.getValue());
            }
        }
        int maxLen = 24;
        for (String key : options.keySet()) {
            maxLen = Math.max(maxLen, key.length());
        }
        String string = "%" + maxLen + "s    %s";
        StringBuilder sb = new StringBuilder();
        if (includeHeader) {
            sb.append("Endpoint validator error\n");
            sb.append("---------------------------------------------------------------------------------------------------------------------------------------\n");
            sb.append("\n");
        }
        if (this.uri != null) {
            sb.append("\t").append(this.uri).append("\n");
        } else {
            sb.append("\n");
        }
        for (Map.Entry option : options.entrySet()) {
            String out = String.format(string, option.getKey(), option.getValue());
            sb.append("\n\t").append(out);
        }
        return sb.toString();
    }
}

