/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cbor;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.WrappedFile;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.CastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dataformat(value="cbor")
public class CBORDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(CBORDataFormat.class);
    private CamelContext camelContext;
    private ObjectMapper objectMapper;
    private String unmarshalTypeName;
    private Class<?> unmarshalType;
    private boolean useDefaultObjectMapper = true;
    private boolean allowUnmarshallType;
    private String collectionTypeName;
    private Class<? extends Collection> collectionType;
    private boolean useList;
    private boolean prettyPrint;
    private boolean allowJmsType;
    private String enableFeatures;
    private String disableFeatures;
    private boolean enableJacksonTypeConverter;

    public CBORDataFormat() {
    }

    public CBORDataFormat(ObjectMapper objectMapper, Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
        this.objectMapper = objectMapper;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        stream.write(this.objectMapper.writeValueAsBytes(graph));
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.unmarshal(exchange, (Object)stream);
    }

    public Object unmarshal(Exchange exchange, Object body) throws Exception {
        Object answer;
        ObjectReader reader;
        Class clazz = this.unmarshalType;
        String type = null;
        if (this.allowUnmarshallType) {
            type = (String)exchange.getIn().getHeader("CamelCBORUnmarshalType", String.class);
        }
        if (type == null && this.isAllowJmsType()) {
            type = (String)exchange.getIn().getHeader("JMSType", String.class);
        }
        if (type != null) {
            clazz = exchange.getContext().getClassResolver().resolveMandatoryClass(type);
        }
        if (this.collectionType != null) {
            CollectionType collType = this.objectMapper.getTypeFactory().constructCollectionType(this.collectionType, clazz);
            reader = this.objectMapper.readerFor((JavaType)collType);
        } else {
            reader = this.objectMapper.readerFor(clazz);
        }
        if (body instanceof WrappedFile) {
            body = ((WrappedFile)body).getBody();
        }
        if (body instanceof String) {
            String b = (String)body;
            answer = reader.readValue(b);
        } else if (body instanceof byte[]) {
            byte[] arr = (byte[])body;
            answer = reader.readValue(arr);
        } else if (body instanceof Reader) {
            Reader r = (Reader)body;
            answer = reader.readValue(r);
        } else if (body instanceof File) {
            File f = (File)body;
            answer = reader.readValue(f);
        } else if (body instanceof JsonNode) {
            JsonNode n = (JsonNode)body;
            answer = reader.readValue(n);
        } else {
            InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, body);
            answer = reader.readValue(is);
        }
        return answer;
    }

    public String getDataFormatName() {
        return "cbor";
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public boolean isAllowUnmarshallType() {
        return this.allowUnmarshallType;
    }

    public void setAllowUnmarshallType(boolean allowUnmarshallType) {
        this.allowUnmarshallType = allowUnmarshallType;
    }

    public String getCollectionTypeName() {
        return this.collectionTypeName;
    }

    public void setCollectionTypeName(String collectionTypeName) {
        this.collectionTypeName = collectionTypeName;
    }

    public Class<? extends Collection> getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Class<? extends Collection> collectionType) {
        this.collectionType = collectionType;
    }

    public boolean isUseList() {
        return this.useList;
    }

    public void setUseList(boolean useList) {
        this.useList = useList;
    }

    public boolean isUseDefaultObjectMapper() {
        return this.useDefaultObjectMapper;
    }

    public void setUseDefaultObjectMapper(boolean useDefaultObjectMapper) {
        this.useDefaultObjectMapper = useDefaultObjectMapper;
    }

    public void useList() {
        this.setCollectionType(ArrayList.class);
    }

    public void useMap() {
        this.setCollectionType(null);
        this.setUnmarshalType(HashMap.class);
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setAllowJmsType(boolean allowJmsType) {
        this.allowJmsType = allowJmsType;
    }

    public boolean isAllowJmsType() {
        return this.allowJmsType;
    }

    public String getEnableFeatures() {
        return this.enableFeatures;
    }

    public boolean isEnableJacksonTypeConverter() {
        return this.enableJacksonTypeConverter;
    }

    public void setEnableJacksonTypeConverter(boolean enableJacksonTypeConverter) {
        this.enableJacksonTypeConverter = enableJacksonTypeConverter;
    }

    public void setEnableFeatures(String enableFeatures) {
        this.enableFeatures = enableFeatures;
    }

    public String getDisableFeatures() {
        return this.disableFeatures;
    }

    public void setDisableFeatures(String disableFeatures) {
        this.disableFeatures = disableFeatures;
    }

    public void enableFeature(SerializationFeature feature) {
        this.enableFeatures = this.enableFeatures == null ? feature.name() : this.enableFeatures + "," + feature.name();
    }

    public void enableFeature(DeserializationFeature feature) {
        this.enableFeatures = this.enableFeatures == null ? feature.name() : this.enableFeatures + "," + feature.name();
    }

    public void enableFeature(MapperFeature feature) {
        this.enableFeatures = this.enableFeatures == null ? feature.name() : this.enableFeatures + "," + feature.name();
    }

    public void disableFeature(SerializationFeature feature) {
        this.disableFeatures = this.disableFeatures == null ? feature.name() : this.disableFeatures + "," + feature.name();
    }

    public void disableFeature(DeserializationFeature feature) {
        this.disableFeatures = this.disableFeatures == null ? feature.name() : this.disableFeatures + "," + feature.name();
    }

    public void disableFeature(MapperFeature feature) {
        this.disableFeatures = this.disableFeatures == null ? feature.name() : this.disableFeatures + "," + feature.name();
    }

    protected void doInit() throws Exception {
        MapperFeature mf;
        DeserializationFeature df;
        SerializationFeature sf;
        Iterator it;
        super.doInit();
        if (this.unmarshalTypeName != null && this.unmarshalType == null) {
            this.unmarshalType = this.camelContext.getClassResolver().resolveClass(this.unmarshalTypeName);
        }
        if (this.collectionTypeName != null && this.collectionType == null) {
            Class clazz = this.camelContext.getClassResolver().resolveClass(this.collectionTypeName);
            this.collectionType = CastUtils.cast((Class)clazz);
        }
        if (this.objectMapper == null) {
            if (this.useDefaultObjectMapper && this.camelContext != null) {
                Set set = this.camelContext.getRegistry().findByType(ObjectMapper.class);
                if ((set = set.stream().filter(om -> om.getFactory() instanceof CBORFactory).collect(Collectors.toSet())).size() == 1) {
                    this.objectMapper = (ObjectMapper)set.iterator().next();
                    LOG.info("Found a single ObjectMapper with a CBORFactory in the registry, so promoting it as the default ObjectMapper: {}", (Object)this.objectMapper);
                } else {
                    LOG.debug("Found {} ObjectMapper with a CBORFactory in the registry, so cannot promote any as the default ObjectMapper.", (Object)set.size());
                }
            }
            if (this.objectMapper == null) {
                CBORFactory factory = new CBORFactory();
                this.objectMapper = new ObjectMapper((JsonFactory)factory);
                LOG.debug("Creating new ObjectMapper to use: {}", (Object)this.objectMapper);
            }
        }
        if (this.useList) {
            this.setCollectionType(ArrayList.class);
        }
        if (this.prettyPrint) {
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        if (this.enableFeatures != null) {
            it = ObjectHelper.createIterator((Object)this.enableFeatures);
            while (it.hasNext()) {
                String enable = it.next().toString();
                sf = (SerializationFeature)this.getCamelContext().getTypeConverter().tryConvertTo(SerializationFeature.class, (Object)enable);
                if (sf != null) {
                    this.objectMapper.enable(sf);
                    continue;
                }
                df = (DeserializationFeature)this.getCamelContext().getTypeConverter().tryConvertTo(DeserializationFeature.class, (Object)enable);
                if (df != null) {
                    this.objectMapper.enable(df);
                    continue;
                }
                mf = (MapperFeature)this.getCamelContext().getTypeConverter().tryConvertTo(MapperFeature.class, (Object)enable);
                if (mf != null) {
                    this.objectMapper.enable(new MapperFeature[]{mf});
                    continue;
                }
                throw new IllegalArgumentException("Enable feature: " + enable + " cannot be converted to an accepted enum of types [SerializationFeature,DeserializationFeature,MapperFeature]");
            }
        }
        if (this.disableFeatures != null) {
            it = ObjectHelper.createIterator((Object)this.disableFeatures);
            while (it.hasNext()) {
                String disable = it.next().toString();
                sf = (SerializationFeature)this.getCamelContext().getTypeConverter().tryConvertTo(SerializationFeature.class, (Object)disable);
                if (sf != null) {
                    this.objectMapper.disable(sf);
                    continue;
                }
                df = (DeserializationFeature)this.getCamelContext().getTypeConverter().tryConvertTo(DeserializationFeature.class, (Object)disable);
                if (df != null) {
                    this.objectMapper.disable(df);
                    continue;
                }
                mf = (MapperFeature)this.getCamelContext().getTypeConverter().tryConvertTo(MapperFeature.class, (Object)disable);
                if (mf != null) {
                    this.objectMapper.disable(new MapperFeature[]{mf});
                    continue;
                }
                throw new IllegalArgumentException("Disable feature: " + disable + " cannot be converted to an accepted enum of types [SerializationFeature,DeserializationFeature,MapperFeature]");
            }
        }
    }

    protected void doStop() throws Exception {
    }
}

