/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.camel.cdi.Vetoed;

@Vetoed
final class BeanManagerHelper {
    private BeanManagerHelper() {
    }

    static <T> Set<T> getReferencesByType(BeanManager manager, Class<T> type, Annotation ... qualifiers) {
        return manager.getBeans(type, qualifiers).stream().map(bean -> BeanManagerHelper.getReference(manager, type, bean)).collect(Collectors.toSet());
    }

    static <T> Optional<T> getReferenceByName(BeanManager manager, String name, Class<T> type) {
        return Optional.of(manager.getBeans(name)).map(arg_0 -> ((BeanManager)manager).resolve(arg_0)).map(bean -> BeanManagerHelper.getReference(manager, type, bean));
    }

    static <T> Optional<T> getReferenceByType(BeanManager manager, Class<T> type, Annotation ... qualifiers) {
        return Optional.of(manager.getBeans(type, qualifiers)).map(arg_0 -> ((BeanManager)manager).resolve(arg_0)).map(bean -> BeanManagerHelper.getReference(manager, type, bean));
    }

    static <T> T getReference(BeanManager manager, Class<T> type, Bean<?> bean) {
        return type.cast(manager.getReference(bean, type, manager.createCreationalContext(bean)));
    }
}

