/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.net.URL;
import org.apache.camel.cdi.Vetoed;

@Vetoed
final class ResourceHelper {
    private ResourceHelper() {
    }

    static URL getResource(String path, ClassLoader classLoader) {
        URL url = ResourceHelper.loadResource(path, classLoader);
        if (url != null) {
            return url;
        }
        url = ResourceHelper.loadResource(path, Thread.currentThread().getContextClassLoader());
        if (url != null) {
            return url;
        }
        url = ResourceHelper.loadResource(path, ResourceHelper.class.getClassLoader());
        if (url != null) {
            return url;
        }
        return ResourceHelper.loadResource(path, ClassLoader.getSystemClassLoader());
    }

    private static URL loadResource(String path, ClassLoader classLoader) {
        if (classLoader != null) {
            return classLoader.getResource(path);
        }
        return null;
    }
}

