/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.chronicle.engine;

import java.lang.ref.WeakReference;
import java.util.function.Supplier;
import org.apache.camel.Message;
import org.apache.camel.util.ObjectHelper;

public final class ChronicleEngineHelper {
    private ChronicleEngineHelper() {
    }

    public static Object mandatoryHeader(Message message, String header) {
        return ObjectHelper.notNull((Object)message.getHeader(header), (String)header);
    }

    public static Object mandatoryKey(Message message) {
        return ChronicleEngineHelper.mandatoryHeader(message, "ChronicleEngineKey");
    }

    public static Object mandatoryBody(Message message) {
        return ObjectHelper.notNull((Object)message.getBody(), (String)"ChronicleEngineValue");
    }

    public static final class WeakRef<T> {
        private final Supplier<T> supplier;
        private WeakReference<T> ref;

        public WeakRef(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        public synchronized T get() {
            Object rv = this.ref.get();
            if (rv == null) {
                rv = this.supplier.get();
                this.ref = new WeakReference<T>(rv);
            }
            return rv;
        }

        public static <T> WeakRef<T> create(Supplier<T> supplier) {
            return new WeakRef<T>(supplier);
        }
    }
}

