/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.chunk;

import com.x5.template.Chunk;
import com.x5.template.Theme;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.chunk.ChunkConstants;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ExchangeHelper;
import org.apache.commons.io.IOUtils;

@UriEndpoint(firstVersion="2.15.0", scheme="chunk", title="Chunk", syntax="chunk:resourceUri", producerOnly=true, category={Category.TRANSFORMATION}, headersClass=ChunkConstants.class)
public class ChunkEndpoint
extends ResourceEndpoint {
    private Theme theme;
    private Chunk chunk;
    @UriParam(defaultValue="false")
    private boolean allowTemplateFromHeader;
    @UriParam(description="Define the encoding of the body")
    private String encoding;
    @UriParam(description="Define the themes folder to scan")
    private String themeFolder;
    @UriParam(description="Define the themes subfolder to scan")
    private String themeSubfolder;
    @UriParam(description="Define the theme layer to elaborate")
    private String themeLayer;
    @UriParam(description="Define the file extension of the template")
    private String extension;

    public ChunkEndpoint() {
    }

    public ChunkEndpoint(String endpointUri, Component component, String resourceUri) {
        super(endpointUri, component, resourceUri);
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "chunk:" + this.getResourceUri();
    }

    public void clearContentCache() {
        this.chunk = null;
        super.clearContentCache();
    }

    protected void onExchange(Exchange exchange) throws Exception {
        String newResourceUri = null;
        if (this.allowTemplateFromHeader) {
            newResourceUri = (String)exchange.getIn().getHeader("ChunkResourceUri", String.class);
        }
        if (newResourceUri == null) {
            Chunk newChunk;
            String newTemplate = null;
            if (this.allowTemplateFromHeader) {
                newTemplate = (String)exchange.getIn().getHeader("ChunkTemplate", String.class);
            }
            if (newTemplate == null) {
                boolean fromTemplate = false;
                newChunk = this.getOrCreateChunk(this.theme, fromTemplate);
            } else {
                boolean fromTemplate = true;
                newChunk = this.createChunk(new StringReader(newTemplate), this.theme, fromTemplate);
                exchange.getIn().removeHeader("ChunkTemplate");
            }
            Map variableMap = ExchangeHelper.createVariableMap((Exchange)exchange, (boolean)this.isAllowContextMapAll());
            StringWriter writer = new StringWriter();
            newChunk.putAll(variableMap);
            newChunk.render((Writer)writer);
            writer.flush();
            ExchangeHelper.setInOutBodyPatternAware((Exchange)exchange, (Object)newChunk.toString());
        } else {
            exchange.getIn().removeHeader("ChunkResourceUri");
            ChunkEndpoint newEndpoint = (ChunkEndpoint)this.getCamelContext().getEndpoint("chunk:" + newResourceUri, ChunkEndpoint.class);
            newEndpoint.onExchange(exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Chunk createChunk(Reader resourceReader, Theme theme, boolean fromTemplate) throws IOException {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        try {
            String targetString;
            Chunk newChunk;
            ClassLoader apcl = this.getCamelContext().getApplicationContextClassLoader();
            if (apcl != null) {
                Thread.currentThread().setContextClassLoader(apcl);
            }
            if (fromTemplate) {
                newChunk = theme.makeChunk();
                targetString = IOUtils.toString((Reader)resourceReader);
                newChunk.append(targetString);
            } else {
                targetString = IOUtils.toString((Reader)resourceReader);
                newChunk = theme.makeChunk(targetString);
            }
            Chunk chunk = newChunk;
            return chunk;
        }
        finally {
            resourceReader.close();
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    private Chunk getOrCreateChunk(Theme theme, boolean fromTemplate) throws IOException {
        if (this.chunk == null) {
            this.chunk = this.createChunk(new StringReader(this.getResourceUriExtended()), theme, fromTemplate);
        }
        return this.chunk;
    }

    private Theme getOrCreateTheme() {
        if (this.theme == null) {
            ClassLoader apcl;
            URL url;
            if (this.themeFolder == null && this.themeSubfolder == null) {
                this.theme = new Theme();
            } else if (this.themeFolder != null && this.themeSubfolder == null) {
                url = this.getCamelContext().getClassResolver().loadResourceAsURL(this.themeFolder);
                this.theme = new Theme(url.getPath(), "");
            } else {
                url = this.getCamelContext().getClassResolver().loadResourceAsURL(this.themeFolder);
                this.theme = new Theme(url.getPath(), this.themeSubfolder);
            }
            if (this.encoding != null) {
                this.theme.setEncoding(this.encoding);
            }
            if ((apcl = this.getCamelContext().getApplicationContextClassLoader()) != null) {
                this.theme.setJarContext((Object)apcl);
            }
        }
        return this.theme;
    }

    public String getResourceUri() {
        String uri = super.getResourceUri();
        if (uri != null && (uri.startsWith("/") || uri.startsWith("\\"))) {
            return uri.substring(1);
        }
        return uri;
    }

    private String getResourceUriExtended() {
        return this.themeLayer == null ? this.getResourceUri() : this.getResourceUri() + "#" + this.themeLayer;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getThemeFolder() {
        return this.themeFolder;
    }

    public void setThemeFolder(String themeFolder) {
        this.themeFolder = themeFolder;
    }

    public String getThemeSubfolder() {
        return this.themeSubfolder;
    }

    public void setThemeSubfolder(String themeSubfolder) {
        this.themeSubfolder = themeSubfolder;
    }

    public String getThemeLayer() {
        return this.themeLayer;
    }

    public void setThemeLayer(String themeLayer) {
        this.themeLayer = themeLayer;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.theme == null) {
            this.theme = this.getOrCreateTheme();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
    }
}

