/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cmis;

import java.io.InputStream;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.cmis.CMISEndpoint;
import org.apache.camel.component.cmis.CMISSessionFacade;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMISConsumer
extends ScheduledPollConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(CMISConsumer.class);
    private CMISSessionFacade sessionFacade;

    public CMISConsumer(CMISEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public CMISConsumer(CMISEndpoint cmisEndpoint, Processor processor, CMISSessionFacade sessionFacade) {
        this(cmisEndpoint, processor);
        this.sessionFacade = sessionFacade;
    }

    protected int poll() throws Exception {
        return this.sessionFacade.poll(this);
    }

    public OperationContext createOperationContext() {
        return this.sessionFacade.createOperationContext();
    }

    int sendExchangeWithPropsAndBody(Map<String, Object> properties, InputStream inputStream) throws Exception {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setHeaders(properties);
        exchange.getIn().setBody((Object)inputStream);
        LOG.debug("Polling node : {}", properties.get("cmis:name"));
        this.getProcessor().process(exchange);
        return 1;
    }
}

