/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cmis;

import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.cmis.CMISEndpoint;
import org.apache.camel.component.cmis.CMISSessionFacade;
import org.apache.camel.impl.DefaultProducer;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.QueryResult;

public class CMISQueryProducer
extends DefaultProducer {
    private final CMISSessionFacade cmisSessionFacade;

    public CMISQueryProducer(CMISEndpoint endpoint, CMISSessionFacade cmisSessionFacade) {
        super((Endpoint)endpoint);
        this.cmisSessionFacade = cmisSessionFacade;
    }

    public void process(Exchange exchange) throws Exception {
        List<Map<String, Object>> nodes = this.executeQuery(exchange);
        exchange.getOut().setBody(nodes);
        exchange.getOut().setHeader("CamelCMISResultCount", (Object)nodes.size());
    }

    private List<Map<String, Object>> executeQuery(Exchange exchange) throws Exception {
        String query = (String)exchange.getIn().getMandatoryBody(String.class);
        Boolean retrieveContent = this.getRetrieveContent(exchange);
        Integer readSize = this.getReadSize(exchange);
        ItemIterable<QueryResult> itemIterable = this.cmisSessionFacade.executeQuery(query);
        return this.cmisSessionFacade.retrieveResult(retrieveContent, readSize, itemIterable);
    }

    private Integer getReadSize(Exchange exchange) {
        return (Integer)exchange.getIn().getHeader("CamelCMISReadSize", Integer.class);
    }

    private Boolean getRetrieveContent(Exchange exchange) {
        return (Boolean)exchange.getIn().getHeader("CamelCMISRetrieveContent", Boolean.class);
    }
}

