/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.coap;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.coap.CoAPConsumer;
import org.apache.camel.coap.CoAPEndpoint;
import org.apache.camel.coap.CoAPHelper;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CamelCoapResource
extends CoapResource {
    private static final Logger LOG = LoggerFactory.getLogger(CamelCoapResource.class);
    private final Map<String, CoAPConsumer> consumers = new ConcurrentHashMap<String, CoAPConsumer>();
    private final List<CamelCoapResource> possibles;

    CamelCoapResource(String name, CoAPConsumer consumer) {
        super(name);
        this.addConsumer(consumer);
        this.possibles = null;
    }

    private CamelCoapResource(String name, List<CamelCoapResource> possibles) {
        super(name);
        this.possibles = possibles;
    }

    void addConsumer(CoAPConsumer consumer) {
        CoAPEndpoint coapEndpoint = consumer.getCoapEndpoint();
        String coapMethodRestrict = CoAPHelper.getDefaultMethodRestrict(coapEndpoint.getCoapMethodRestrict());
        for (String method : coapMethodRestrict.split(",")) {
            this.consumers.put(method.trim(), consumer);
        }
    }

    public Resource getChild(String name) {
        Resource child;
        if (this.possibles != null) {
            // empty if block
        }
        if ((child = super.getChild(name)) == null) {
            LinkedList<CamelCoapResource> possibles = new LinkedList<CamelCoapResource>();
            for (Resource r : this.getChildren()) {
                if (!r.getName().startsWith("{") || !r.getName().endsWith("}")) continue;
                possibles.add((CamelCoapResource)r);
            }
            if (possibles.size() == 1) {
                return (Resource)possibles.get(0);
            }
            if (!possibles.isEmpty()) {
                return new CamelCoapResource(name, possibles);
            }
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(org.eclipse.californium.core.network.Exchange exchange) {
        block22: {
            block18: {
                CoAPConsumer consumer;
                Exchange camelExchange;
                block19: {
                    CoapExchange cexchange;
                    block15: {
                        block23: {
                            block16: {
                                block17: {
                                    camelExchange = null;
                                    consumer = null;
                                    if (this.possibles != null) {
                                        this.consumers.putAll(this.possibles.get((int)0).consumers);
                                    }
                                    cexchange = new CoapExchange(exchange, (CoapResource)this);
                                    consumer = this.consumers.get(exchange.getRequest().getCode().name());
                                    if (consumer != null) break block15;
                                    cexchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
                                    if (consumer == null) break block16;
                                    if (camelExchange == null) break block17;
                                    consumer.doneUoW(camelExchange);
                                }
                                consumer.releaseExchange(camelExchange, false);
                                break block23;
                            }
                            LOG.warn("Skipping releasing the consumer exchange because the consumer is null. It may haven't been properly created earlier - exception was thrown");
                        }
                        return;
                    }
                    try {
                        CamelCoapResource r;
                        camelExchange = consumer.createExchange(false);
                        consumer.createUoW(camelExchange);
                        OptionSet options = exchange.getRequest().getOptions();
                        for (String s : options.getUriQuery()) {
                            int i = s.indexOf(61);
                            if (i == -1) {
                                camelExchange.getIn().setHeader(s, (Object)"");
                                continue;
                            }
                            camelExchange.getIn().setHeader(s.substring(0, i), (Object)s.substring(i + 1));
                        }
                        if (options.hasContentFormat()) {
                            String mt = MediaTypeRegistry.toString((int)options.getContentFormat());
                            camelExchange.getIn().setHeader("Content-Type", (Object)mt);
                        }
                        List path = exchange.getRequest().getOptions().getUriPath();
                        LinkedList<CamelCoapResource> resources = new LinkedList<CamelCoapResource>();
                        for (r = this; r != null; r = r.getParent()) {
                            resources.push(r);
                        }
                        if (((Resource)resources.getFirst()).getName().isEmpty()) {
                            resources.removeFirst();
                        }
                        for (int res = 0; !resources.isEmpty() && res < path.size(); ++res) {
                            r = (Resource)resources.removeFirst();
                            if (r.getName().charAt(0) != '{' || r.getName().charAt(r.getName().length() - 1) != '}') continue;
                            String n = r.getName().substring(1, r.getName().length() - 1);
                            camelExchange.getIn().setHeader(n, path.get(res));
                        }
                        byte[] bytes = exchange.getCurrentRequest().getPayload();
                        camelExchange.getIn().setBody((Object)bytes);
                        consumer.getProcessor().process(camelExchange);
                        Message target = camelExchange.getMessage();
                        int format = MediaTypeRegistry.parse((String)((String)target.getHeader("Content-Type", String.class)));
                        cexchange.respond(CoAP.ResponseCode.CONTENT, (byte[])target.getBody(byte[].class), format);
                        if (consumer == null) break block18;
                        if (camelExchange == null) break block19;
                    }
                    catch (Exception e) {
                        block20: {
                            block21: {
                                try {
                                    cexchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR, e.getMessage());
                                    if (consumer == null) break block20;
                                    if (camelExchange == null) break block21;
                                }
                                catch (Throwable throwable) {
                                    if (consumer != null) {
                                        if (camelExchange != null) {
                                            consumer.doneUoW(camelExchange);
                                        }
                                        consumer.releaseExchange(camelExchange, false);
                                    } else {
                                        LOG.warn("Skipping releasing the consumer exchange because the consumer is null. It may haven't been properly created earlier - exception was thrown");
                                    }
                                    throw throwable;
                                }
                                consumer.doneUoW(camelExchange);
                            }
                            consumer.releaseExchange(camelExchange, false);
                            break block22;
                        }
                        LOG.warn("Skipping releasing the consumer exchange because the consumer is null. It may haven't been properly created earlier - exception was thrown");
                    }
                    consumer.doneUoW(camelExchange);
                }
                consumer.releaseExchange(camelExchange, false);
                break block22;
            }
            LOG.warn("Skipping releasing the consumer exchange because the consumer is null. It may haven't been properly created earlier - exception was thrown");
        }
    }
}

