/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.coap;

import org.apache.camel.spi.Metadata;

public interface CoAPConstants {
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_PING = "PING";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_RESTRICT_ALL = String.format("%s,%s,%s,%s", "DELETE", "GET", "POST", "PUT");
    @Metadata(description="The CoAP ETag for the response.", javaType="byte[]")
    public static final String COAP_ETAG = "CamelCoapETag";
    @Metadata(description="The CoAP Max-Age for the response body.", javaType="java.lang.Long")
    public static final String COAP_MAX_AGE = "CamelCoapMaxAge";
    @Metadata(description="The request method that the CoAP producer should use when calling the target CoAP\nserver URI. Valid options are DELETE, GET, PING, POST & PUT.", javaType="String")
    public static final String COAP_METHOD = "CamelCoapMethod";
    @Metadata(description="The CoAP response code sent by the external server. See RFC 7252 for details\nof what each code means.", javaType="String")
    public static final String COAP_RESPONSE_CODE = "CamelCoapResponseCode";
    @Metadata(description="The URI of a CoAP server to call. Will override any existing URI configured directly on the endpoint.", javaType="String")
    public static final String COAP_URI = "CamelCoapUri";
    @Metadata(description="The content type", javaType="String")
    public static final String CONTENT_TYPE = "Content-Type";
}

