/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="endpoint")
public class EndpointDevConsole
extends AbstractDevConsole {
    public EndpointDevConsole() {
        super("camel", "endpoint", "Endpoints", "Endpoint Registry information");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        List stats = null;
        RuntimeEndpointRegistry runtimeReg = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getRuntimeEndpointRegistry();
        if (runtimeReg != null) {
            stats = runtimeReg.getEndpointStatistics();
        }
        EndpointRegistry reg = this.getCamelContext().getEndpointRegistry();
        sb.append(String.format("    Endpoints: %s (static: %s dynamic: %s)\n", reg.size(), reg.staticSize(), reg.dynamicSize()));
        sb.append(String.format("    Maximum Cache Size: %s\n", reg.getMaximumCacheSize()));
        Collection col = reg.getReadOnlyValues();
        if (!col.isEmpty()) {
            for (Endpoint e : col) {
                Optional<RuntimeEndpointRegistry.Statistic> stat = EndpointDevConsole.findStats(stats, e.getEndpointUri());
                if (stat.isPresent()) {
                    RuntimeEndpointRegistry.Statistic st = stat.get();
                    sb.append(String.format("\n    %s (direction: %s, usage: %s)", e, st.getDirection(), st.getHits()));
                    continue;
                }
                sb.append(String.format("\n    %s", e));
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        List stats = null;
        RuntimeEndpointRegistry runtimeReg = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getRuntimeEndpointRegistry();
        if (runtimeReg != null) {
            stats = runtimeReg.getEndpointStatistics();
        }
        EndpointRegistry reg = this.getCamelContext().getEndpointRegistry();
        root.put((Object)"size", (Object)reg.size());
        root.put((Object)"staticSize", (Object)reg.staticSize());
        root.put((Object)"dynamicSize", (Object)reg.dynamicSize());
        root.put((Object)"maximumCacheSize", (Object)reg.getMaximumCacheSize());
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        root.put((Object)"endpoints", list);
        Collection col = reg.getReadOnlyValues();
        for (Endpoint e : col) {
            JsonObject jo = new JsonObject();
            jo.put((Object)"uri", (Object)e.toString());
            Optional<RuntimeEndpointRegistry.Statistic> stat = EndpointDevConsole.findStats(stats, e.getEndpointUri());
            if (stat.isPresent()) {
                RuntimeEndpointRegistry.Statistic st = stat.get();
                jo.put((Object)"direction", (Object)st.getDirection());
                jo.put((Object)"hits", (Object)st.getHits());
                jo.put((Object)"routeId", (Object)st.getRouteId());
            }
            list.add(jo);
        }
        return root;
    }

    private static Optional<RuntimeEndpointRegistry.Statistic> findStats(List<RuntimeEndpointRegistry.Statistic> stats, String uri) {
        if (stats == null) {
            return Optional.empty();
        }
        return stats.stream().filter(s -> uri.equals(s.getUri())).findFirst();
    }
}

