/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul;

import com.orbitz.consul.Consul;
import com.orbitz.consul.ConsulException;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.SessionClient;
import com.orbitz.consul.model.session.ImmutableSession;
import com.orbitz.consul.model.session.Session;
import com.orbitz.consul.model.session.SessionCreatedResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Registry;

public class ConsulRegistry
implements Registry {
    private String hostname = "localhost";
    private int port = 8500;
    private Consul consul;
    private KeyValueClient kvClient;

    public ConsulRegistry(String hostname) {
        this(hostname, 8500);
    }

    public ConsulRegistry(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
        this.consul = Consul.builder().withUrl("http://" + this.hostname + ":" + this.port).build();
    }

    private ConsulRegistry(Builder builder) {
        this.hostname = builder.hostname;
        this.port = builder.port;
        this.consul = Consul.builder().withUrl("http://" + this.hostname + ":" + this.port).build();
    }

    public Object lookupByName(String key) {
        key = key.replace('$', '/');
        this.kvClient = this.consul.keyValueClient();
        return this.kvClient.getValueAsString(key).map(result -> {
            byte[] postDecodedValue = ConsulRegistryUtils.decodeBase64(result);
            return ConsulRegistryUtils.deserialize(postDecodedValue);
        }).orElse(null);
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        Object object = this.lookupByName(name);
        if (object == null) {
            return null;
        }
        try {
            return type.cast(object);
        }
        catch (Exception e) {
            String msg = "Found bean: " + name + " in Consul Registry: " + this + " of type: " + object.getClass().getName() + "expected type was: " + type;
            throw new NoSuchBeanException(name, msg, (Throwable)e);
        }
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        List keys;
        HashMap<String, T> result = new HashMap<String, T>();
        String keyPrefix = type.getName().replace('$', '/');
        this.kvClient = this.consul.keyValueClient();
        try {
            keys = this.kvClient.getKeys(keyPrefix);
        }
        catch (ConsulException e) {
            return result;
        }
        if (keys != null) {
            for (String key : keys) {
                Object obj = this.lookupByName((key = key.substring(key.lastIndexOf(47) + 1)).replace('$', '/'));
                if (!type.isInstance(obj)) continue;
                result.put(key, type.cast(obj));
            }
        }
        return result;
    }

    public <T> Set<T> findByType(Class<T> type) {
        List keys;
        String keyPrefix = type.getName().replace('$', '/');
        HashSet<T> result = new HashSet<T>();
        try {
            keys = this.kvClient.getKeys(keyPrefix);
        }
        catch (ConsulException e) {
            return result;
        }
        if (keys != null) {
            for (String key : keys) {
                Object obj = this.lookupByName((key = key.substring(key.lastIndexOf(47) + 1)).replace('$', '/'));
                if (!type.isInstance(obj)) continue;
                result.add(type.cast(obj));
            }
        }
        return result;
    }

    public void bind(String id, Class type, Object bean) throws RuntimeCamelException {
        this.put(id, bean);
    }

    public void bind(String id, Class<?> type, Supplier<Object> bean) throws RuntimeCamelException {
        throw new UnsupportedOperationException("Binding with supplier not supported");
    }

    public void bindAsPrototype(String id, Class<?> type, Supplier<Object> bean) throws RuntimeCamelException {
        throw new UnsupportedOperationException("Binding with supplier not supported");
    }

    public void remove(String key) {
        SessionClient sessionClient = this.consul.sessionClient();
        String sessionName = "session_" + UUID.randomUUID().toString();
        SessionCreatedResponse response = sessionClient.createSession((Session)ImmutableSession.builder().name(sessionName).build());
        String sessionId = response.getId();
        this.kvClient = this.consul.keyValueClient();
        String lockKey = "lock_" + key;
        this.kvClient.acquireLock(lockKey, sessionName, sessionId);
        Object object = this.lookupByName(key);
        if (object == null) {
            String msg = "Bean with key '" + key + "' did not exist in Consul Registry.";
            throw new NoSuchBeanException(msg);
        }
        this.kvClient.deleteKey(key);
        this.kvClient.deleteKey(object.getClass().getName() + "/" + key);
        this.kvClient.releaseLock(lockKey, sessionId);
    }

    public void put(String key, Object object) {
        key = key.replace('$', '/');
        SessionClient sessionClient = this.consul.sessionClient();
        String sessionName = "session_" + UUID.randomUUID().toString();
        SessionCreatedResponse response = sessionClient.createSession((Session)ImmutableSession.builder().name(sessionName).build());
        String sessionId = response.getId();
        this.kvClient = this.consul.keyValueClient();
        String lockKey = "lock_" + key;
        this.kvClient.acquireLock(lockKey, sessionName, sessionId);
        if (this.lookupByName(key) != null) {
            this.remove(key);
        }
        Object clone = ConsulRegistryUtils.clone((Serializable)object);
        byte[] serializedObject = ConsulRegistryUtils.serialize((Serializable)clone);
        String value = ConsulRegistryUtils.encodeBase64(serializedObject);
        this.kvClient.putValue(key, value);
        this.kvClient.putValue(object.getClass().getName().replace('$', '/') + "/" + key, "1");
        this.kvClient.releaseLock(lockKey, sessionId);
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    static class ConsulRegistryUtils {
        ConsulRegistryUtils() {
        }

        static byte[] decodeBase64(String base64String) {
            return Base64.getDecoder().decode(base64String.getBytes(StandardCharsets.ISO_8859_1));
        }

        static String encodeBase64(byte[] binaryData) {
            byte[] encoded = Base64.getEncoder().encode(binaryData);
            return new String(encoded, StandardCharsets.ISO_8859_1);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static Object deserialize(byte[] bytes) {
            try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));){
                Object object = in.readObject();
                return object;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }

        static Object clone(Serializable object) {
            return ConsulRegistryUtils.deserialize(ConsulRegistryUtils.serialize(object));
        }

        /*
         * Exception decompiling
         */
        static byte[] serialize(Serializable serializable) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static class Builder {
        String hostname;
        Integer port = 8500;

        public Builder(String hostname) {
            this.hostname = hostname;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public ConsulRegistry build() {
            return new ConsulRegistry(this);
        }
    }
}

