/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul;

import org.apache.camel.spi.Metadata;

public interface ConsulConstants {
    public static final String CONSUL_DEFAULT_URL = String.format("http://%s:%d", "localhost", 8500);
    public static final String CONSUL_SERVER_IP = "CamelConsulServerIp";
    public static final String CONSUL_SERVER_PORT = "CamelConsulServerPort";
    @Metadata(label="producer", description="The Producer action", javaType="String")
    public static final String CONSUL_ACTION = "CamelConsulAction";
    @Metadata(description="The Key on which the action should applied", javaType="String")
    public static final String CONSUL_KEY = "CamelConsulKey";
    @Metadata(label="consumer", description="The event id", javaType="String")
    public static final String CONSUL_EVENT_ID = "CamelConsulEventId";
    @Metadata(label="consumer", description="The event name", javaType="String")
    public static final String CONSUL_EVENT_NAME = "CamelConsulEventName";
    @Metadata(label="consumer", description="The event LTime", javaType="Long")
    public static final String CONSUL_EVENT_LTIME = "CamelConsulEventLTime";
    @Metadata(label="consumer", description="The Node filter", javaType="String")
    public static final String CONSUL_NODE_FILTER = "CamelConsulNodeFilter";
    @Metadata(label="consumer", description="The tag filter", javaType="String")
    public static final String CONSUL_TAG_FILTER = "CamelConsulTagFilter";
    @Metadata(label="consumer", description="The session filter", javaType="String")
    public static final String CONSUL_SERVICE_FILTER = "CamelConsulSessionFilter";
    @Metadata(label="consumer", description="The data version", javaType="Integer")
    public static final String CONSUL_VERSION = "CamelConsulVersion";
    @Metadata(description="Flags associated with a value", javaType="Long")
    public static final String CONSUL_FLAGS = "CamelConsulFlags";
    @Metadata(label="producer", description="The optional value index", javaType="BigInteger")
    public static final String CONSUL_INDEX = "CamelConsulIndex";
    @Metadata(label="producer", description="The optional value wait", javaType="String")
    public static final String CONSUL_WAIT = "CamelConsulWait";
    @Metadata(label="consumer", description="The internal index value that represents when the entry was created", javaType="Long")
    public static final String CONSUL_CREATE_INDEX = "CamelConsulCreateIndex";
    @Metadata(label="consumer", description="The number of times this key has successfully been acquired in a lock", javaType="Long")
    public static final String CONSUL_LOCK_INDEX = "CamelConsulLockIndex";
    @Metadata(label="consumer", description="The last index that modified this key", javaType="Long")
    public static final String CONSUL_MODIFY_INDEX = "CamelConsulModifyIndex";
    @Metadata(description="Options associated to the request")
    public static final String CONSUL_OPTIONS = "CamelConsulOptions";
    @Metadata(description="true if the response has a result", javaType="Boolean")
    public static final String CONSUL_RESULT = "CamelConsulResult";
    @Metadata(description="The session id", javaType="String")
    public static final String CONSUL_SESSION = "CamelConsulSession";
    @Metadata(label="producer", description="To transform values retrieved from Consul i.e. on KV endpoint to string.", javaType="Boolean")
    public static final String CONSUL_VALUE_AS_STRING = "CamelConsulValueAsString";
    @Metadata(label="producer", description="The node", javaType="String")
    public static final String CONSUL_NODE = "CamelConsulNode";
    @Metadata(label="producer", description="The service", javaType="String")
    public static final String CONSUL_SERVICE = "CamelConsulService";
    @Metadata(label="producer", description="The data center", javaType="String")
    public static final String CONSUL_DATACENTER = "CamelConsulDatacenter";
    @Metadata(label="producer", description="The near node to use for queries.", javaType="String")
    public static final String CONSUL_NEAR_NODE = "CamelConsulNearNode";
    @Metadata(label="producer", description="The note meta-data to use for queries.", javaType="List<String>")
    public static final String CONSUL_NODE_META = "CamelConsulNodeMeta";
    @Metadata(label="producer", description="The last contact", javaType="Long")
    public static final String CONSUL_LAST_CONTACT = "CamelConsulLastContact";
    @Metadata(label="producer", description="Indicates whether it is the known leader", javaType="Boolean")
    public static final String CONSUL_KNOWN_LEADER = "CamelConsulKnownLeader";
    @Metadata(label="producer", description="The consistencyMode used for queries", javaType="com.orbitz.consul.option.ConsistencyMode", defaultValue="DEFAULT")
    public static final String CONSUL_CONSISTENCY_MODE = "CamelConsulConsistencyMode";
    @Metadata(label="producer", description="Only on healthy services", javaType="Boolean", defaultValue="false")
    public static final String CONSUL_HEALTHY_ONLY = "CamelConsulHealthyOnly";
    @Metadata(label="producer", description="The state to query.", javaType="com.orbitz.consul.model.State")
    public static final String CONSUL_HEALTHY_STATE = "CamelConsulHealthyState";
    @Metadata(label="producer", description="The id of the prepared query", javaType="String")
    public static final String CONSUL_PREPARED_QUERY_ID = "CamelConsulPreparedQueryID";
    @Metadata(label="producer", description="The service id for agent deregistration", javaType="String")
    public static final String CONSUL_SERVICE_ID = "CamelConsulServiceId";
}

