/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Registry;
import org.kiwiproject.consul.Consul;
import org.kiwiproject.consul.ConsulException;
import org.kiwiproject.consul.KeyValueClient;
import org.kiwiproject.consul.SessionClient;
import org.kiwiproject.consul.model.session.ImmutableSession;
import org.kiwiproject.consul.model.session.Session;
import org.kiwiproject.consul.model.session.SessionCreatedResponse;

public class ConsulRegistry
implements Registry {
    private String hostname = "localhost";
    private int port = 8500;
    private Consul consul;
    private KeyValueClient kvClient;

    public ConsulRegistry(String hostname) {
        this(hostname, 8500);
    }

    public ConsulRegistry(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
        this.consul = Consul.builder().withUrl("http://" + this.hostname + ":" + this.port).build();
    }

    private ConsulRegistry(Builder builder) {
        this.hostname = builder.hostname;
        this.port = builder.port;
        this.consul = Consul.builder().withUrl("http://" + this.hostname + ":" + this.port).build();
    }

    public Object lookupByName(String key) {
        key = key.replace('$', '/');
        this.kvClient = this.consul.keyValueClient();
        return this.kvClient.getValueAsString(key).map(result -> {
            byte[] postDecodedValue = ConsulRegistryUtils.decodeBase64(result);
            return ConsulRegistryUtils.deserialize(postDecodedValue);
        }).orElse(null);
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        Object object = this.lookupByName(name);
        if (object == null) {
            return null;
        }
        try {
            return type.cast(object);
        }
        catch (Exception e) {
            String msg = "Found bean: " + name + " in Consul Registry: " + this + " of type: " + object.getClass().getName() + "expected type was: " + type;
            throw new NoSuchBeanException(name, msg, (Throwable)e);
        }
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        List keys;
        HashMap<String, T> result = new HashMap<String, T>();
        String keyPrefix = type.getName().replace('$', '/');
        this.kvClient = this.consul.keyValueClient();
        try {
            keys = this.kvClient.getKeys(keyPrefix);
        }
        catch (ConsulException e) {
            return result;
        }
        if (keys != null) {
            for (String key : keys) {
                Object obj = this.lookupByName((key = key.substring(key.lastIndexOf(47) + 1)).replace('$', '/'));
                if (!type.isInstance(obj)) continue;
                result.put(key, type.cast(obj));
            }
        }
        return result;
    }

    public <T> Set<T> findByType(Class<T> type) {
        List keys;
        String keyPrefix = type.getName().replace('$', '/');
        HashSet<T> result = new HashSet<T>();
        try {
            keys = this.kvClient.getKeys(keyPrefix);
        }
        catch (ConsulException e) {
            return result;
        }
        if (keys != null) {
            for (String key : keys) {
                Object obj = this.lookupByName((key = key.substring(key.lastIndexOf(47) + 1)).replace('$', '/'));
                if (!type.isInstance(obj)) continue;
                result.add(type.cast(obj));
            }
        }
        return result;
    }

    public void bind(String id, Class<?> type, Object bean) throws RuntimeCamelException {
        this.put(id, bean);
    }

    public void bind(String id, Class<?> type, Supplier<Object> bean) throws RuntimeCamelException {
        throw new UnsupportedOperationException("Binding with supplier not supported");
    }

    public void bindAsPrototype(String id, Class<?> type, Supplier<Object> bean) throws RuntimeCamelException {
        throw new UnsupportedOperationException("Binding with supplier not supported");
    }

    public void remove(String key) {
        SessionClient sessionClient = this.consul.sessionClient();
        String sessionName = "session_" + UUID.randomUUID();
        SessionCreatedResponse response = sessionClient.createSession((Session)ImmutableSession.builder().name(sessionName).build());
        String sessionId = response.getId();
        this.kvClient = this.consul.keyValueClient();
        String lockKey = "lock_" + key;
        this.kvClient.acquireLock(lockKey, sessionName, sessionId);
        Object object = this.lookupByName(key);
        if (object == null) {
            String msg = "Bean with key '" + key + "' did not exist in Consul Registry.";
            throw new NoSuchBeanException(msg);
        }
        this.kvClient.deleteKey(key);
        this.kvClient.deleteKey(object.getClass().getName() + "/" + key);
        this.kvClient.releaseLock(lockKey, sessionId);
    }

    public void put(String key, Object object) {
        key = key.replace('$', '/');
        SessionClient sessionClient = this.consul.sessionClient();
        String sessionName = "session_" + UUID.randomUUID();
        SessionCreatedResponse response = sessionClient.createSession((Session)ImmutableSession.builder().name(sessionName).build());
        String sessionId = response.getId();
        this.kvClient = this.consul.keyValueClient();
        String lockKey = "lock_" + key;
        this.kvClient.acquireLock(lockKey, sessionName, sessionId);
        if (this.lookupByName(key) != null) {
            this.remove(key);
        }
        Object clone = ConsulRegistryUtils.clone((Serializable)object);
        byte[] serializedObject = ConsulRegistryUtils.serialize((Serializable)clone);
        String value = ConsulRegistryUtils.encodeBase64(serializedObject);
        this.kvClient.putValue(key, value);
        this.kvClient.putValue(object.getClass().getName().replace('$', '/') + "/" + key, "1");
        this.kvClient.releaseLock(lockKey, sessionId);
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public static class Builder {
        String hostname;
        Integer port = 8500;

        public Builder(String hostname) {
            this.hostname = hostname;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public ConsulRegistry build() {
            return new ConsulRegistry(this);
        }
    }

    static final class ConsulRegistryUtils {
        private ConsulRegistryUtils() {
        }

        static byte[] decodeBase64(String base64String) {
            return Base64.getDecoder().decode(base64String.getBytes(StandardCharsets.ISO_8859_1));
        }

        static String encodeBase64(byte[] binaryData) {
            byte[] encoded = Base64.getEncoder().encode(binaryData);
            return new String(encoded, StandardCharsets.ISO_8859_1);
        }

        static Object deserialize(byte[] bytes) {
            Object object;
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            try {
                object = in.readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new RuntimeCamelException((Throwable)e);
                }
            }
            in.close();
            return object;
        }

        static Object clone(Serializable object) {
            return ConsulRegistryUtils.deserialize(ConsulRegistryUtils.serialize(object));
        }

        /*
         * Enabled aggressive exception aggregation
         */
        static byte[] serialize(Serializable serializable) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream(512);){
                byte[] byArray;
                try (ObjectOutputStream out = new ObjectOutputStream(baos);){
                    out.writeObject(serializable);
                    byArray = baos.toByteArray();
                }
                return byArray;
            }
            catch (IOException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
    }
}

