/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.endpoint;

import org.apache.camel.Message;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;
import org.apache.camel.component.consul.endpoint.AbstractConsulProducer;
import org.apache.camel.spi.InvokeOnHeader;
import org.apache.camel.util.ObjectHelper;
import org.kiwiproject.consul.Consul;
import org.kiwiproject.consul.PreparedQueryClient;
import org.kiwiproject.consul.model.query.PreparedQuery;

public final class ConsulPreparedQueryProducer
extends AbstractConsulProducer<PreparedQueryClient> {
    public ConsulPreparedQueryProducer(ConsulEndpoint endpoint, ConsulConfiguration configuration) {
        super(endpoint, configuration, Consul::preparedQueryClient);
    }

    @InvokeOnHeader(value="CREATE")
    protected void create(Message message) throws Exception {
        this.setBodyAndResult(message, ((PreparedQueryClient)this.getClient()).createPreparedQuery((PreparedQuery)message.getMandatoryBody(PreparedQuery.class)));
    }

    @InvokeOnHeader(value="GET")
    protected void get(Message message) throws Exception {
        String id = (String)message.getHeader("CamelConsulPreparedQueryID", String.class);
        if (ObjectHelper.isEmpty((String)id)) {
            this.setBodyAndResult(message, ((PreparedQueryClient)this.getClient()).getPreparedQuery((String)message.getMandatoryBody(String.class)));
        } else {
            this.setBodyAndResult(message, ((PreparedQueryClient)this.getClient()).getPreparedQuery(id));
        }
    }

    @InvokeOnHeader(value="EXECUTE")
    protected void execute(Message message) throws Exception {
        String id = (String)message.getHeader("CamelConsulPreparedQueryID", String.class);
        if (ObjectHelper.isEmpty((String)id)) {
            this.setBodyAndResult(message, ((PreparedQueryClient)this.getClient()).execute((String)message.getMandatoryBody(String.class)));
        } else {
            this.setBodyAndResult(message, ((PreparedQueryClient)this.getClient()).execute(id));
        }
    }
}

