/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchdb;

import com.ibm.cloud.cloudant.v1.Cloudant;
import com.ibm.cloud.cloudant.v1.model.ChangesResult;
import com.ibm.cloud.cloudant.v1.model.DatabaseInformation;
import com.ibm.cloud.cloudant.v1.model.DeleteDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.Document;
import com.ibm.cloud.cloudant.v1.model.DocumentResult;
import com.ibm.cloud.cloudant.v1.model.GetDatabaseInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.PostChangesOptions;
import com.ibm.cloud.cloudant.v1.model.PostDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.PutDatabaseOptions;
import com.ibm.cloud.cloudant.v1.model.PutDocumentOptions;
import com.ibm.cloud.sdk.core.http.Response;
import java.util.List;
import org.apache.camel.component.couchdb.CouchDbEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDbClientWrapper {
    private static final Logger log = LoggerFactory.getLogger(CouchDbEndpoint.class);
    private final Cloudant client;
    private final String dbName;

    public CouchDbClientWrapper(Cloudant client, String dbName, boolean createDatabase) {
        this.client = client;
        this.dbName = dbName;
        this.initDatabase(createDatabase);
    }

    public void initDatabase(boolean createDatabase) {
        if (createDatabase) {
            boolean alreadyCreated = false;
            for (String db : (List)this.client.getAllDbs().execute().getResult()) {
                if (!db.equals(this.dbName)) continue;
                alreadyCreated = true;
                break;
            }
            if (!alreadyCreated) {
                PutDatabaseOptions putDatabaseOptions = new PutDatabaseOptions.Builder().db(this.dbName).build();
                this.client.putDatabase(putDatabaseOptions).execute();
            }
            log.debug("Database {} created", (Object)this.dbName);
        }
    }

    public Response<DocumentResult> update(Document doc) {
        PostDocumentOptions postDocumentOptions = new PostDocumentOptions.Builder().document(doc).db(this.dbName).build();
        return this.client.postDocument(postDocumentOptions).execute();
    }

    public Response save(Document doc) {
        PutDocumentOptions putDocumentOptions = new PutDocumentOptions.Builder().document(doc).docId(doc.getId()).db(this.dbName).build();
        return this.client.putDocument(putDocumentOptions).execute();
    }

    public Response removeByIdAndRev(String id, String rev) {
        DeleteDocumentOptions deleteDocumentOptions = new DeleteDocumentOptions.Builder().docId(id).rev(rev).db(this.dbName).build();
        return this.client.deleteDocument(deleteDocumentOptions).execute();
    }

    public Response<ChangesResult> pollChanges(String style, String since, long heartBeat, long maxMessagesPerPoll) {
        PostChangesOptions postChangesOptions = new PostChangesOptions.Builder().db(this.dbName).since(since).limit(maxMessagesPerPoll).build();
        return this.client.postChanges(postChangesOptions).execute();
    }

    public Response get(String id) {
        GetDocumentOptions getDocumentOptions = new GetDocumentOptions.Builder().docId(id).db(this.dbName).build();
        return this.client.getDocument(getDocumentOptions).execute();
    }

    public String getLatestUpdateSequence() {
        GetDatabaseInformationOptions getDatabaseInformationOptions = new GetDatabaseInformationOptions.Builder().db(this.dbName).build();
        return ((DatabaseInformation)this.client.getDatabaseInformation(getDatabaseInformationOptions).execute().getResult()).getUpdateSeq();
    }
}

