/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchdb;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.ibm.cloud.cloudant.v1.model.Document;
import com.ibm.cloud.cloudant.v1.model.DocumentResult;
import com.ibm.cloud.sdk.core.http.Response;
import java.util.UUID;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.couchdb.CouchDbClientWrapper;
import org.apache.camel.component.couchdb.CouchDbEndpoint;
import org.apache.camel.component.couchdb.CouchDbException;
import org.apache.camel.component.couchdb.CouchDbOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDbProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(CouchDbProducer.class);
    private final CouchDbClientWrapper couchClient;

    public CouchDbProducer(CouchDbEndpoint endpoint, CouchDbClientWrapper couchClient) {
        super((Endpoint)endpoint);
        this.couchClient = couchClient;
    }

    public void process(Exchange exchange) throws Exception {
        JsonElement json = this.getBodyAsJsonElement(exchange);
        String operation = (String)exchange.getIn().getHeader("CouchDbMethod", String.class);
        if (ObjectHelper.isEmpty((String)operation)) {
            Response<DocumentResult> save = this.saveJsonElement(json);
            if (save == null) {
                throw new CouchDbException("Could not save document [unknown reason]", exchange);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Document saved [_id={}, _rev={}]", (Object)((DocumentResult)save.getResult()).getId(), (Object)((DocumentResult)save.getResult()).getRev());
            }
            exchange.getIn().setHeader("CouchDbRev", (Object)((DocumentResult)save.getResult()).getRev());
            exchange.getIn().setHeader("CouchDbId", (Object)((DocumentResult)save.getResult()).getId());
        } else {
            if (operation.equalsIgnoreCase(CouchDbOperations.DELETE.toString())) {
                Response delete = this.deleteJsonElement(json);
                if (delete == null) {
                    throw new CouchDbException("Could not delete document [unknown reason]", exchange);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Document saved [_id={}, _rev={}]", (Object)((DocumentResult)delete.getResult()).getId(), (Object)((DocumentResult)delete.getResult()).getRev());
                }
                exchange.getIn().setHeader("CouchDbRev", (Object)((DocumentResult)delete.getResult()).getRev());
                exchange.getIn().setHeader("CouchDbId", (Object)((DocumentResult)delete.getResult()).getId());
            }
            if (operation.equalsIgnoreCase(CouchDbOperations.GET.toString())) {
                String docId = (String)exchange.getIn().getHeader("CouchDbId", String.class);
                if (docId == null) {
                    throw new CouchDbException("Could not get document, document id is missing", exchange);
                }
                Object response = this.getElement(docId);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Document retrieved [_id={}]", (Object)docId);
                }
                exchange.getIn().setBody(response);
            }
        }
    }

    JsonElement getBodyAsJsonElement(Exchange exchange) throws InvalidPayloadException {
        Object body = exchange.getIn().getMandatoryBody();
        if (body instanceof String) {
            try {
                return new JsonParser().parse((String)body);
            }
            catch (JsonSyntaxException jse) {
                throw new InvalidPayloadException(exchange, body.getClass());
            }
        }
        if (body instanceof JsonElement) {
            return (JsonElement)body;
        }
        if (body instanceof Document) {
            Document document = (Document)body;
            return new JsonParser().parse(document.toString());
        }
        throw new InvalidPayloadException(exchange, body != null ? body.getClass() : null);
    }

    private Response<DocumentResult> saveJsonElement(JsonElement json) {
        Response<DocumentResult> save = null;
        if (json instanceof JsonObject) {
            JsonObject obj = (JsonObject)json;
            Document.Builder documentBuilder = new Document.Builder();
            for (String key : obj.keySet()) {
                if (key.equals("_id")) {
                    documentBuilder.id(obj.get(key).getAsString());
                    continue;
                }
                documentBuilder.add(key, (Object)obj.get(key));
            }
            Document document = documentBuilder.build();
            if (document.getId() == null) {
                document.setId(UUID.randomUUID().toString());
            }
            save = obj.get("_rev") == null ? this.couchClient.save(document) : this.couchClient.update(document);
        }
        return save;
    }

    private Response deleteJsonElement(JsonElement json) {
        Response delete;
        if (json instanceof JsonObject) {
            JsonObject obj = (JsonObject)json;
            delete = this.couchClient.removeByIdAndRev(obj.get("_id").getAsString(), obj.get("_rev").getAsString());
        } else {
            delete = this.couchClient.removeByIdAndRev(json.getAsJsonObject().get("_id").getAsString(), json.getAsJsonObject().get("_rev").getAsString());
        }
        return delete;
    }

    private Object getElement(String id) {
        Object response = this.couchClient.get(id).getResult();
        return response;
    }
}

