/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.processor;

import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.crypto.DigitalSignatureConfiguration;
import org.apache.camel.component.crypto.DigitalSignatureConstants;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public abstract class DigitalSignatureProcessor
implements Processor {
    protected DigitalSignatureConfiguration config;

    public DigitalSignatureProcessor(DigitalSignatureConfiguration configuration) {
        this.config = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateSignature(Exchange exchange, Signature signer) throws Exception {
        Object payload = exchange.getIn().getBody();
        if (payload != null) {
            InputStream payloadStream = (InputStream)ExchangeHelper.convertToMandatoryType((Exchange)exchange, InputStream.class, (Object)payload);
            try {
                int read;
                byte[] buffer = new byte[this.config.getBufferSize().intValue()];
                while ((read = payloadStream.read(buffer)) > 0) {
                    signer.update(buffer, 0, read);
                }
            }
            finally {
                IOHelper.close((Closeable)payloadStream);
            }
        }
    }

    protected String getAlias(Exchange exchange) throws Exception {
        KeyStore keystore = this.config.getKeystore();
        if (keystore != null) {
            String alias = (String)exchange.getIn().getHeader("CamelSignatureKeyStoreAlias", String.class);
            if (alias == null) {
                alias = this.config.getAlias();
            }
            if (alias == null && keystore.size() == 1) {
                alias = keystore.aliases().nextElement();
            }
            return alias;
        }
        return null;
    }

    public void setConfig(DigitalSignatureConfiguration config) {
        this.config = config;
    }

    protected Signature createSignatureService() throws NoSuchAlgorithmException, NoSuchProviderException {
        String algorithm = this.config.getAlgorithm();
        String provider = this.config.getProvider();
        Signature signer = provider == null ? Signature.getInstance(algorithm) : Signature.getInstance(algorithm, provider);
        return signer;
    }

    protected void clearMessageHeaders(Message in) {
        if (this.config.isClearHeaders()) {
            Map headers = in.getHeaders();
            for (Field f : DigitalSignatureConstants.class.getFields()) {
                headers.remove(ObjectHelper.lookupConstantFieldValue(DigitalSignatureConstants.class, (String)f.getName()));
            }
        }
    }
}

