/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.crypto;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.converter.crypto.PGPPassphraseAccessor;
import org.apache.camel.converter.crypto.PGPSecretKeyAndPrivateKeyAndUserId;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PGPDataFormatUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PGPDataFormatUtil.class);

    private PGPDataFormatUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PGPPublicKey> findPublicKeys(CamelContext context, String filename, byte[] keyRing, List<String> userids, boolean forEncryption) throws IOException, PGPException {
        InputStream is = PGPDataFormatUtil.determineKeyRingInputStream(context, filename, keyRing, forEncryption);
        try {
            List<PGPPublicKey> list = PGPDataFormatUtil.findPublicKeys(is, userids, forEncryption);
            return list;
        }
        finally {
            IOHelper.close((Closeable)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PGPPublicKeyRingCollection getPublicKeyRingCollection(CamelContext context, String filename, byte[] keyRing, boolean forEncryption) throws IOException, PGPException {
        InputStream is = PGPDataFormatUtil.determineKeyRingInputStream(context, filename, keyRing, forEncryption);
        try {
            PGPPublicKeyRingCollection pGPPublicKeyRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)is), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            return pGPPublicKeyRingCollection;
        }
        finally {
            IOHelper.close((Closeable)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PGPPrivateKey findPrivateKeyWithKeyId(CamelContext context, String filename, byte[] secretKeyRing, long keyid, String passphrase, PGPPassphraseAccessor passpraseAccessor, String provider) throws IOException, PGPException {
        InputStream is = PGPDataFormatUtil.determineKeyRingInputStream(context, filename, secretKeyRing, true);
        try {
            PGPPrivateKey pGPPrivateKey = PGPDataFormatUtil.findPrivateKeyWithKeyId(is, keyid, passphrase, passpraseAccessor, provider);
            return pGPPrivateKey;
        }
        finally {
            IOHelper.close((Closeable)is);
        }
    }

    private static PGPPrivateKey findPrivateKeyWithKeyId(InputStream keyringInput, long keyid, String passphrase, PGPPassphraseAccessor passphraseAccessor, String provider) throws IOException, PGPException {
        PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyringInput), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        return PGPDataFormatUtil.findPrivateKeyWithkeyId(keyid, passphrase, passphraseAccessor, provider, pgpSec);
    }

    public static PGPPrivateKey findPrivateKeyWithkeyId(long keyid, String passphrase, PGPPassphraseAccessor passphraseAccessor, String provider, PGPSecretKeyRingCollection pgpSec) throws PGPException {
        Iterator i = pgpSec.getKeyRings();
        while (i.hasNext()) {
            PGPPrivateKey privateKey;
            PGPSecretKeyRing keyring;
            PGPSecretKey secKey;
            Object data = i.next();
            if (!(data instanceof PGPSecretKeyRing) || (secKey = (keyring = (PGPSecretKeyRing)data).getSecretKey(keyid)) == null) continue;
            if (passphrase == null && passphraseAccessor != null) {
                Iterator userIDs = keyring.getSecretKey().getUserIDs();
                while (passphrase == null && userIDs.hasNext()) {
                    passphrase = passphraseAccessor.getPassphrase((String)userIDs.next());
                }
            }
            if (passphrase != null && (privateKey = secKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider(provider).build(passphrase.toCharArray()))) != null) {
                return privateKey;
            }
            if (passphrase != null || passphraseAccessor != null) continue;
            passphrase = "";
            privateKey = secKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider(provider).build(passphrase.toCharArray()));
            if (privateKey == null) continue;
            return privateKey;
        }
        return null;
    }

    private static InputStream determineKeyRingInputStream(CamelContext context, String filename, byte[] keyRing, boolean forEncryption) throws IOException {
        if (filename != null && keyRing != null) {
            String encryptionOrSignature = forEncryption ? "encryption" : "signature";
            throw new IllegalStateException(String.format("Either specify %s file name or key ring byte array. You can not specify both.", encryptionOrSignature));
        }
        InputStream is = keyRing != null ? new ByteArrayInputStream(keyRing) : ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)filename);
        return is;
    }

    private static List<PGPPublicKey> findPublicKeys(InputStream input, List<String> userids, boolean forEncryption) throws IOException, PGPException {
        PGPPublicKeyRingCollection pgpSec = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)input), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        return PGPDataFormatUtil.findPublicKeys(userids, forEncryption, pgpSec);
    }

    public static List<PGPPublicKey> findPublicKeys(List<String> useridParts, boolean forEncryption, PGPPublicKeyRingCollection pgpPublicKeyringCollection) {
        ArrayList<PGPPublicKey> result = new ArrayList<PGPPublicKey>(useridParts.size());
        Iterator keyRingIter = pgpPublicKeyringCollection.getKeyRings();
        while (keyRingIter.hasNext()) {
            PGPPublicKeyRing keyRing = (PGPPublicKeyRing)keyRingIter.next();
            PGPPublicKey primaryKey = keyRing.getPublicKey();
            String[] foundKeyUserIdForUserIdPart = PGPDataFormatUtil.findFirstKeyUserIdContainingOneOfTheParts(useridParts, primaryKey);
            if (foundKeyUserIdForUserIdPart == null) {
                LOG.debug("No User ID found in primary key with key ID {} containing one of the parts {}", (Object)primaryKey.getKeyID(), useridParts);
                continue;
            }
            LOG.debug("User ID {} found in primary key with key ID {} containing one of the parts {}", new Object[]{foundKeyUserIdForUserIdPart[0], primaryKey.getKeyID(), useridParts});
            Iterator keyIter = keyRing.getPublicKeys();
            while (keyIter.hasNext()) {
                PGPPublicKey key = (PGPPublicKey)keyIter.next();
                if (forEncryption) {
                    if (!PGPDataFormatUtil.isEncryptionKey(key)) continue;
                    LOG.debug("Public encryption key with key user ID {} and key ID {} added to the encryption keys", (Object)foundKeyUserIdForUserIdPart[0], (Object)Long.toString(key.getKeyID()));
                    result.add(key);
                    continue;
                }
                if (forEncryption || !PGPDataFormatUtil.isSignatureKey(key)) continue;
                result.add(key);
                LOG.debug("Public key with key user ID {} and key ID {} added to the signing keys", (Object)foundKeyUserIdForUserIdPart[0], (Object)Long.toString(key.getKeyID()));
            }
        }
        return result;
    }

    private static boolean isEncryptionKey(PGPPublicKey key) {
        if (!key.isEncryptionKey()) {
            return false;
        }
        Boolean hasEncryptionKeyFlags = PGPDataFormatUtil.hasOneOfExpectedKeyFlags(key, new int[]{4, 8});
        if (hasEncryptionKeyFlags != null && !hasEncryptionKeyFlags.booleanValue()) {
            LOG.debug("Public key with key key ID {} found for specified user ID. But this key will not be used for the encryption, because its key flags are not encryption key flags.", (Object)Long.toString(key.getKeyID()));
            return false;
        }
        return true;
    }

    private static String[] findFirstKeyUserIdContainingOneOfTheParts(List<String> useridParts, PGPPublicKey primaryKey) {
        String[] foundKeyUserIdForUserIdPart = null;
        Iterator iterator = primaryKey.getUserIDs();
        while (iterator.hasNext()) {
            String keyUserId = (String)iterator.next();
            for (String userIdPart : useridParts) {
                if (!keyUserId.contains(userIdPart)) continue;
                foundKeyUserIdForUserIdPart = new String[]{keyUserId, userIdPart};
            }
        }
        return foundKeyUserIdForUserIdPart;
    }

    private static boolean isSignatureKey(PGPPublicKey key) {
        int algorithm = key.getAlgorithm();
        return algorithm == 1 || algorithm == 3 || algorithm == 17 || algorithm == 19 || algorithm == 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PGPSecretKeyAndPrivateKeyAndUserId> findSecretKeysWithPrivateKeyAndUserId(CamelContext context, String keychainFilename, byte[] secKeyRing, Map<String, String> sigKeyUserId2Password, String provider) throws IOException, PGPException {
        InputStream keyChainInputStream = PGPDataFormatUtil.determineKeyRingInputStream(context, keychainFilename, secKeyRing, false);
        try {
            List<PGPSecretKeyAndPrivateKeyAndUserId> list = PGPDataFormatUtil.findSecretKeysWithPrivateKeyAndUserId(keyChainInputStream, sigKeyUserId2Password, provider);
            return list;
        }
        finally {
            IOHelper.close((Closeable)keyChainInputStream);
        }
    }

    private static List<PGPSecretKeyAndPrivateKeyAndUserId> findSecretKeysWithPrivateKeyAndUserId(InputStream keyringInput, Map<String, String> sigKeyUserId2Password, String provider) throws IOException, PGPException {
        PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyringInput), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        return PGPDataFormatUtil.findSecretKeysWithPrivateKeyAndUserId(sigKeyUserId2Password, provider, pgpSec);
    }

    public static List<PGPSecretKeyAndPrivateKeyAndUserId> findSecretKeysWithPrivateKeyAndUserId(Map<String, String> sigKeyUserId2Password, String provider, PGPSecretKeyRingCollection pgpSec) throws PGPException {
        ArrayList<PGPSecretKeyAndPrivateKeyAndUserId> result = new ArrayList<PGPSecretKeyAndPrivateKeyAndUserId>(sigKeyUserId2Password.size());
        Iterator i = pgpSec.getKeyRings();
        while (i.hasNext()) {
            Object data = i.next();
            if (!(data instanceof PGPSecretKeyRing)) continue;
            PGPSecretKeyRing keyring = (PGPSecretKeyRing)data;
            PGPSecretKey primaryKey = keyring.getSecretKey();
            ArrayList<String> useridParts = new ArrayList<String>(sigKeyUserId2Password.keySet());
            String[] foundKeyUserIdForUserIdPart = PGPDataFormatUtil.findFirstKeyUserIdContainingOneOfTheParts(useridParts, primaryKey.getPublicKey());
            if (foundKeyUserIdForUserIdPart == null) {
                LOG.debug("No User ID found in primary key with key ID {} containing one of the parts {}", (Object)primaryKey.getKeyID(), useridParts);
                continue;
            }
            LOG.debug("User ID {} found in primary key with key ID {} containing one of the parts {}", new Object[]{foundKeyUserIdForUserIdPart[0], primaryKey.getKeyID(), useridParts});
            Iterator iterKey = keyring.getSecretKeys();
            while (iterKey.hasNext()) {
                PGPPrivateKey privateKey;
                PGPSecretKey secKey = (PGPSecretKey)iterKey.next();
                if (!PGPDataFormatUtil.isSigningKey(secKey) || (privateKey = secKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider(provider).build(sigKeyUserId2Password.get(foundKeyUserIdForUserIdPart[1]).toCharArray()))) == null) continue;
                result.add(new PGPSecretKeyAndPrivateKeyAndUserId(secKey, privateKey, foundKeyUserIdForUserIdPart[0]));
                LOG.debug("Private key with user ID {} and key ID {} added to the signing keys", (Object)foundKeyUserIdForUserIdPart[0], (Object)Long.toString(privateKey.getKeyID()));
            }
        }
        return result;
    }

    private static boolean isSigningKey(PGPSecretKey secKey) {
        if (!secKey.isSigningKey()) {
            return false;
        }
        Boolean hasSigningKeyFlag = PGPDataFormatUtil.hasOneOfExpectedKeyFlags(secKey.getPublicKey(), new int[]{2});
        if (hasSigningKeyFlag != null && !hasSigningKeyFlag.booleanValue()) {
            LOG.debug("Secret key with key ID {} found for specified user ID part. But this key will not be used for signing because of its key flags.", (Object)Long.toString(secKey.getKeyID()));
            return false;
        }
        return true;
    }

    private static Boolean hasOneOfExpectedKeyFlags(PGPPublicKey key, int[] expectedKeyFlags) {
        boolean containsKeyFlags = false;
        Iterator itsig = key.getSignatures();
        while (itsig.hasNext()) {
            PGPSignature sig = (PGPSignature)itsig.next();
            PGPSignatureSubpacketVector subPacks = sig.getHashedSubPackets();
            if (subPacks == null) continue;
            int keyFlag = subPacks.getKeyFlags();
            if (keyFlag > 0 && !containsKeyFlags) {
                containsKeyFlags = true;
            }
            for (int expectdKeyFlag : expectedKeyFlags) {
                int result = keyFlag & expectdKeyFlag;
                if (result != expectdKeyFlag) continue;
                return Boolean.TRUE;
            }
        }
        if (containsKeyFlags) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static PGPPublicKey getPublicKeyWithKeyIdAndUserID(long keyId, List<String> userIdParts, PGPPublicKeyRingCollection publicKeyringCollection) throws PGPException {
        PGPPublicKeyRing publicKeyring = publicKeyringCollection.getPublicKeyRing(keyId);
        if (publicKeyring == null) {
            LOG.debug("No public key found for key ID {}.", (Object)Long.toString(keyId));
            return null;
        }
        if (PGPDataFormatUtil.isAllowedKey(userIdParts, publicKeyring.getPublicKey().getUserIDs())) {
            return publicKeyring.getPublicKey(keyId);
        }
        return null;
    }

    private static boolean isAllowedKey(List<String> allowedUserIds, Iterator<String> verifyingPublicKeyUserIds) {
        if (allowedUserIds == null || allowedUserIds.isEmpty()) {
            return true;
        }
        String keyUserId = null;
        while (verifyingPublicKeyUserIds.hasNext()) {
            keyUserId = verifyingPublicKeyUserIds.next();
            for (String userid : allowedUserIds) {
                if (keyUserId == null || !keyUserId.contains(userid)) continue;
                LOG.debug("Public key with User ID {} fulfills the User ID restriction {}.", (Object)keyUserId, allowedUserIds);
                return true;
            }
        }
        LOG.warn("Public key with User ID {} does not fulfill the User ID restriction {}.", (Object)keyUserId, allowedUserIds);
        return false;
    }
}

