/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.csimple.joor;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.StaticService;
import org.apache.camel.language.csimple.CSimpleCodeGenerator;
import org.apache.camel.language.csimple.CSimpleCompiler;
import org.apache.camel.language.csimple.CSimpleExpression;
import org.apache.camel.language.csimple.CSimpleGeneratedCode;
import org.apache.camel.language.csimple.joor.JoorCSimpleCompilationException;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.ScriptHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.joor.Reflect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="csimple-compiler")
public class JoorCSimpleCompiler
extends ServiceSupport
implements CSimpleCompiler,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(JoorCSimpleCompiler.class);
    private static final AtomicInteger UUID = new AtomicInteger();
    private Set<String> imports = new TreeSet<String>();
    private Map<String, String> aliases;
    private int counter;
    private long taken;

    public Set<String> getImports() {
        return this.imports;
    }

    public void setImports(Set<String> imports) {
        this.imports = imports;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    public void addImport(String imports) {
        this.imports.add(imports);
    }

    public void addAliases(String key, String value) {
        this.aliases.put(key, value);
    }

    public CSimpleExpression compileExpression(CamelContext camelContext, String script) {
        return this.doCompile(camelContext, script, false);
    }

    public CSimpleExpression compilePredicate(CamelContext camelContext, String script) {
        return this.doCompile(camelContext, script, true);
    }

    private CSimpleExpression doCompile(CamelContext camelContext, String script, boolean predicate) {
        CSimpleExpression answer;
        StopWatch watch = new StopWatch();
        String className = JoorCSimpleCompiler.nextFQN();
        CSimpleGeneratedCode code = predicate ? this.evalCodePredicate(camelContext, className, script) : this.evalCodeExpression(camelContext, className, script);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compiling code:\n\n{}\n", (Object)code.getCode());
            }
            Reflect ref = Reflect.compile((String)code.getFqn(), (String)code.getCode());
            Class clazz = ref.type();
            answer = (CSimpleExpression)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new JoorCSimpleCompilationException(code.getFqn(), code.getCode(), e);
        }
        ++this.counter;
        this.taken += watch.taken();
        return answer;
    }

    private CSimpleGeneratedCode evalCodeExpression(CamelContext camelContext, String fqn, String script) {
        return this.doEvalCode(camelContext, fqn, script, false);
    }

    private CSimpleGeneratedCode evalCodePredicate(CamelContext camelContext, String fqn, String script) {
        return this.doEvalCode(camelContext, fqn, script, true);
    }

    private CSimpleGeneratedCode doEvalCode(CamelContext camelContext, String fqn, String script, boolean predicate) {
        script = ScriptHelper.resolveOptionalExternalScript((CamelContext)camelContext, (String)script);
        script = script.trim();
        CSimpleCodeGenerator generator = new CSimpleCodeGenerator();
        if (this.aliases != null && !this.aliases.isEmpty()) {
            generator.setAliases(this.aliases);
        }
        if (this.imports != null && !this.imports.isEmpty()) {
            generator.setImports(this.imports);
        }
        CSimpleGeneratedCode code = predicate ? generator.generatePredicate(fqn, script) : generator.generateExpression(fqn, script);
        return code;
    }

    private static String nextFQN() {
        return "org.apache.camel.language.csimple.joor.compiled.CSimpleJoorScript" + UUID.incrementAndGet();
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.counter > 0) {
            LOG.info("csimple-joor compiled {} scripts in {}", (Object)this.counter, (Object)TimeUtils.printDuration((long)this.taken));
        }
    }
}

