/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.dataformat.csv.CsvDataFormat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public abstract class CsvMarshaller {
    private final CSVFormat format;

    protected CsvMarshaller(CSVFormat format) {
        this.format = format;
    }

    public static CsvMarshaller create(CSVFormat format, CsvDataFormat dataFormat) {
        String header;
        ObjectHelper.notNull((Object)format, (String)"CSV format");
        ObjectHelper.notNull((Object)((Object)dataFormat), (String)"CSV data format");
        if (format.getSkipHeaderRecord()) {
            format = format.withHeader((String[])null);
        }
        if ((header = dataFormat.getHeader()) != null && !header.isEmpty()) {
            String[] columns = header.split(",");
            return new FixedColumnsMarshaller(format, columns);
        }
        return new DynamicColumnsMarshaller(format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object object, OutputStream outputStream) throws NoTypeConversionAvailableException, IOException {
        CSVPrinter printer = this.createPrinter(exchange, outputStream);
        try {
            if (object instanceof Map) {
                Map map = (Map)object;
                printer.printRecord(this.getMapRecordValues(map));
            } else {
                Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)object);
                while (it.hasNext()) {
                    Object child = it.next();
                    printer.printRecord(this.getRecordValues(exchange, child));
                }
            }
        }
        finally {
            IOHelper.close((Closeable)printer);
        }
    }

    protected CSVPrinter createPrinter(Exchange exchange, OutputStream outputStream) throws IOException {
        ObjectHelper.notNull((Object)exchange, (String)"Exchange");
        ObjectHelper.notNull((Object)outputStream, (String)"Output stream");
        return new CSVPrinter((Appendable)new OutputStreamWriter(outputStream, ExchangeHelper.getCharsetName((Exchange)exchange)), this.format);
    }

    private Iterable<?> getRecordValues(Exchange exchange, Object data) throws NoTypeConversionAvailableException {
        Map map = (Map)exchange.getContext().getTypeConverter().tryConvertTo(Map.class, exchange, data);
        if (map != null) {
            return this.getMapRecordValues(map);
        }
        return (Iterable)ExchangeHelper.convertToMandatoryType((Exchange)exchange, List.class, (Object)data);
    }

    protected abstract Iterable<?> getMapRecordValues(Map<?, ?> var1);

    private static final class DynamicColumnsMarshaller
    extends CsvMarshaller {
        private DynamicColumnsMarshaller(CSVFormat format) {
            super(format);
        }

        @Override
        protected Iterable<?> getMapRecordValues(Map<?, ?> map) {
            ArrayList result = new ArrayList(map.size());
            result.addAll(map.values());
            return result;
        }
    }

    private static final class FixedColumnsMarshaller
    extends CsvMarshaller {
        private final String[] fixedColumns;

        private FixedColumnsMarshaller(CSVFormat format, String[] fixedColumns) {
            super(format);
            this.fixedColumns = Arrays.copyOf(fixedColumns, fixedColumns.length);
        }

        @Override
        protected Iterable<?> getMapRecordValues(Map<?, ?> map) {
            ArrayList result = new ArrayList(this.fixedColumns.length);
            for (String key : this.fixedColumns) {
                result.add(map.get(key));
            }
            return result;
        }
    }
}

