/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpointFactoryBean;
import org.apache.camel.component.cxf.jaxrs.DefaultCxfRsEndpointFactoryBean;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.HeaderFilterStrategyComponent;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.CastUtils;
import org.apache.cxf.jaxrs.AbstractJAXRSFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="cxfrs")
public class CxfRsComponent
extends HeaderFilterStrategyComponent
implements SSLContextParametersAware {
    private static final Logger LOG = LoggerFactory.getLogger(CxfRsComponent.class);
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;
    @Metadata(defaultValue="false", label="producer,advanced", description="Sets whether synchronous processing should be strictly used")
    private boolean synchronous;

    public CxfRsComponent() {
    }

    public CxfRsComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Object value = parameters.remove("setDefaultBus");
        if (value != null) {
            LOG.warn("The option setDefaultBus is @deprecated, use name defaultBus instead");
            if (!parameters.containsKey("defaultBus")) {
                parameters.put("defaultBus", value);
            }
        }
        CxfRsEndpoint answer = this.doCreateEndpoint(remaining);
        answer.setSynchronous(this.isSynchronous());
        String resourceClass = (String)this.getAndRemoveParameter(parameters, "resourceClass", String.class);
        if (resourceClass != null) {
            Class clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass(resourceClass);
            answer.addResourceClass(clazz);
        }
        String resourceClasses = (String)this.getAndRemoveParameter(parameters, "resourceClasses", String.class);
        Iterator it = ObjectHelper.createIterator((Object)resourceClasses);
        while (it.hasNext()) {
            String name = (String)it.next();
            Class clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass(name);
            answer.addResourceClass(clazz);
        }
        this.setProperties((Endpoint)answer, parameters);
        Map params = CastUtils.cast(parameters);
        answer.setParameters(params);
        this.setEndpointHeaderFilterStrategy((Endpoint)answer);
        if (answer.getSslContextParameters() == null) {
            answer.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return answer;
    }

    private CxfRsEndpoint doCreateEndpoint(String remaining) throws Exception {
        CxfRsEndpoint answer = remaining.startsWith("bean:") ? this.createSpringContextEndpoint(remaining) : new CxfRsEndpoint(remaining, (Component)this);
        return answer;
    }

    private CxfRsEndpoint createSpringContextEndpoint(String remaining) throws Exception {
        String beanId = remaining.substring("bean:".length());
        if (beanId.startsWith("//")) {
            beanId = beanId.substring(2);
        }
        AbstractJAXRSFactoryBean bean = (AbstractJAXRSFactoryBean)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)beanId, AbstractJAXRSFactoryBean.class);
        CxfRsEndpointFactoryBean factory = null;
        if (bean.getClass().getName().contains("blueprint")) {
            clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass("org.apache.camel.component.cxf.jaxrs.blueprint.CxfRsBlueprintEndpointFactoryBean", CxfRsEndpointFactoryBean.class);
            factory = (CxfRsEndpointFactoryBean)this.getCamelContext().getInjector().newInstance(clazz);
        } else {
            try {
                clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass("org.apache.camel.component.cxf.spring.jaxrs.SpringCxfRsEndpointFactoryBean", CxfRsEndpointFactoryBean.class);
                factory = (CxfRsEndpointFactoryBean)this.getCamelContext().getInjector().newInstance(clazz);
            }
            catch (Exception ex) {
                factory = new DefaultCxfRsEndpointFactoryBean();
            }
        }
        CxfRsEndpoint answer = factory.createEndpoint((Component)this, remaining, bean);
        if (bean.getProperties() != null) {
            HashMap copy = new HashMap(bean.getProperties());
            this.setProperties((Endpoint)answer, copy);
        }
        answer.setBeanId(beanId);
        return answer;
    }

    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        CxfRsEndpoint cxfRsEndpoint = (CxfRsEndpoint)endpoint;
        cxfRsEndpoint.updateEndpointUri(uri);
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }
}

