/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cxf.WSDLServiceFactoryBean;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.wsdl.WSDLManager;

public class WSDLServiceConfiguration
extends AbstractServiceConfiguration {
    private WSDLServiceFactoryBean serviceFactoryBean;
    private Definition definition;
    private QName serviceQName;
    private QName endpointQName;

    public WSDLServiceConfiguration(WSDLServiceFactoryBean factoryBean) {
        this.serviceFactoryBean = factoryBean;
    }

    protected Definition getDefinition() {
        if (this.definition == null) {
            try {
                this.definition = ((WSDLManager)this.serviceFactoryBean.getBus().getExtension(WSDLManager.class)).getDefinition(this.serviceFactoryBean.getWsdlURL());
            }
            catch (Exception ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }
        return this.definition;
    }

    protected QName getServiceQName() {
        if (this.serviceQName == null) {
            Map services = CastUtils.cast((Map)this.getDefinition().getServices());
            if (services.size() == 0) {
                throw new IllegalArgumentException("There is no service in the WSDL" + this.serviceFactoryBean.getWsdlURL());
            }
            if (services.size() > 1) {
                throw new IllegalArgumentException("service name must be specified, there is more than one service in the WSDL" + this.serviceFactoryBean.getWsdlURL());
            }
            this.serviceQName = (QName)services.keySet().iterator().next();
        }
        return this.serviceQName;
    }

    protected QName getEndpointQName() {
        if (this.endpointQName == null) {
            Service service = this.getDefinition().getService(this.serviceFactoryBean.getServiceQName());
            if (service == null) {
                throw new IllegalArgumentException("There is no service " + this.serviceFactoryBean.getServiceQName() + " in WSDL " + this.serviceFactoryBean.getWsdlURL());
            }
            Map ports = CastUtils.cast((Map)service.getPorts());
            if (ports.size() == 0) {
                throw new IllegalArgumentException("There is no port/endpoint in the service " + this.serviceFactoryBean.getServiceQName() + "of WSDL" + this.serviceFactoryBean.getWsdlURL());
            }
            if (ports.size() > 1) {
                throw new IllegalArgumentException("Port/endpoint name must be specified, There is more than one port in the service" + this.serviceFactoryBean.getServiceQName() + " of the WSDL" + this.serviceFactoryBean.getWsdlURL());
            }
            this.endpointQName = new QName(service.getQName().getNamespaceURI(), (String)ports.keySet().iterator().next());
        }
        return this.endpointQName;
    }

    public String getServiceName() {
        return this.getServiceQName().getLocalPart();
    }

    public String getServiceNamespace() {
        return this.getServiceQName().getNamespaceURI();
    }

    public QName getEndpointName() {
        return this.getEndpointQName();
    }
}

