/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.blueprint;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.camel.component.cxf.blueprint.EndpointDefinitionParser;
import org.apache.camel.component.cxf.blueprint.RsClientDefinitionParser;
import org.apache.camel.component.cxf.blueprint.RsServerDefinitionParser;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CxfNamespaceHandler
implements NamespaceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CxfNamespaceHandler.class);

    public URL getSchemaLocation(String s) {
        return this.getClass().getClassLoader().getResource("schema/blueprint/camel-cxf.xsd");
    }

    public Set<Class> getManagedClasses() {
        return new HashSet<Class>(Arrays.asList(CxfNamespaceHandler.class));
    }

    public Metadata parse(Element element, ParserContext context) {
        Metadata answer = null;
        String s = element.getLocalName();
        if ("cxfEndpoint".equals(s)) {
            LOG.debug("parsing the cxfEndpoint element");
            answer = new EndpointDefinitionParser().parse(element, context);
        }
        if ("rsClient".equals(s)) {
            LOG.debug("parsing the rsClient element");
            answer = new RsClientDefinitionParser().parse(element, context);
        }
        if ("rsServer".equals(s)) {
            LOG.debug("parsing the rsServer element");
            answer = new RsServerDefinitionParser().parse(element, context);
        }
        return answer;
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata componentMetadata, ParserContext parserContext) {
        return null;
    }
}

