/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.lang.reflect.Method;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cxf.jaxrs.CxfRsBinding;
import org.apache.camel.component.cxf.jaxrs.CxfRsConsumer;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.RequestImpl;
import org.apache.cxf.jaxrs.impl.SecurityContextImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxfRsInvoker
extends JAXRSInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(CxfRsInvoker.class);
    private static final String SUSPENED = "org.apache.camel.component.cxf.jaxrs.suspend";
    private final CxfRsConsumer cxfRsConsumer;
    private final CxfRsEndpoint endpoint;

    public CxfRsInvoker(CxfRsEndpoint endpoint, CxfRsConsumer consumer) {
        this.endpoint = endpoint;
        this.cxfRsConsumer = consumer;
    }

    protected Object performInvocation(org.apache.cxf.message.Exchange cxfExchange, Object serviceObject, Method method, Object[] paramArray) throws Exception {
        Continuation continuation;
        Object response = null;
        if (this.endpoint.isPerformInvocation()) {
            response = super.performInvocation(cxfExchange, serviceObject, method, paramArray);
        }
        paramArray = this.insertExchange(method, paramArray, cxfExchange);
        OperationResourceInfo ori = (OperationResourceInfo)cxfExchange.get(OperationResourceInfo.class);
        if (ori.isSubResourceLocator()) {
            return method.invoke(serviceObject, paramArray);
        }
        if (!this.endpoint.isSynchronous() && (continuation = this.getContinuation(cxfExchange)) != null) {
            LOG.trace("Calling the Camel async processors.");
            return this.asyncInvoke(cxfExchange, serviceObject, method, paramArray, continuation, response);
        }
        LOG.trace("Calling the Camel sync processors.");
        return this.syncInvoke(cxfExchange, serviceObject, method, paramArray, response);
    }

    private Continuation getContinuation(org.apache.cxf.message.Exchange cxfExchange) {
        ContinuationProvider provider = (ContinuationProvider)cxfExchange.getInMessage().get((Object)ContinuationProvider.class.getName());
        return provider == null ? null : provider.getContinuation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object asyncInvoke(org.apache.cxf.message.Exchange cxfExchange, Object serviceObject, Method method, Object[] paramArray, final Continuation continuation, Object response) throws Exception {
        Continuation continuation2 = continuation;
        synchronized (continuation2) {
            if (continuation.isNew()) {
                final Exchange camelExchange = this.prepareExchange(cxfExchange, method, paramArray, response);
                this.cxfRsConsumer.createUoW(camelExchange);
                LOG.trace("Suspending continuation of exchangeId: {}", (Object)camelExchange.getExchangeId());
                continuation.suspend(this.endpoint.getContinuationTimeout());
                cxfExchange.put((Object)SUSPENED, (Object)Boolean.TRUE);
                continuation.setObject((Object)camelExchange);
                this.cxfRsConsumer.getAsyncProcessor().process(camelExchange, new AsyncCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void done(boolean doneSync) {
                        Continuation continuation2 = continuation;
                        synchronized (continuation2) {
                            LOG.trace("Resuming continuation of exchangeId: {}", (Object)camelExchange.getExchangeId());
                            continuation.resume();
                        }
                    }
                });
                return null;
            }
            if (continuation.isResumed()) {
                cxfExchange.put((Object)SUSPENED, (Object)Boolean.FALSE);
                Exchange camelExchange = (Exchange)continuation.getObject();
                try {
                    return this.returnResponse(cxfExchange, camelExchange);
                }
                catch (Exception ex) {
                    this.cxfRsConsumer.doneUoW(camelExchange);
                    throw ex;
                }
            }
            if (!continuation.isPending()) {
                cxfExchange.put((Object)SUSPENED, (Object)Boolean.FALSE);
                Exchange camelExchange = (Exchange)continuation.getObject();
                camelExchange.setException((Throwable)new ExchangeTimedOutException(camelExchange, this.endpoint.getContinuationTimeout()));
                try {
                    return this.returnResponse(cxfExchange, camelExchange);
                }
                catch (Exception ex) {
                    this.cxfRsConsumer.doneUoW(camelExchange);
                    throw ex;
                }
            }
        }
        return null;
    }

    private Object syncInvoke(org.apache.cxf.message.Exchange cxfExchange, Object serviceObject, Method method, Object[] paramArray, Object response) throws Exception {
        Exchange camelExchange = this.prepareExchange(cxfExchange, method, paramArray, response);
        this.cxfRsConsumer.createUoW(camelExchange);
        try {
            this.cxfRsConsumer.getProcessor().process(camelExchange);
        }
        catch (Exception exception) {
            camelExchange.setException((Throwable)exception);
        }
        try {
            return this.returnResponse(cxfExchange, camelExchange);
        }
        catch (Exception ex) {
            this.cxfRsConsumer.doneUoW(camelExchange);
            throw ex;
        }
    }

    private Exchange prepareExchange(org.apache.cxf.message.Exchange cxfExchange, Method method, Object[] paramArray, Object response) {
        ExchangePattern ep = ExchangePattern.InOut;
        if (method.getReturnType() == Void.class) {
            ep = ExchangePattern.InOnly;
        }
        Exchange camelExchange = this.endpoint.createExchange(ep);
        cxfExchange.put(Exchange.class, (Object)camelExchange);
        if (response != null) {
            camelExchange.getOut().setBody(response);
        }
        CxfRsBinding binding = this.endpoint.getBinding();
        binding.populateExchangeFromCxfRsRequest(cxfExchange, camelExchange, method, paramArray);
        if (this.endpoint.isPropagateContexts()) {
            camelExchange.setProperty(UriInfo.class.getName(), (Object)new UriInfoImpl(cxfExchange.getInMessage()));
            camelExchange.setProperty(Request.class.getName(), (Object)new RequestImpl(cxfExchange.getInMessage()));
            camelExchange.setProperty(HttpHeaders.class.getName(), (Object)new HttpHeadersImpl(cxfExchange.getInMessage()));
            camelExchange.setProperty(SecurityContext.class.getName(), (Object)new SecurityContextImpl(cxfExchange.getInMessage()));
        }
        return camelExchange;
    }

    private Object returnResponse(org.apache.cxf.message.Exchange cxfExchange, Exchange camelExchange) throws Exception {
        if (camelExchange.getException() != null) {
            Throwable exception = camelExchange.getException();
            Response result = null;
            if (exception instanceof RuntimeCamelException && exception.getCause() != null) {
                exception = exception.getCause();
            }
            if (exception instanceof WebApplicationException) {
                result = ((WebApplicationException)exception).getResponse();
                if (result != null) {
                    return result;
                }
                throw (WebApplicationException)exception;
            }
        }
        return this.endpoint.getBinding().populateCxfRsResponseFromExchange(camelExchange, cxfExchange);
    }
}

