/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.ws.Provider;
import org.apache.camel.RuntimeCamelException;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.wsdl.WSDLManager;

public class WSDLServiceFactoryBean
extends JaxWsServiceFactoryBean {
    private Definition definition;

    public WSDLServiceFactoryBean() {
        this.setServiceClass(Provider.class);
    }

    public WSDLServiceFactoryBean(Class<?> serviceClass) {
        this.setServiceClass(serviceClass);
    }

    public void setServiceClass(Class<?> serviceClass) {
        if (serviceClass != null) {
            super.setServiceClass(serviceClass);
        }
    }

    protected Definition getDefinition(String url) {
        if (this.definition == null) {
            try {
                this.definition = ((WSDLManager)this.getBus().getExtension(WSDLManager.class)).getDefinition(url);
            }
            catch (Exception ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }
        if (this.getServiceQName(false) == null) {
            Map services = CastUtils.cast((Map)this.definition.getServices());
            if (services.size() == 0) {
                throw new IllegalArgumentException("There is no service in the WSDL" + url);
            }
            if (services.size() > 1) {
                throw new IllegalArgumentException("service name must be specified, there is more than one service in the WSDL" + url);
            }
            QName serviceQName = (QName)services.keySet().iterator().next();
            this.setServiceName(serviceQName);
        }
        if (this.getEndpointName(false) == null) {
            Service service = this.definition.getService(this.getServiceQName(false));
            Map ports = CastUtils.cast((Map)service.getPorts());
            if (ports.size() == 0) {
                throw new IllegalArgumentException("There is no port/endpoint in the service " + this.getServiceQName() + "of WSDL" + url);
            }
            if (ports.size() > 1) {
                throw new IllegalArgumentException("Port/endpoint name must be specified, There is more than one port in the service" + service.getQName() + " of the WSDL" + url);
            }
            QName endpointQName = new QName(service.getQName().getNamespaceURI(), (String)ports.keySet().iterator().next());
            this.setEndpointName(endpointQName);
        }
        return this.definition;
    }

    protected void buildServiceFromWSDL(String url) {
        this.getDefinition(url);
        super.buildServiceFromWSDL(url);
    }

    public Endpoint createEndpoint(EndpointInfo ei) throws EndpointException {
        JaxWsEndpointImpl ep = new JaxWsEndpointImpl(this.getBus(), this.getService(), ei);
        this.sendEvent(FactoryBeanListener.Event.ENDPOINT_CREATED, new Object[]{ei, ep, this.getServiceClass()});
        return ep;
    }

    protected void initializeWSDLOperations() {
    }

    protected void checkServiceClassAnnotations(Class<?> sc) {
    }

    protected Invoker createInvoker() {
        return null;
    }
}

