/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.component.cxf.NullFaultListener;
import org.apache.camel.component.cxf.jaxrs.BindingStyle;
import org.apache.camel.component.cxf.jaxrs.CamelResourceProvider;
import org.apache.camel.component.cxf.jaxrs.ChainedCxfRsEndpointConfigurer;
import org.apache.camel.component.cxf.jaxrs.CxfRsBinding;
import org.apache.camel.component.cxf.jaxrs.CxfRsConsumer;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpointConfigurer;
import org.apache.camel.component.cxf.jaxrs.CxfRsHeaderFilterStrategy;
import org.apache.camel.component.cxf.jaxrs.CxfRsProducer;
import org.apache.camel.component.cxf.jaxrs.DefaultCxfRsBinding;
import org.apache.camel.component.cxf.jaxrs.DefaultModelResource;
import org.apache.camel.component.cxf.jaxrs.HostnameVerifierCxfRsEndpointConfigurer;
import org.apache.camel.component.cxf.jaxrs.SimpleCxfRsBinding;
import org.apache.camel.component.cxf.jaxrs.SslCxfRsEndpointConfigurer;
import org.apache.camel.http.common.cookie.CookieHandler;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.SynchronousDelegateProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.ModCountCopyOnWriteArrayList;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxrs.AbstractJAXRSFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.logging.FaultListener;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.0.0", scheme="cxfrs", title="CXF-RS", syntax="cxfrs:beanId:address", consumerClass=CxfRsConsumer.class, label="rest", lenientProperties=true)
public class CxfRsEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware,
Service {
    private static final Logger LOG = LoggerFactory.getLogger(CxfRsEndpoint.class);
    @UriParam(label="advanced")
    protected Bus bus;
    private final InterceptorHolder interceptorHolder = new InterceptorHolder();
    private Map<String, String> parameters;
    private Map<String, Object> properties;
    @UriPath(description="To lookup an existing configured CxfRsEndpoint. Must used bean: as prefix.")
    private String beanId;
    @UriPath
    private String address;
    @UriParam
    private List<Class<?>> resourceClasses;
    @UriParam(label="consumer,advanced")
    private List<Object> serviceBeans;
    @UriParam
    private String modelRef;
    @UriParam(label="consumer", defaultValue="Default")
    private BindingStyle bindingStyle = BindingStyle.Default;
    @UriParam(label="consumer")
    private String publishedEndpointUrl;
    @UriParam(label="advanced")
    private HeaderFilterStrategy headerFilterStrategy;
    @UriParam(label="advanced")
    private CxfRsBinding binding;
    @UriParam(javaType="java.lang.String")
    private List<Object> providers = new LinkedList<Object>();
    private String providersRef;
    @UriParam
    private List<String> schemaLocations;
    @UriParam
    private List<Feature> features = new ModCountCopyOnWriteArrayList();
    @UriParam(label="producer,advanced", defaultValue="true")
    private boolean httpClientAPI = true;
    @UriParam(label="producer,advanced")
    private boolean ignoreDeleteMethodMessageBody;
    @UriParam(label="producer", defaultValue="true")
    private boolean throwExceptionOnFailure = true;
    @UriParam(label="producer,advanced", defaultValue="10")
    private int maxClientCacheSize = 10;
    @UriParam(label="producer")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="producer")
    private HostnameVerifier hostnameVerifier;
    @UriParam
    private boolean loggingFeatureEnabled;
    @UriParam
    private int loggingSizeLimit;
    @UriParam
    private boolean skipFaultLogging;
    @UriParam(label="advanced", defaultValue="30000")
    private long continuationTimeout = 30000L;
    @UriParam(label="advanced")
    private boolean defaultBus;
    @UriParam(label="advanced")
    private boolean performInvocation;
    @UriParam(label="advanced")
    private boolean propagateContexts;
    @UriParam(label="advanced")
    private CxfRsEndpointConfigurer cxfRsEndpointConfigurer;
    @UriParam(label="producer")
    private CookieHandler cookieHandler;

    public CxfRsEndpoint() {
    }

    @Deprecated
    public CxfRsEndpoint(String endpointUri, CamelContext camelContext) {
        super(endpointUri, camelContext);
        this.setAddress(endpointUri);
    }

    public CxfRsEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
        this.setAddress(endpointUri);
    }

    public boolean isLenientProperties() {
        return true;
    }

    protected void updateEndpointUri(String endpointUri) {
        super.setEndpointUri(endpointUri);
    }

    public void setParameters(Map<String, String> param) {
        this.parameters = param;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setHttpClientAPI(boolean clientAPI) {
        this.httpClientAPI = clientAPI;
    }

    public boolean isHttpClientAPI() {
        return this.httpClientAPI;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        CxfRsConsumer answer = new CxfRsConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        if (this.bindingStyle == BindingStyle.SimpleConsumer) {
            throw new IllegalArgumentException("The SimpleConsumer Binding Style cannot be used in a camel-cxfrs producer");
        }
        CxfRsProducer cxfRsProducer = new CxfRsProducer(this);
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)cxfRsProducer);
        }
        return cxfRsProducer;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBinding(CxfRsBinding binding) {
        this.binding = binding;
    }

    public CxfRsBinding getBinding() {
        return this.binding;
    }

    public boolean isSkipFaultLogging() {
        return this.skipFaultLogging;
    }

    public CxfRsEndpointConfigurer getChainedCxfRsEndpointConfigurer() {
        return ChainedCxfRsEndpointConfigurer.create(this.getNullSafeCxfRsEndpointConfigurer(), SslCxfRsEndpointConfigurer.create(this.sslContextParameters, this.getCamelContext())).addChild(HostnameVerifierCxfRsEndpointConfigurer.create(this.hostnameVerifier));
    }

    public void setSkipFaultLogging(boolean skipFaultLogging) {
        this.skipFaultLogging = skipFaultLogging;
    }

    protected void checkBeanType(Object object, Class<?> clazz) {
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("The configure bean is not the instance of " + clazz.getName());
        }
    }

    protected void setupJAXRSServerFactoryBean(JAXRSServerFactoryBean sfb) {
        if (this.getAddress() != null) {
            sfb.setAddress(this.getAddress());
        }
        this.processResourceModel(sfb);
        if (this.getResourceClasses() != null) {
            sfb.setResourceClasses(this.getResourceClasses());
        }
        if (this.serviceBeans != null && !this.serviceBeans.isEmpty()) {
            sfb.setServiceBeans(this.serviceBeans);
        }
        List cris = sfb.getServiceFactory().getClassResourceInfo();
        for (ClassResourceInfo cri : cris) {
            Class serviceClass = cri.getServiceClass();
            if (!serviceClass.isInterface()) continue;
            cri.setResourceProvider((ResourceProvider)new CamelResourceProvider(serviceClass));
        }
        this.setupCommonFactoryProperties((AbstractJAXRSFactoryBean)sfb);
        sfb.setStart(false);
        this.getNullSafeCxfRsEndpointConfigurer().configure((AbstractJAXRSFactoryBean)sfb);
    }

    protected CxfRsEndpointConfigurer getNullSafeCxfRsEndpointConfigurer() {
        if (this.cxfRsEndpointConfigurer == null) {
            return new ChainedCxfRsEndpointConfigurer.NullCxfRsEndpointConfigurer();
        }
        return this.cxfRsEndpointConfigurer;
    }

    private void processResourceModel(JAXRSServerFactoryBean sfb) {
        if (this.modelRef != null) {
            List resources = ResourceUtils.getUserResources((String)this.modelRef, (Bus)sfb.getBus());
            this.processUserResources(sfb, resources);
        }
    }

    private void processUserResources(JAXRSServerFactoryBean sfb, List<UserResource> resources) {
        for (UserResource resource : resources) {
            if (!StringUtils.isEmpty((String)resource.getName())) continue;
            resource.setName(DefaultModelResource.class.getName());
        }
        sfb.setModelBeans(resources);
    }

    protected void setupJAXRSClientFactoryBean(JAXRSClientFactoryBean cfb, String address) {
        if (this.modelRef != null) {
            cfb.setModelRef(this.modelRef);
        }
        if (this.getResourceClasses() != null && !this.getResourceClasses().isEmpty()) {
            cfb.setResourceClass(this.getResourceClasses().get(0));
            cfb.getServiceFactory().setResourceClasses(this.getResourceClasses());
        }
        this.setupCommonFactoryProperties((AbstractJAXRSFactoryBean)cfb);
        cfb.setThreadSafe(true);
        this.getNullSafeCxfRsEndpointConfigurer().configure((AbstractJAXRSFactoryBean)cfb);
        if (address != null) {
            cfb.setAddress(address);
        }
    }

    protected void setupCommonFactoryProperties(AbstractJAXRSFactoryBean factory) {
        if (!this.getProviders().isEmpty()) {
            factory.setProviders(this.getProviders());
        }
        if (!this.getFeatures().isEmpty()) {
            factory.getFeatures().addAll(this.getFeatures());
        }
        if (this.publishedEndpointUrl != null) {
            factory.setPublishedEndpointUrl(this.publishedEndpointUrl);
        }
        if (!this.interceptorHolder.getInInterceptors().isEmpty()) {
            factory.setInInterceptors(this.interceptorHolder.getInInterceptors());
        }
        if (!this.interceptorHolder.getOutInterceptors().isEmpty()) {
            factory.setOutInterceptors(this.interceptorHolder.getOutInterceptors());
        }
        if (!this.interceptorHolder.getOutFaultInterceptors().isEmpty()) {
            factory.setOutFaultInterceptors(this.interceptorHolder.getOutFaultInterceptors());
        }
        if (!this.interceptorHolder.getInFaultInterceptors().isEmpty()) {
            factory.setInFaultInterceptors(this.interceptorHolder.getInFaultInterceptors());
        }
        if (this.getProperties() != null) {
            if (factory.getProperties() != null) {
                factory.getProperties().putAll(this.getProperties());
            } else {
                factory.setProperties(this.getProperties());
            }
            LOG.debug("JAXRS FactoryBean: {} added properties: {}", (Object)factory, this.getProperties());
        }
        if (this.isLoggingFeatureEnabled()) {
            LoggingFeature loggingFeature = new LoggingFeature();
            if (this.getLoggingSizeLimit() > 0) {
                loggingFeature.setLimit(this.getLoggingSizeLimit());
            }
            factory.getFeatures().add(loggingFeature);
        }
        if (this.isSkipFaultLogging()) {
            if (factory.getProperties() == null) {
                factory.setProperties(new HashMap());
            }
            factory.getProperties().put(FaultListener.class.getName(), new NullFaultListener());
        }
    }

    protected JAXRSServerFactoryBean newJAXRSServerFactoryBean() {
        return new JAXRSServerFactoryBean(){

            protected boolean isValidClassResourceInfo(ClassResourceInfo cri) {
                return !CxfRsEndpoint.this.performInvocation || !cri.getServiceClass().isInterface();
            }
        };
    }

    protected JAXRSClientFactoryBean newJAXRSClientFactoryBean() {
        return new JAXRSClientFactoryBean();
    }

    protected String resolvePropertyPlaceholders(String str) {
        try {
            if (this.getCamelContext() != null) {
                return this.getCamelContext().resolvePropertyPlaceholders(str);
            }
            return str;
        }
        catch (Exception ex) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)ex);
        }
    }

    public JAXRSServerFactoryBean createJAXRSServerFactoryBean() {
        JAXRSServerFactoryBean answer = this.newJAXRSServerFactoryBean();
        this.setupJAXRSServerFactoryBean(answer);
        return answer;
    }

    public JAXRSClientFactoryBean createJAXRSClientFactoryBean() {
        return this.createJAXRSClientFactoryBean(this.getAddress());
    }

    public JAXRSClientFactoryBean createJAXRSClientFactoryBean(String address) {
        JAXRSClientFactoryBean answer = this.newJAXRSClientFactoryBean();
        this.setupJAXRSClientFactoryBean(answer, address);
        return answer;
    }

    public List<Class<?>> getResourceClasses() {
        return this.resourceClasses;
    }

    public void addResourceClass(Class<?> resourceClass) {
        if (this.resourceClasses == null) {
            this.resourceClasses = new ArrayList();
        }
        this.resourceClasses.add(resourceClass);
    }

    public void setResourceClasses(List<Class<?>> resourceClasses) {
        this.resourceClasses = resourceClasses;
    }

    public void setResourceClasses(Class<?> ... classes) {
        this.setResourceClasses(Arrays.asList(classes));
    }

    public List<?> getServiceBeans() {
        return this.serviceBeans;
    }

    public void addServiceBean(Object bean) {
        if (this.serviceBeans == null) {
            this.serviceBeans = new ArrayList<Object>();
        }
        this.serviceBeans.add(bean);
    }

    public void setServiceBeans(List<?> beans) {
        this.serviceBeans = new ArrayList(beans);
    }

    public void setServiceBeans(Object ... beans) {
        this.setServiceBeans(Arrays.asList(beans));
    }

    public void setServiceBeans(String beans) {
        this.setServiceBeans(EndpointHelper.resolveReferenceListParameter((CamelContext)this.getCamelContext(), (String)beans, Object.class));
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setModelRef(String ref) {
        this.modelRef = ref;
    }

    public String getAddress() {
        return this.resolvePropertyPlaceholders(this.address);
    }

    public String getPublishedEndpointUrl() {
        return this.publishedEndpointUrl;
    }

    public void setPublishedEndpointUrl(String publishedEndpointUrl) {
        this.publishedEndpointUrl = publishedEndpointUrl;
    }

    public boolean isLoggingFeatureEnabled() {
        return this.loggingFeatureEnabled;
    }

    public void setLoggingFeatureEnabled(boolean loggingFeatureEnabled) {
        this.loggingFeatureEnabled = loggingFeatureEnabled;
    }

    public int getLoggingSizeLimit() {
        return this.loggingSizeLimit;
    }

    public void setLoggingSizeLimit(int loggingSizeLimit) {
        this.loggingSizeLimit = loggingSizeLimit;
    }

    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public void setMaxClientCacheSize(int maxClientCacheSize) {
        this.maxClientCacheSize = maxClientCacheSize;
    }

    public int getMaxClientCacheSize() {
        return this.maxClientCacheSize;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
        if (this.defaultBus) {
            BusFactory.setDefaultBus((Bus)bus);
            LOG.debug("Set bus {} as thread default bus", (Object)bus);
        }
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setDefaultBus(boolean isSetDefaultBus) {
        this.defaultBus = isSetDefaultBus;
    }

    public boolean isDefaultBus() {
        return this.defaultBus;
    }

    public boolean isIgnoreDeleteMethodMessageBody() {
        return this.ignoreDeleteMethodMessageBody;
    }

    public void setIgnoreDeleteMethodMessageBody(boolean ignoreDeleteMethodMessageBody) {
        this.ignoreDeleteMethodMessageBody = ignoreDeleteMethodMessageBody;
    }

    public BindingStyle getBindingStyle() {
        return this.bindingStyle;
    }

    public List<?> getProviders() {
        return this.providers;
    }

    public void setProviders(List<?> providers) {
        this.providers.addAll(providers);
    }

    public void setProviders(String providers) {
        this.providersRef = providers;
    }

    public void setProvider(Object provider) {
        this.providers.add(provider);
    }

    public void setSchemaLocation(String schema) {
        this.setSchemaLocations(Collections.singletonList(schema));
    }

    public void setSchemaLocations(List<String> schemas) {
        this.schemaLocations = schemas;
    }

    public List<String> getSchemaLocations() {
        return this.schemaLocations;
    }

    public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
        return this.interceptorHolder.getOutFaultInterceptors();
    }

    public List<Interceptor<? extends Message>> getInFaultInterceptors() {
        return this.interceptorHolder.getInFaultInterceptors();
    }

    public List<Interceptor<? extends Message>> getInInterceptors() {
        return this.interceptorHolder.getInInterceptors();
    }

    public List<Interceptor<? extends Message>> getOutInterceptors() {
        return this.interceptorHolder.getOutInterceptors();
    }

    public void setInInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.interceptorHolder.setInInterceptors(interceptors);
    }

    public void setInFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.interceptorHolder.setInFaultInterceptors(interceptors);
    }

    public void setOutInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.interceptorHolder.setOutInterceptors(interceptors);
    }

    public void setOutFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.interceptorHolder.setOutFaultInterceptors(interceptors);
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        if (this.properties == null) {
            this.properties = properties;
        } else {
            this.properties.putAll(properties);
        }
    }

    public void setBindingStyle(BindingStyle bindingStyle) {
        this.bindingStyle = bindingStyle;
    }

    public String getBeanId() {
        return this.beanId;
    }

    public void setBeanId(String beanId) {
        this.beanId = beanId;
    }

    protected void doStart() throws Exception {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new CxfRsHeaderFilterStrategy();
        }
        if (this.bindingStyle == BindingStyle.Custom && this.binding == null) {
            throw new IllegalArgumentException("Custom binding style selected, but no binding was supplied");
        }
        if (this.binding != null) {
            this.bindingStyle = BindingStyle.Custom;
        }
        if (this.bindingStyle == BindingStyle.SimpleConsumer) {
            this.binding = new SimpleCxfRsBinding();
        } else if (this.bindingStyle != BindingStyle.Custom) {
            this.binding = new DefaultCxfRsBinding();
        }
        if (this.binding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.binding).setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
        if (this.providersRef != null) {
            String[] names;
            for (String name : names = this.providersRef.split(",")) {
                Object provider = EndpointHelper.resolveReferenceParameter((CamelContext)this.getCamelContext(), (String)name, Object.class, (boolean)true);
                this.setProvider(provider);
            }
        }
    }

    protected void doStop() throws Exception {
    }

    public long getContinuationTimeout() {
        return this.continuationTimeout;
    }

    public void setContinuationTimeout(long continuationTimeout) {
        this.continuationTimeout = continuationTimeout;
    }

    public boolean isPerformInvocation() {
        return this.performInvocation;
    }

    public void setPerformInvocation(boolean performInvocation) {
        this.performInvocation = performInvocation;
    }

    public boolean isPropagateContexts() {
        return this.propagateContexts;
    }

    public void setPropagateContexts(boolean propagateContexts) {
        this.propagateContexts = propagateContexts;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public CxfRsEndpointConfigurer getCxfRsEndpointConfigurer() {
        return this.cxfRsEndpointConfigurer;
    }

    public void setCxfRsEndpointConfigurer(CxfRsEndpointConfigurer configurer) {
        this.cxfRsEndpointConfigurer = configurer;
    }

    public CookieHandler getCookieHandler() {
        return this.cookieHandler;
    }

    public void setCookieHandler(CookieHandler cookieHandler) {
        this.cookieHandler = cookieHandler;
    }

    private static class InterceptorHolder
    extends AbstractBasicInterceptorProvider {
        private InterceptorHolder() {
        }
    }
}

