/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.camel.component.dataset.ListDataSet;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.Scanner;

public class FileDataSet
extends ListDataSet {
    private File sourceFile;
    private String delimiter;
    private List<Object> defaultBodies;

    public FileDataSet(String sourceFileName) throws IOException {
        this(new File(sourceFileName));
    }

    public FileDataSet(File sourceFile) throws IOException {
        this(sourceFile, null);
    }

    public FileDataSet(String sourceFileName, String delimiter) throws IOException {
        this(new File(sourceFileName), delimiter);
    }

    public FileDataSet(File sourceFile, String delimiter) throws IOException {
        this.setSourceFile(sourceFile, delimiter);
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File sourceFile) throws IOException {
        this.sourceFile = sourceFile;
        this.readSourceFile();
    }

    public void setSourceFile(File sourceFile, String delimiter) throws IOException {
        this.sourceFile = sourceFile;
        this.delimiter = delimiter;
        this.readSourceFile();
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    private void readSourceFile() throws IOException {
        LinkedList<Object> bodies = new LinkedList<Object>();
        if (this.delimiter != null) {
            try (Scanner scanner = new Scanner(this.sourceFile, null, this.delimiter);){
                while (scanner.hasNext()) {
                    String nextPayload = scanner.next();
                    if (nextPayload == null || nextPayload.length() <= 0) continue;
                    bodies.add(nextPayload);
                }
            }
        } else {
            String data = IOHelper.loadText((InputStream)new FileInputStream(this.sourceFile));
            bodies.add(data);
        }
        this.setDefaultBodies(bodies);
    }
}

