/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.datasonnet;

import com.datasonnet.Mapper;
import com.datasonnet.MapperBuilder;
import com.datasonnet.document.DefaultDocument;
import com.datasonnet.document.Document;
import com.datasonnet.document.MediaType;
import com.datasonnet.document.MediaTypes;
import com.datasonnet.spi.Library;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.RuntimeExpressionException;
import org.apache.camel.language.datasonnet.CML;
import org.apache.camel.language.datasonnet.DatasonnetLanguage;
import org.apache.camel.spi.ExpressionResultTypeAware;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.MessageHelper;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasonnetExpression
extends ExpressionAdapter
implements ExpressionResultTypeAware {
    private static final Logger LOG = LoggerFactory.getLogger(DatasonnetExpression.class);
    private String expression;
    private Expression metaExpression;
    private MediaType bodyMediaType;
    private MediaType outputMediaType;
    private Class<?> resultType;
    private Collection<String> libraryPaths;

    public DatasonnetExpression(String expression) {
        this.expression = expression;
    }

    public DatasonnetExpression(Expression expression) {
        this.metaExpression = expression;
    }

    public static DatasonnetExpression builder(String expression) {
        DatasonnetExpression answer = new DatasonnetExpression(expression);
        return answer;
    }

    public static DatasonnetExpression builder(Expression expression) {
        DatasonnetExpression answer = new DatasonnetExpression(expression);
        return answer;
    }

    public static DatasonnetExpression builder(String expression, Class<?> resultType) {
        DatasonnetExpression answer = new DatasonnetExpression(expression);
        answer.setResultType(resultType);
        return answer;
    }

    public static DatasonnetExpression builder(Expression expression, Class<?> resultType) {
        DatasonnetExpression answer = new DatasonnetExpression(expression);
        answer.setResultType(resultType);
        return answer;
    }

    public boolean matches(Exchange exchange) {
        this.outputMediaType = MediaTypes.APPLICATION_JAVA;
        return this.evaluate(exchange, Boolean.class);
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        try {
            if (this.metaExpression != null) {
                this.expression = (String)this.metaExpression.evaluate(exchange, String.class);
            }
            Objects.requireNonNull(this.expression, "String expression property must be set!");
            Document<?> result = this.doEvaluate(exchange);
            if (!type.equals(Object.class)) {
                Object object = ExchangeHelper.convertToType((Exchange)exchange, type, (Object)result.getContent());
                return (T)object;
            }
            if (this.resultType == null || this.resultType.equals(Document.class)) {
                Document<?> document = result;
                return (T)document;
            }
            Object object = result.getContent();
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeExpressionException("Unable to evaluate DataSonnet expression: " + this.expression, (Throwable)e);
        }
        finally {
            CML.getInstance().getExchange().remove();
        }
    }

    private Document<?> doEvaluate(Exchange exchange) {
        String typeHeader;
        if (this.bodyMediaType == null && (typeHeader = (String)exchange.getProperty("CamelDatasonnetBodyMediaType", exchange.getIn().getHeader("Content-Type"), String.class)) != null) {
            this.bodyMediaType = MediaType.valueOf((String)typeHeader);
        }
        Object body = exchange.getMessage().getBody() instanceof Document ? (Document)exchange.getMessage().getBody() : (MediaTypes.APPLICATION_JAVA.equalsTypeAndSubtype(this.bodyMediaType) ? new DefaultDocument(exchange.getMessage().getBody()) : new DefaultDocument((Object)MessageHelper.extractBodyAsString((Message)exchange.getMessage()), this.bodyMediaType));
        Map<String, Document> inputs = Collections.singletonMap("body", body);
        DatasonnetLanguage language = (DatasonnetLanguage)exchange.getContext().resolveLanguage("datasonnet");
        Mapper mapper = language.computeIfMiss(this.expression, () -> new MapperBuilder(this.expression).withInputNames(inputs.keySet()).withImports(this.resolveImports(language)).withLibrary((Library)CML.getInstance()).withDefaultOutput(MediaTypes.APPLICATION_JAVA).build());
        CML.getInstance().getExchange().set(exchange);
        if (this.outputMediaType == null) {
            String typeHeader2 = (String)exchange.getProperty("CamelDatasonnetOutputMediaType", exchange.getIn().getHeader("CamelDatasonnetOutputMediaType"), String.class);
            this.outputMediaType = typeHeader2 != null ? MediaType.valueOf((String)typeHeader2) : MediaTypes.ANY;
        }
        if (this.resultType == null || this.resultType.equals(Document.class)) {
            return mapper.transform(body, inputs, this.outputMediaType, Object.class);
        }
        return mapper.transform(body, inputs, this.outputMediaType, this.resultType);
    }

    private Map<String, String> resolveImports(DatasonnetLanguage language) {
        if (this.libraryPaths == null) {
            return language.getClasspathImports();
        }
        final HashMap<String, String> answer = new HashMap<String, String>();
        LOG.debug("Explicit library path is: {}", this.libraryPaths);
        for (String nextPath : this.libraryPaths) {
            final File nextLibDir = new File(nextPath);
            if (!nextLibDir.isDirectory()) continue;
            try {
                Files.walkFileTree(nextLibDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        File f = file.toFile();
                        if (!f.isDirectory() && f.getName().toLowerCase().endsWith(".libsonnet")) {
                            String content = IOUtils.toString((URI)file.toUri(), (Charset)Charset.defaultCharset());
                            Path relative = nextLibDir.toPath().relativize(file);
                            LOG.debug("Loading DataSonnet library: {}", (Object)relative);
                            answer.put(relative.toString(), content);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                LOG.warn("Unable to load DataSonnet library from: " + nextPath, (Throwable)e);
            }
        }
        return answer;
    }

    public MediaType getBodyMediaType() {
        return this.bodyMediaType;
    }

    public void setBodyMediaType(MediaType inputMimeType) {
        this.bodyMediaType = inputMimeType;
    }

    public MediaType getOutputMediaType() {
        return this.outputMediaType;
    }

    public void setOutputMediaType(MediaType outputMimeType) {
        this.outputMediaType = outputMimeType;
    }

    public Collection<String> getLibraryPaths() {
        return this.libraryPaths;
    }

    public void setLibraryPaths(Collection<String> libraryPaths) {
        this.libraryPaths = libraryPaths;
    }

    public String getExpressionText() {
        return this.expression;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> targetType) {
        this.resultType = targetType;
    }

    public DatasonnetExpression bodyMediaType(MediaType bodyMediaType) {
        this.setBodyMediaType(bodyMediaType);
        return this;
    }

    public DatasonnetExpression outputMediaType(MediaType outputMediaType) {
        this.setOutputMediaType(outputMediaType);
        return this;
    }

    public String toString() {
        return "datasonnet: " + this.expression;
    }
}

