/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium.configuration;

import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.MongoDbConnector;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class MongoDbConnectorEmbeddedDebeziumConfiguration
extends EmbeddedDebeziumConfiguration {
    private static final String LABEL_NAME = "consumer,mongodb";
    @UriParam(label="consumer,mongodb")
    @Metadata(required=true)
    private String mongodbPassword;
    @UriParam(label="consumer,mongodb", defaultValue="0")
    private int queryFetchSize = 0;
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean mongodbSslEnabled = false;
    @UriParam(label="consumer,mongodb", javaType="java.time.Duration")
    private int cursorMaxAwaitTimeMs;
    @UriParam(label="consumer,mongodb", defaultValue="true")
    private boolean mongodbMembersAutoDiscover = true;
    @UriParam(label="consumer,mongodb")
    private String fieldRenames;
    @UriParam(label="consumer,mongodb", defaultValue="30s", javaType="java.time.Duration")
    private int mongodbServerSelectionTimeoutMs = 30000;
    @UriParam(label="consumer,mongodb", defaultValue="500ms", javaType="java.time.Duration")
    private long pollIntervalMs = 500L;
    @UriParam(label="consumer,mongodb")
    private String signalDataCollection;
    @UriParam(label="consumer,mongodb")
    private String converters;
    @UriParam(label="consumer,mongodb", defaultValue="__debezium-heartbeat")
    private String heartbeatTopicsPrefix = "__debezium-heartbeat";
    @UriParam(label="consumer,mongodb", defaultValue="10s", javaType="java.time.Duration")
    private int mongodbConnectTimeoutMs = 10000;
    @UriParam(label="consumer,mongodb")
    private String mongodbHosts;
    @UriParam(label="consumer,mongodb")
    private int snapshotFetchSize;
    @UriParam(label="consumer,mongodb", defaultValue="30s", javaType="java.time.Duration")
    private long mongodbPollIntervalMs = 30000L;
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean sanitizeFieldNames = false;
    @UriParam(label="consumer,mongodb")
    private String mongodbUser;
    @UriParam(label="consumer,mongodb", defaultValue="v2")
    private String sourceStructVersion = "v2";
    @UriParam(label="consumer,mongodb", defaultValue="0ms", javaType="java.time.Duration")
    private int heartbeatIntervalMs = 0;
    @UriParam(label="consumer,mongodb")
    private String snapshotCollectionFilterOverrides;
    @UriParam(label="consumer,mongodb")
    private String fieldExcludeList;
    @UriParam(label="consumer,mongodb")
    private String databaseExcludeList;
    @UriParam(label="consumer,mongodb", defaultValue="2048")
    private int maxBatchSize = 2048;
    @UriParam(label="consumer,mongodb")
    private String skippedOperations;
    @UriParam(label="consumer,mongodb", defaultValue="initial")
    private String snapshotMode = "initial";
    @UriParam(label="consumer,mongodb", defaultValue="8192")
    private int maxQueueSize = 8192;
    @UriParam(label="consumer,mongodb")
    private String collectionIncludeList;
    @UriParam(label="consumer,mongodb", defaultValue="10s", javaType="java.time.Duration")
    private long retriableRestartConnectorWaitMs = 10000L;
    @UriParam(label="consumer,mongodb", defaultValue="change_streams_update_full")
    private String captureMode = "change_streams_update_full";
    @UriParam(label="consumer,mongodb", defaultValue="0ms", javaType="java.time.Duration")
    private long snapshotDelayMs = 0L;
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean provideTransactionMetadata = false;
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean tombstonesOnDelete = false;
    @UriParam(label="consumer,mongodb", defaultValue="admin")
    private String mongodbAuthsource = "admin";
    @UriParam(label="consumer,mongodb", defaultValue="1s", javaType="java.time.Duration")
    private long connectBackoffInitialDelayMs = 1000L;
    @UriParam(label="consumer,mongodb")
    private String collectionExcludeList;
    @UriParam(label="consumer,mongodb")
    private String snapshotIncludeCollectionList;
    @UriParam(label="consumer,mongodb")
    private String databaseHistoryFileFilename;
    @UriParam(label="consumer,mongodb", defaultValue="16")
    private int connectMaxAttempts = 16;
    @UriParam(label="consumer,mongodb", defaultValue="0")
    private long maxQueueSizeInBytes = 0L;
    @UriParam(label="consumer,mongodb", defaultValue="${database.server.name}.transaction")
    private String transactionTopic = "${database.server.name}.transaction";
    @UriParam(label="consumer,mongodb", defaultValue="0ms", javaType="java.time.Duration")
    private int mongodbSocketTimeoutMs = 0;
    @UriParam(label="consumer,mongodb", defaultValue="fail")
    private String eventProcessingFailureHandlingMode = "fail";
    @UriParam(label="consumer,mongodb")
    @Metadata(required=true)
    private String mongodbName;
    @UriParam(label="consumer,mongodb", defaultValue="1")
    private int snapshotMaxThreads = 1;
    @UriParam(label="consumer,mongodb", defaultValue="2m", javaType="java.time.Duration")
    private long connectBackoffMaxDelayMs = 120000L;
    @UriParam(label="consumer,mongodb", defaultValue="avro")
    private String schemaNameAdjustmentMode = "avro";
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean mongodbSslInvalidHostnameAllowed = false;
    @UriParam(label="consumer,mongodb")
    private String databaseIncludeList;

    public void setMongodbPassword(String mongodbPassword) {
        this.mongodbPassword = mongodbPassword;
    }

    public String getMongodbPassword() {
        return this.mongodbPassword;
    }

    public void setQueryFetchSize(int queryFetchSize) {
        this.queryFetchSize = queryFetchSize;
    }

    public int getQueryFetchSize() {
        return this.queryFetchSize;
    }

    public void setMongodbSslEnabled(boolean mongodbSslEnabled) {
        this.mongodbSslEnabled = mongodbSslEnabled;
    }

    public boolean isMongodbSslEnabled() {
        return this.mongodbSslEnabled;
    }

    public void setCursorMaxAwaitTimeMs(int cursorMaxAwaitTimeMs) {
        this.cursorMaxAwaitTimeMs = cursorMaxAwaitTimeMs;
    }

    public int getCursorMaxAwaitTimeMs() {
        return this.cursorMaxAwaitTimeMs;
    }

    public void setMongodbMembersAutoDiscover(boolean mongodbMembersAutoDiscover) {
        this.mongodbMembersAutoDiscover = mongodbMembersAutoDiscover;
    }

    public boolean isMongodbMembersAutoDiscover() {
        return this.mongodbMembersAutoDiscover;
    }

    public void setFieldRenames(String fieldRenames) {
        this.fieldRenames = fieldRenames;
    }

    public String getFieldRenames() {
        return this.fieldRenames;
    }

    public void setMongodbServerSelectionTimeoutMs(int mongodbServerSelectionTimeoutMs) {
        this.mongodbServerSelectionTimeoutMs = mongodbServerSelectionTimeoutMs;
    }

    public int getMongodbServerSelectionTimeoutMs() {
        return this.mongodbServerSelectionTimeoutMs;
    }

    public void setPollIntervalMs(long pollIntervalMs) {
        this.pollIntervalMs = pollIntervalMs;
    }

    public long getPollIntervalMs() {
        return this.pollIntervalMs;
    }

    public void setSignalDataCollection(String signalDataCollection) {
        this.signalDataCollection = signalDataCollection;
    }

    public String getSignalDataCollection() {
        return this.signalDataCollection;
    }

    public void setConverters(String converters) {
        this.converters = converters;
    }

    public String getConverters() {
        return this.converters;
    }

    public void setHeartbeatTopicsPrefix(String heartbeatTopicsPrefix) {
        this.heartbeatTopicsPrefix = heartbeatTopicsPrefix;
    }

    public String getHeartbeatTopicsPrefix() {
        return this.heartbeatTopicsPrefix;
    }

    public void setMongodbConnectTimeoutMs(int mongodbConnectTimeoutMs) {
        this.mongodbConnectTimeoutMs = mongodbConnectTimeoutMs;
    }

    public int getMongodbConnectTimeoutMs() {
        return this.mongodbConnectTimeoutMs;
    }

    public void setMongodbHosts(String mongodbHosts) {
        this.mongodbHosts = mongodbHosts;
    }

    public String getMongodbHosts() {
        return this.mongodbHosts;
    }

    public void setSnapshotFetchSize(int snapshotFetchSize) {
        this.snapshotFetchSize = snapshotFetchSize;
    }

    public int getSnapshotFetchSize() {
        return this.snapshotFetchSize;
    }

    public void setMongodbPollIntervalMs(long mongodbPollIntervalMs) {
        this.mongodbPollIntervalMs = mongodbPollIntervalMs;
    }

    public long getMongodbPollIntervalMs() {
        return this.mongodbPollIntervalMs;
    }

    public void setSanitizeFieldNames(boolean sanitizeFieldNames) {
        this.sanitizeFieldNames = sanitizeFieldNames;
    }

    public boolean isSanitizeFieldNames() {
        return this.sanitizeFieldNames;
    }

    public void setMongodbUser(String mongodbUser) {
        this.mongodbUser = mongodbUser;
    }

    public String getMongodbUser() {
        return this.mongodbUser;
    }

    public void setSourceStructVersion(String sourceStructVersion) {
        this.sourceStructVersion = sourceStructVersion;
    }

    public String getSourceStructVersion() {
        return this.sourceStructVersion;
    }

    public void setHeartbeatIntervalMs(int heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public int getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setSnapshotCollectionFilterOverrides(String snapshotCollectionFilterOverrides) {
        this.snapshotCollectionFilterOverrides = snapshotCollectionFilterOverrides;
    }

    public String getSnapshotCollectionFilterOverrides() {
        return this.snapshotCollectionFilterOverrides;
    }

    public void setFieldExcludeList(String fieldExcludeList) {
        this.fieldExcludeList = fieldExcludeList;
    }

    public String getFieldExcludeList() {
        return this.fieldExcludeList;
    }

    public void setDatabaseExcludeList(String databaseExcludeList) {
        this.databaseExcludeList = databaseExcludeList;
    }

    public String getDatabaseExcludeList() {
        return this.databaseExcludeList;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setSkippedOperations(String skippedOperations) {
        this.skippedOperations = skippedOperations;
    }

    public String getSkippedOperations() {
        return this.skippedOperations;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setCollectionIncludeList(String collectionIncludeList) {
        this.collectionIncludeList = collectionIncludeList;
    }

    public String getCollectionIncludeList() {
        return this.collectionIncludeList;
    }

    public void setRetriableRestartConnectorWaitMs(long retriableRestartConnectorWaitMs) {
        this.retriableRestartConnectorWaitMs = retriableRestartConnectorWaitMs;
    }

    public long getRetriableRestartConnectorWaitMs() {
        return this.retriableRestartConnectorWaitMs;
    }

    public void setCaptureMode(String captureMode) {
        this.captureMode = captureMode;
    }

    public String getCaptureMode() {
        return this.captureMode;
    }

    public void setSnapshotDelayMs(long snapshotDelayMs) {
        this.snapshotDelayMs = snapshotDelayMs;
    }

    public long getSnapshotDelayMs() {
        return this.snapshotDelayMs;
    }

    public void setProvideTransactionMetadata(boolean provideTransactionMetadata) {
        this.provideTransactionMetadata = provideTransactionMetadata;
    }

    public boolean isProvideTransactionMetadata() {
        return this.provideTransactionMetadata;
    }

    public void setTombstonesOnDelete(boolean tombstonesOnDelete) {
        this.tombstonesOnDelete = tombstonesOnDelete;
    }

    public boolean isTombstonesOnDelete() {
        return this.tombstonesOnDelete;
    }

    public void setMongodbAuthsource(String mongodbAuthsource) {
        this.mongodbAuthsource = mongodbAuthsource;
    }

    public String getMongodbAuthsource() {
        return this.mongodbAuthsource;
    }

    public void setConnectBackoffInitialDelayMs(long connectBackoffInitialDelayMs) {
        this.connectBackoffInitialDelayMs = connectBackoffInitialDelayMs;
    }

    public long getConnectBackoffInitialDelayMs() {
        return this.connectBackoffInitialDelayMs;
    }

    public void setCollectionExcludeList(String collectionExcludeList) {
        this.collectionExcludeList = collectionExcludeList;
    }

    public String getCollectionExcludeList() {
        return this.collectionExcludeList;
    }

    public void setSnapshotIncludeCollectionList(String snapshotIncludeCollectionList) {
        this.snapshotIncludeCollectionList = snapshotIncludeCollectionList;
    }

    public String getSnapshotIncludeCollectionList() {
        return this.snapshotIncludeCollectionList;
    }

    public void setDatabaseHistoryFileFilename(String databaseHistoryFileFilename) {
        this.databaseHistoryFileFilename = databaseHistoryFileFilename;
    }

    public String getDatabaseHistoryFileFilename() {
        return this.databaseHistoryFileFilename;
    }

    public void setConnectMaxAttempts(int connectMaxAttempts) {
        this.connectMaxAttempts = connectMaxAttempts;
    }

    public int getConnectMaxAttempts() {
        return this.connectMaxAttempts;
    }

    public void setMaxQueueSizeInBytes(long maxQueueSizeInBytes) {
        this.maxQueueSizeInBytes = maxQueueSizeInBytes;
    }

    public long getMaxQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public void setTransactionTopic(String transactionTopic) {
        this.transactionTopic = transactionTopic;
    }

    public String getTransactionTopic() {
        return this.transactionTopic;
    }

    public void setMongodbSocketTimeoutMs(int mongodbSocketTimeoutMs) {
        this.mongodbSocketTimeoutMs = mongodbSocketTimeoutMs;
    }

    public int getMongodbSocketTimeoutMs() {
        return this.mongodbSocketTimeoutMs;
    }

    public void setEventProcessingFailureHandlingMode(String eventProcessingFailureHandlingMode) {
        this.eventProcessingFailureHandlingMode = eventProcessingFailureHandlingMode;
    }

    public String getEventProcessingFailureHandlingMode() {
        return this.eventProcessingFailureHandlingMode;
    }

    public void setMongodbName(String mongodbName) {
        this.mongodbName = mongodbName;
    }

    public String getMongodbName() {
        return this.mongodbName;
    }

    public void setSnapshotMaxThreads(int snapshotMaxThreads) {
        this.snapshotMaxThreads = snapshotMaxThreads;
    }

    public int getSnapshotMaxThreads() {
        return this.snapshotMaxThreads;
    }

    public void setConnectBackoffMaxDelayMs(long connectBackoffMaxDelayMs) {
        this.connectBackoffMaxDelayMs = connectBackoffMaxDelayMs;
    }

    public long getConnectBackoffMaxDelayMs() {
        return this.connectBackoffMaxDelayMs;
    }

    public void setSchemaNameAdjustmentMode(String schemaNameAdjustmentMode) {
        this.schemaNameAdjustmentMode = schemaNameAdjustmentMode;
    }

    public String getSchemaNameAdjustmentMode() {
        return this.schemaNameAdjustmentMode;
    }

    public void setMongodbSslInvalidHostnameAllowed(boolean mongodbSslInvalidHostnameAllowed) {
        this.mongodbSslInvalidHostnameAllowed = mongodbSslInvalidHostnameAllowed;
    }

    public boolean isMongodbSslInvalidHostnameAllowed() {
        return this.mongodbSslInvalidHostnameAllowed;
    }

    public void setDatabaseIncludeList(String databaseIncludeList) {
        this.databaseIncludeList = databaseIncludeList;
    }

    public String getDatabaseIncludeList() {
        return this.databaseIncludeList;
    }

    protected Configuration createConnectorConfiguration() {
        Configuration.Builder configBuilder = Configuration.create();
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.password", (Object)this.mongodbPassword);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"query.fetch.size", (Object)this.queryFetchSize);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.ssl.enabled", (Object)this.mongodbSslEnabled);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"cursor.max.await.time.ms", (Object)this.cursorMaxAwaitTimeMs);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.members.auto.discover", (Object)this.mongodbMembersAutoDiscover);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"field.renames", (Object)this.fieldRenames);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.server.selection.timeout.ms", (Object)this.mongodbServerSelectionTimeoutMs);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"poll.interval.ms", (Object)this.pollIntervalMs);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"signal.data.collection", (Object)this.signalDataCollection);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"converters", (Object)this.converters);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"heartbeat.topics.prefix", (Object)this.heartbeatTopicsPrefix);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.connect.timeout.ms", (Object)this.mongodbConnectTimeoutMs);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.hosts", (Object)this.mongodbHosts);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.fetch.size", (Object)this.snapshotFetchSize);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.poll.interval.ms", (Object)this.mongodbPollIntervalMs);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"sanitize.field.names", (Object)this.sanitizeFieldNames);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.user", (Object)this.mongodbUser);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"source.struct.version", (Object)this.sourceStructVersion);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"heartbeat.interval.ms", (Object)this.heartbeatIntervalMs);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.collection.filter.overrides", (Object)this.snapshotCollectionFilterOverrides);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"field.exclude.list", (Object)this.fieldExcludeList);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.exclude.list", (Object)this.databaseExcludeList);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"max.batch.size", (Object)this.maxBatchSize);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"skipped.operations", (Object)this.skippedOperations);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.mode", (Object)this.snapshotMode);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"max.queue.size", (Object)this.maxQueueSize);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"collection.include.list", (Object)this.collectionIncludeList);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"retriable.restart.connector.wait.ms", (Object)this.retriableRestartConnectorWaitMs);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"capture.mode", (Object)this.captureMode);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.delay.ms", (Object)this.snapshotDelayMs);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"provide.transaction.metadata", (Object)this.provideTransactionMetadata);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"tombstones.on.delete", (Object)this.tombstonesOnDelete);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.authsource", (Object)this.mongodbAuthsource);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"connect.backoff.initial.delay.ms", (Object)this.connectBackoffInitialDelayMs);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"collection.exclude.list", (Object)this.collectionExcludeList);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.include.collection.list", (Object)this.snapshotIncludeCollectionList);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.file.filename", (Object)this.databaseHistoryFileFilename);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"connect.max.attempts", (Object)this.connectMaxAttempts);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"max.queue.size.in.bytes", (Object)this.maxQueueSizeInBytes);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"transaction.topic", (Object)this.transactionTopic);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.socket.timeout.ms", (Object)this.mongodbSocketTimeoutMs);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"event.processing.failure.handling.mode", (Object)this.eventProcessingFailureHandlingMode);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.name", (Object)this.mongodbName);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.max.threads", (Object)this.snapshotMaxThreads);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"connect.backoff.max.delay.ms", (Object)this.connectBackoffMaxDelayMs);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"schema.name.adjustment.mode", (Object)this.schemaNameAdjustmentMode);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"mongodb.ssl.invalid.hostname.allowed", (Object)this.mongodbSslInvalidHostnameAllowed);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.include.list", (Object)this.databaseIncludeList);
        return configBuilder.build();
    }

    protected Class configureConnectorClass() {
        return MongoDbConnector.class;
    }

    protected ConfigurationValidation validateConnectorConfiguration() {
        if (MongoDbConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet((Object)this.mongodbPassword)) {
            return ConfigurationValidation.notValid((String)"Required field 'mongodbPassword' must be set.");
        }
        if (MongoDbConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet((Object)this.mongodbName)) {
            return ConfigurationValidation.notValid((String)"Required field 'mongodbName' must be set.");
        }
        return ConfigurationValidation.valid();
    }

    public String getConnectorDatabaseType() {
        return "mongodb";
    }
}

