/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium.configuration;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnector;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class OracleConnectorEmbeddedDebeziumConfiguration
extends EmbeddedDebeziumConfiguration {
    private static final String LABEL_NAME = "consumer,oracle";
    @UriParam(label="consumer,oracle", defaultValue="shared")
    private String snapshotLockingMode = "shared";
    @UriParam(label="consumer,oracle", defaultValue="false")
    private boolean logMiningBufferDropOnStop = false;
    @UriParam(label="consumer,oracle")
    private String messageKeyColumns;
    @UriParam(label="consumer,oracle")
    private String logMiningArchiveDestinationName;
    @UriParam(label="consumer,oracle")
    private String columnBlacklist;
    @UriParam(label="consumer,oracle", defaultValue="true")
    private boolean includeSchemaChanges = true;
    @UriParam(label="consumer,oracle")
    private String signalDataCollection;
    @UriParam(label="consumer,oracle")
    private String converters;
    @UriParam(label="consumer,oracle")
    private int snapshotFetchSize;
    @UriParam(label="consumer,oracle", defaultValue="10s", javaType="java.time.Duration")
    private long snapshotLockTimeoutMs = 10000L;
    @UriParam(label="consumer,oracle", defaultValue="3s", javaType="java.time.Duration")
    private long databaseHistoryKafkaQueryTimeoutMs = 3000L;
    @UriParam(label="consumer,oracle", defaultValue="1000000")
    private long logMiningScnGapDetectionGapSizeMin = 1000000L;
    @UriParam(label="consumer,oracle")
    private String databaseDbname;
    @UriParam(label="consumer,oracle", defaultValue="1s", javaType="java.time.Duration")
    private long logMiningSleepTimeDefaultMs = 1000L;
    @UriParam(label="consumer,oracle")
    private String snapshotSelectStatementOverrides;
    @UriParam(label="consumer,oracle", defaultValue="v2")
    private String sourceStructVersion = "v2";
    @UriParam(label="consumer,oracle")
    private String columnWhitelist;
    @UriParam(label="consumer,oracle", defaultValue="10s", javaType="java.time.Duration")
    private long logMiningArchiveLogOnlyScnPollIntervalMs = 10000L;
    @UriParam(label="consumer,oracle")
    private String tableExcludeList;
    @UriParam(label="consumer,oracle", defaultValue="2048")
    private int maxBatchSize = 2048;
    @UriParam(label="consumer,oracle")
    private String logMiningBufferInfinispanCacheTransactions;
    @UriParam(label="consumer,oracle", defaultValue="initial")
    private String snapshotMode = "initial";
    @UriParam(label="consumer,oracle")
    private String databaseHistoryKafkaTopic;
    @UriParam(label="consumer,oracle", defaultValue="10s", javaType="java.time.Duration")
    private long retriableRestartConnectorWaitMs = 10000L;
    @UriParam(label="consumer,oracle", defaultValue="0ms", javaType="java.time.Duration")
    private long snapshotDelayMs = 0L;
    @UriParam(label="consumer,oracle", defaultValue="redo_log_catalog")
    private String logMiningStrategy = "redo_log_catalog";
    @UriParam(label="consumer,oracle")
    private String tableWhitelist;
    @UriParam(label="consumer,oracle", defaultValue="false")
    private boolean tombstonesOnDelete = false;
    @UriParam(label="consumer,oracle", defaultValue="precise")
    private String decimalHandlingMode = "precise";
    @UriParam(label="consumer,oracle", defaultValue="bytes")
    private String binaryHandlingMode = "bytes";
    @UriParam(label="consumer,oracle")
    private String databaseOutServerName;
    @UriParam(label="consumer,oracle")
    private String snapshotIncludeCollectionList;
    @UriParam(label="consumer,oracle")
    private String databaseHistoryFileFilename;
    @UriParam(label="consumer,oracle")
    private String databasePdbName;
    @UriParam(label="consumer,oracle", defaultValue="LogMiner")
    private String databaseConnectionAdapter = "LogMiner";
    @UriParam(label="consumer,oracle", defaultValue="memory")
    private String logMiningBufferType = "memory";
    @UriParam(label="consumer,oracle", defaultValue="fail")
    private String eventProcessingFailureHandlingMode = "fail";
    @UriParam(label="consumer,oracle", defaultValue="1")
    private int snapshotMaxThreads = 1;
    @UriParam(label="consumer,oracle", defaultValue="avro")
    private String schemaNameAdjustmentMode = "avro";
    @UriParam(label="consumer,oracle", defaultValue="20000")
    private long logMiningBatchSizeDefault = 20000L;
    @UriParam(label="consumer,oracle")
    private String tableIncludeList;
    @UriParam(label="consumer,oracle", defaultValue="0")
    private int queryFetchSize = 0;
    @UriParam(label="consumer,oracle", defaultValue="0ms", javaType="java.time.Duration")
    private long logMiningSleepTimeMinMs = 0L;
    @UriParam(label="consumer,oracle")
    private String tableBlacklist;
    @UriParam(label="consumer,oracle", defaultValue="__debezium_unavailable_value")
    private String unavailableValuePlaceholder = "__debezium_unavailable_value";
    @UriParam(label="consumer,oracle")
    private String heartbeatActionQuery;
    @UriParam(label="consumer,oracle", defaultValue="500ms", javaType="java.time.Duration")
    private long pollIntervalMs = 500L;
    @UriParam(label="consumer,oracle", defaultValue="100ms", javaType="java.time.Duration")
    private int databaseHistoryKafkaRecoveryPollIntervalMs = 100;
    @UriParam(label="consumer,oracle", defaultValue="false")
    private boolean lobEnabled = false;
    @UriParam(label="consumer,oracle", defaultValue="numeric")
    private String intervalHandlingMode = "numeric";
    @UriParam(label="consumer,oracle", defaultValue="false")
    private boolean databaseHistoryStoreOnlyCapturedTablesDdl = false;
    @UriParam(label="consumer,oracle", defaultValue="__debezium-heartbeat")
    private String heartbeatTopicsPrefix = "__debezium-heartbeat";
    @UriParam(label="consumer,oracle", defaultValue="false")
    private boolean logMiningArchiveLogOnlyMode = false;
    @UriParam(label="consumer,oracle")
    private String logMiningBufferInfinispanCacheSchemaChanges;
    @UriParam(label="consumer,oracle", defaultValue="3s", javaType="java.time.Duration")
    private long logMiningSleepTimeMaxMs = 3000L;
    @UriParam(label="consumer,oracle")
    private String databaseUser;
    @UriParam(label="consumer,oracle")
    private String datatypePropagateSourceType;
    @UriParam(label="consumer,oracle", defaultValue="false")
    private boolean sanitizeFieldNames = false;
    @UriParam(label="consumer,oracle")
    private String databaseHistoryKafkaBootstrapServers;
    @UriParam(label="consumer,oracle", defaultValue="0ms", javaType="java.time.Duration")
    private int heartbeatIntervalMs = 0;
    @UriParam(label="consumer,oracle")
    private String columnIncludeList;
    @UriParam(label="consumer,oracle")
    private String logMiningUsernameExcludeList;
    @UriParam(label="consumer,oracle")
    private String columnPropagateSourceType;
    @UriParam(label="consumer,oracle")
    private String logMiningBufferInfinispanCacheProcessedTransactions;
    @UriParam(label="consumer,oracle")
    @Metadata(required=true)
    private String databasePassword;
    @UriParam(label="consumer,oracle")
    private String logMiningBufferInfinispanCacheEvents;
    @UriParam(label="consumer,oracle", defaultValue="false")
    private boolean databaseHistoryStoreOnlyMonitoredTablesDdl = false;
    @UriParam(label="consumer,oracle")
    private String skippedOperations;
    @UriParam(label="consumer,oracle", defaultValue="20s", javaType="java.time.Duration")
    private long logMiningScnGapDetectionTimeIntervalMaxMs = 20000L;
    @UriParam(label="consumer,oracle", defaultValue="io.debezium.relational.history.KafkaDatabaseHistory")
    private String databaseHistory = "io.debezium.relational.history.KafkaDatabaseHistory";
    @UriParam(label="consumer,oracle", defaultValue="8192")
    private int maxQueueSize = 8192;
    @UriParam(label="consumer,oracle")
    private String racNodes;
    @UriParam(label="consumer,oracle", defaultValue="100")
    private int databaseHistoryKafkaRecoveryAttempts = 100;
    @UriParam(label="consumer,oracle", defaultValue="false")
    private boolean provideTransactionMetadata = false;
    @UriParam(label="consumer,oracle", defaultValue="false")
    private boolean includeSchemaComments = false;
    @UriParam(label="consumer,oracle", defaultValue="false")
    private boolean databaseHistorySkipUnparseableDdl = false;
    @UriParam(label="consumer,oracle", defaultValue="0")
    private long logMiningArchiveLogHours = 0L;
    @UriParam(label="consumer,oracle", defaultValue="0")
    private long logMiningTransactionRetentionHours = 0L;
    @UriParam(label="consumer,oracle", defaultValue="100000")
    private long logMiningBatchSizeMax = 100000L;
    @UriParam(label="consumer,oracle", defaultValue="0")
    private long maxQueueSizeInBytes = 0L;
    @UriParam(label="consumer,oracle", defaultValue="${database.server.name}.transaction")
    private String transactionTopic = "${database.server.name}.transaction";
    @UriParam(label="consumer,oracle")
    private String databaseUrl;
    @UriParam(label="consumer,oracle", defaultValue="adaptive")
    private String timePrecisionMode = "adaptive";
    @UriParam(label="consumer,oracle")
    @Metadata(required=true)
    private String databaseServerName;
    @UriParam(label="consumer,oracle", defaultValue="1528")
    private int databasePort = 1528;
    @UriParam(label="consumer,oracle", defaultValue="200ms", javaType="java.time.Duration")
    private long logMiningSleepTimeIncrementMs = 200L;
    @UriParam(label="consumer,oracle")
    private String columnExcludeList;
    @UriParam(label="consumer,oracle", defaultValue="0ms", javaType="java.time.Duration")
    private long logMiningSessionMaxMs = 0L;
    @UriParam(label="consumer,oracle")
    private String databaseHostname;
    @UriParam(label="consumer,oracle", defaultValue="1000")
    private long logMiningBatchSizeMin = 1000L;
    @UriParam(label="consumer,oracle")
    private String snapshotEnhancePredicateScn;

    public void setSnapshotLockingMode(String snapshotLockingMode) {
        this.snapshotLockingMode = snapshotLockingMode;
    }

    public String getSnapshotLockingMode() {
        return this.snapshotLockingMode;
    }

    public void setLogMiningBufferDropOnStop(boolean logMiningBufferDropOnStop) {
        this.logMiningBufferDropOnStop = logMiningBufferDropOnStop;
    }

    public boolean isLogMiningBufferDropOnStop() {
        return this.logMiningBufferDropOnStop;
    }

    public void setMessageKeyColumns(String messageKeyColumns) {
        this.messageKeyColumns = messageKeyColumns;
    }

    public String getMessageKeyColumns() {
        return this.messageKeyColumns;
    }

    public void setLogMiningArchiveDestinationName(String logMiningArchiveDestinationName) {
        this.logMiningArchiveDestinationName = logMiningArchiveDestinationName;
    }

    public String getLogMiningArchiveDestinationName() {
        return this.logMiningArchiveDestinationName;
    }

    public void setColumnBlacklist(String columnBlacklist) {
        this.columnBlacklist = columnBlacklist;
    }

    public String getColumnBlacklist() {
        return this.columnBlacklist;
    }

    public void setIncludeSchemaChanges(boolean includeSchemaChanges) {
        this.includeSchemaChanges = includeSchemaChanges;
    }

    public boolean isIncludeSchemaChanges() {
        return this.includeSchemaChanges;
    }

    public void setSignalDataCollection(String signalDataCollection) {
        this.signalDataCollection = signalDataCollection;
    }

    public String getSignalDataCollection() {
        return this.signalDataCollection;
    }

    public void setConverters(String converters) {
        this.converters = converters;
    }

    public String getConverters() {
        return this.converters;
    }

    public void setSnapshotFetchSize(int snapshotFetchSize) {
        this.snapshotFetchSize = snapshotFetchSize;
    }

    public int getSnapshotFetchSize() {
        return this.snapshotFetchSize;
    }

    public void setSnapshotLockTimeoutMs(long snapshotLockTimeoutMs) {
        this.snapshotLockTimeoutMs = snapshotLockTimeoutMs;
    }

    public long getSnapshotLockTimeoutMs() {
        return this.snapshotLockTimeoutMs;
    }

    public void setDatabaseHistoryKafkaQueryTimeoutMs(long databaseHistoryKafkaQueryTimeoutMs) {
        this.databaseHistoryKafkaQueryTimeoutMs = databaseHistoryKafkaQueryTimeoutMs;
    }

    public long getDatabaseHistoryKafkaQueryTimeoutMs() {
        return this.databaseHistoryKafkaQueryTimeoutMs;
    }

    public void setLogMiningScnGapDetectionGapSizeMin(long logMiningScnGapDetectionGapSizeMin) {
        this.logMiningScnGapDetectionGapSizeMin = logMiningScnGapDetectionGapSizeMin;
    }

    public long getLogMiningScnGapDetectionGapSizeMin() {
        return this.logMiningScnGapDetectionGapSizeMin;
    }

    public void setDatabaseDbname(String databaseDbname) {
        this.databaseDbname = databaseDbname;
    }

    public String getDatabaseDbname() {
        return this.databaseDbname;
    }

    public void setLogMiningSleepTimeDefaultMs(long logMiningSleepTimeDefaultMs) {
        this.logMiningSleepTimeDefaultMs = logMiningSleepTimeDefaultMs;
    }

    public long getLogMiningSleepTimeDefaultMs() {
        return this.logMiningSleepTimeDefaultMs;
    }

    public void setSnapshotSelectStatementOverrides(String snapshotSelectStatementOverrides) {
        this.snapshotSelectStatementOverrides = snapshotSelectStatementOverrides;
    }

    public String getSnapshotSelectStatementOverrides() {
        return this.snapshotSelectStatementOverrides;
    }

    public void setSourceStructVersion(String sourceStructVersion) {
        this.sourceStructVersion = sourceStructVersion;
    }

    public String getSourceStructVersion() {
        return this.sourceStructVersion;
    }

    public void setColumnWhitelist(String columnWhitelist) {
        this.columnWhitelist = columnWhitelist;
    }

    public String getColumnWhitelist() {
        return this.columnWhitelist;
    }

    public void setLogMiningArchiveLogOnlyScnPollIntervalMs(long logMiningArchiveLogOnlyScnPollIntervalMs) {
        this.logMiningArchiveLogOnlyScnPollIntervalMs = logMiningArchiveLogOnlyScnPollIntervalMs;
    }

    public long getLogMiningArchiveLogOnlyScnPollIntervalMs() {
        return this.logMiningArchiveLogOnlyScnPollIntervalMs;
    }

    public void setTableExcludeList(String tableExcludeList) {
        this.tableExcludeList = tableExcludeList;
    }

    public String getTableExcludeList() {
        return this.tableExcludeList;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setLogMiningBufferInfinispanCacheTransactions(String logMiningBufferInfinispanCacheTransactions) {
        this.logMiningBufferInfinispanCacheTransactions = logMiningBufferInfinispanCacheTransactions;
    }

    public String getLogMiningBufferInfinispanCacheTransactions() {
        return this.logMiningBufferInfinispanCacheTransactions;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    public void setDatabaseHistoryKafkaTopic(String databaseHistoryKafkaTopic) {
        this.databaseHistoryKafkaTopic = databaseHistoryKafkaTopic;
    }

    public String getDatabaseHistoryKafkaTopic() {
        return this.databaseHistoryKafkaTopic;
    }

    public void setRetriableRestartConnectorWaitMs(long retriableRestartConnectorWaitMs) {
        this.retriableRestartConnectorWaitMs = retriableRestartConnectorWaitMs;
    }

    public long getRetriableRestartConnectorWaitMs() {
        return this.retriableRestartConnectorWaitMs;
    }

    public void setSnapshotDelayMs(long snapshotDelayMs) {
        this.snapshotDelayMs = snapshotDelayMs;
    }

    public long getSnapshotDelayMs() {
        return this.snapshotDelayMs;
    }

    public void setLogMiningStrategy(String logMiningStrategy) {
        this.logMiningStrategy = logMiningStrategy;
    }

    public String getLogMiningStrategy() {
        return this.logMiningStrategy;
    }

    public void setTableWhitelist(String tableWhitelist) {
        this.tableWhitelist = tableWhitelist;
    }

    public String getTableWhitelist() {
        return this.tableWhitelist;
    }

    public void setTombstonesOnDelete(boolean tombstonesOnDelete) {
        this.tombstonesOnDelete = tombstonesOnDelete;
    }

    public boolean isTombstonesOnDelete() {
        return this.tombstonesOnDelete;
    }

    public void setDecimalHandlingMode(String decimalHandlingMode) {
        this.decimalHandlingMode = decimalHandlingMode;
    }

    public String getDecimalHandlingMode() {
        return this.decimalHandlingMode;
    }

    public void setBinaryHandlingMode(String binaryHandlingMode) {
        this.binaryHandlingMode = binaryHandlingMode;
    }

    public String getBinaryHandlingMode() {
        return this.binaryHandlingMode;
    }

    public void setDatabaseOutServerName(String databaseOutServerName) {
        this.databaseOutServerName = databaseOutServerName;
    }

    public String getDatabaseOutServerName() {
        return this.databaseOutServerName;
    }

    public void setSnapshotIncludeCollectionList(String snapshotIncludeCollectionList) {
        this.snapshotIncludeCollectionList = snapshotIncludeCollectionList;
    }

    public String getSnapshotIncludeCollectionList() {
        return this.snapshotIncludeCollectionList;
    }

    public void setDatabaseHistoryFileFilename(String databaseHistoryFileFilename) {
        this.databaseHistoryFileFilename = databaseHistoryFileFilename;
    }

    public String getDatabaseHistoryFileFilename() {
        return this.databaseHistoryFileFilename;
    }

    public void setDatabasePdbName(String databasePdbName) {
        this.databasePdbName = databasePdbName;
    }

    public String getDatabasePdbName() {
        return this.databasePdbName;
    }

    public void setDatabaseConnectionAdapter(String databaseConnectionAdapter) {
        this.databaseConnectionAdapter = databaseConnectionAdapter;
    }

    public String getDatabaseConnectionAdapter() {
        return this.databaseConnectionAdapter;
    }

    public void setLogMiningBufferType(String logMiningBufferType) {
        this.logMiningBufferType = logMiningBufferType;
    }

    public String getLogMiningBufferType() {
        return this.logMiningBufferType;
    }

    public void setEventProcessingFailureHandlingMode(String eventProcessingFailureHandlingMode) {
        this.eventProcessingFailureHandlingMode = eventProcessingFailureHandlingMode;
    }

    public String getEventProcessingFailureHandlingMode() {
        return this.eventProcessingFailureHandlingMode;
    }

    public void setSnapshotMaxThreads(int snapshotMaxThreads) {
        this.snapshotMaxThreads = snapshotMaxThreads;
    }

    public int getSnapshotMaxThreads() {
        return this.snapshotMaxThreads;
    }

    public void setSchemaNameAdjustmentMode(String schemaNameAdjustmentMode) {
        this.schemaNameAdjustmentMode = schemaNameAdjustmentMode;
    }

    public String getSchemaNameAdjustmentMode() {
        return this.schemaNameAdjustmentMode;
    }

    public void setLogMiningBatchSizeDefault(long logMiningBatchSizeDefault) {
        this.logMiningBatchSizeDefault = logMiningBatchSizeDefault;
    }

    public long getLogMiningBatchSizeDefault() {
        return this.logMiningBatchSizeDefault;
    }

    public void setTableIncludeList(String tableIncludeList) {
        this.tableIncludeList = tableIncludeList;
    }

    public String getTableIncludeList() {
        return this.tableIncludeList;
    }

    public void setQueryFetchSize(int queryFetchSize) {
        this.queryFetchSize = queryFetchSize;
    }

    public int getQueryFetchSize() {
        return this.queryFetchSize;
    }

    public void setLogMiningSleepTimeMinMs(long logMiningSleepTimeMinMs) {
        this.logMiningSleepTimeMinMs = logMiningSleepTimeMinMs;
    }

    public long getLogMiningSleepTimeMinMs() {
        return this.logMiningSleepTimeMinMs;
    }

    public void setTableBlacklist(String tableBlacklist) {
        this.tableBlacklist = tableBlacklist;
    }

    public String getTableBlacklist() {
        return this.tableBlacklist;
    }

    public void setUnavailableValuePlaceholder(String unavailableValuePlaceholder) {
        this.unavailableValuePlaceholder = unavailableValuePlaceholder;
    }

    public String getUnavailableValuePlaceholder() {
        return this.unavailableValuePlaceholder;
    }

    public void setHeartbeatActionQuery(String heartbeatActionQuery) {
        this.heartbeatActionQuery = heartbeatActionQuery;
    }

    public String getHeartbeatActionQuery() {
        return this.heartbeatActionQuery;
    }

    public void setPollIntervalMs(long pollIntervalMs) {
        this.pollIntervalMs = pollIntervalMs;
    }

    public long getPollIntervalMs() {
        return this.pollIntervalMs;
    }

    public void setDatabaseHistoryKafkaRecoveryPollIntervalMs(int databaseHistoryKafkaRecoveryPollIntervalMs) {
        this.databaseHistoryKafkaRecoveryPollIntervalMs = databaseHistoryKafkaRecoveryPollIntervalMs;
    }

    public int getDatabaseHistoryKafkaRecoveryPollIntervalMs() {
        return this.databaseHistoryKafkaRecoveryPollIntervalMs;
    }

    public void setLobEnabled(boolean lobEnabled) {
        this.lobEnabled = lobEnabled;
    }

    public boolean isLobEnabled() {
        return this.lobEnabled;
    }

    public void setIntervalHandlingMode(String intervalHandlingMode) {
        this.intervalHandlingMode = intervalHandlingMode;
    }

    public String getIntervalHandlingMode() {
        return this.intervalHandlingMode;
    }

    public void setDatabaseHistoryStoreOnlyCapturedTablesDdl(boolean databaseHistoryStoreOnlyCapturedTablesDdl) {
        this.databaseHistoryStoreOnlyCapturedTablesDdl = databaseHistoryStoreOnlyCapturedTablesDdl;
    }

    public boolean isDatabaseHistoryStoreOnlyCapturedTablesDdl() {
        return this.databaseHistoryStoreOnlyCapturedTablesDdl;
    }

    public void setHeartbeatTopicsPrefix(String heartbeatTopicsPrefix) {
        this.heartbeatTopicsPrefix = heartbeatTopicsPrefix;
    }

    public String getHeartbeatTopicsPrefix() {
        return this.heartbeatTopicsPrefix;
    }

    public void setLogMiningArchiveLogOnlyMode(boolean logMiningArchiveLogOnlyMode) {
        this.logMiningArchiveLogOnlyMode = logMiningArchiveLogOnlyMode;
    }

    public boolean isLogMiningArchiveLogOnlyMode() {
        return this.logMiningArchiveLogOnlyMode;
    }

    public void setLogMiningBufferInfinispanCacheSchemaChanges(String logMiningBufferInfinispanCacheSchemaChanges) {
        this.logMiningBufferInfinispanCacheSchemaChanges = logMiningBufferInfinispanCacheSchemaChanges;
    }

    public String getLogMiningBufferInfinispanCacheSchemaChanges() {
        return this.logMiningBufferInfinispanCacheSchemaChanges;
    }

    public void setLogMiningSleepTimeMaxMs(long logMiningSleepTimeMaxMs) {
        this.logMiningSleepTimeMaxMs = logMiningSleepTimeMaxMs;
    }

    public long getLogMiningSleepTimeMaxMs() {
        return this.logMiningSleepTimeMaxMs;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatatypePropagateSourceType(String datatypePropagateSourceType) {
        this.datatypePropagateSourceType = datatypePropagateSourceType;
    }

    public String getDatatypePropagateSourceType() {
        return this.datatypePropagateSourceType;
    }

    public void setSanitizeFieldNames(boolean sanitizeFieldNames) {
        this.sanitizeFieldNames = sanitizeFieldNames;
    }

    public boolean isSanitizeFieldNames() {
        return this.sanitizeFieldNames;
    }

    public void setDatabaseHistoryKafkaBootstrapServers(String databaseHistoryKafkaBootstrapServers) {
        this.databaseHistoryKafkaBootstrapServers = databaseHistoryKafkaBootstrapServers;
    }

    public String getDatabaseHistoryKafkaBootstrapServers() {
        return this.databaseHistoryKafkaBootstrapServers;
    }

    public void setHeartbeatIntervalMs(int heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public int getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setColumnIncludeList(String columnIncludeList) {
        this.columnIncludeList = columnIncludeList;
    }

    public String getColumnIncludeList() {
        return this.columnIncludeList;
    }

    public void setLogMiningUsernameExcludeList(String logMiningUsernameExcludeList) {
        this.logMiningUsernameExcludeList = logMiningUsernameExcludeList;
    }

    public String getLogMiningUsernameExcludeList() {
        return this.logMiningUsernameExcludeList;
    }

    public void setColumnPropagateSourceType(String columnPropagateSourceType) {
        this.columnPropagateSourceType = columnPropagateSourceType;
    }

    public String getColumnPropagateSourceType() {
        return this.columnPropagateSourceType;
    }

    public void setLogMiningBufferInfinispanCacheProcessedTransactions(String logMiningBufferInfinispanCacheProcessedTransactions) {
        this.logMiningBufferInfinispanCacheProcessedTransactions = logMiningBufferInfinispanCacheProcessedTransactions;
    }

    public String getLogMiningBufferInfinispanCacheProcessedTransactions() {
        return this.logMiningBufferInfinispanCacheProcessedTransactions;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setLogMiningBufferInfinispanCacheEvents(String logMiningBufferInfinispanCacheEvents) {
        this.logMiningBufferInfinispanCacheEvents = logMiningBufferInfinispanCacheEvents;
    }

    public String getLogMiningBufferInfinispanCacheEvents() {
        return this.logMiningBufferInfinispanCacheEvents;
    }

    public void setDatabaseHistoryStoreOnlyMonitoredTablesDdl(boolean databaseHistoryStoreOnlyMonitoredTablesDdl) {
        this.databaseHistoryStoreOnlyMonitoredTablesDdl = databaseHistoryStoreOnlyMonitoredTablesDdl;
    }

    public boolean isDatabaseHistoryStoreOnlyMonitoredTablesDdl() {
        return this.databaseHistoryStoreOnlyMonitoredTablesDdl;
    }

    public void setSkippedOperations(String skippedOperations) {
        this.skippedOperations = skippedOperations;
    }

    public String getSkippedOperations() {
        return this.skippedOperations;
    }

    public void setLogMiningScnGapDetectionTimeIntervalMaxMs(long logMiningScnGapDetectionTimeIntervalMaxMs) {
        this.logMiningScnGapDetectionTimeIntervalMaxMs = logMiningScnGapDetectionTimeIntervalMaxMs;
    }

    public long getLogMiningScnGapDetectionTimeIntervalMaxMs() {
        return this.logMiningScnGapDetectionTimeIntervalMaxMs;
    }

    public void setDatabaseHistory(String databaseHistory) {
        this.databaseHistory = databaseHistory;
    }

    public String getDatabaseHistory() {
        return this.databaseHistory;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setRacNodes(String racNodes) {
        this.racNodes = racNodes;
    }

    public String getRacNodes() {
        return this.racNodes;
    }

    public void setDatabaseHistoryKafkaRecoveryAttempts(int databaseHistoryKafkaRecoveryAttempts) {
        this.databaseHistoryKafkaRecoveryAttempts = databaseHistoryKafkaRecoveryAttempts;
    }

    public int getDatabaseHistoryKafkaRecoveryAttempts() {
        return this.databaseHistoryKafkaRecoveryAttempts;
    }

    public void setProvideTransactionMetadata(boolean provideTransactionMetadata) {
        this.provideTransactionMetadata = provideTransactionMetadata;
    }

    public boolean isProvideTransactionMetadata() {
        return this.provideTransactionMetadata;
    }

    public void setIncludeSchemaComments(boolean includeSchemaComments) {
        this.includeSchemaComments = includeSchemaComments;
    }

    public boolean isIncludeSchemaComments() {
        return this.includeSchemaComments;
    }

    public void setDatabaseHistorySkipUnparseableDdl(boolean databaseHistorySkipUnparseableDdl) {
        this.databaseHistorySkipUnparseableDdl = databaseHistorySkipUnparseableDdl;
    }

    public boolean isDatabaseHistorySkipUnparseableDdl() {
        return this.databaseHistorySkipUnparseableDdl;
    }

    public void setLogMiningArchiveLogHours(long logMiningArchiveLogHours) {
        this.logMiningArchiveLogHours = logMiningArchiveLogHours;
    }

    public long getLogMiningArchiveLogHours() {
        return this.logMiningArchiveLogHours;
    }

    public void setLogMiningTransactionRetentionHours(long logMiningTransactionRetentionHours) {
        this.logMiningTransactionRetentionHours = logMiningTransactionRetentionHours;
    }

    public long getLogMiningTransactionRetentionHours() {
        return this.logMiningTransactionRetentionHours;
    }

    public void setLogMiningBatchSizeMax(long logMiningBatchSizeMax) {
        this.logMiningBatchSizeMax = logMiningBatchSizeMax;
    }

    public long getLogMiningBatchSizeMax() {
        return this.logMiningBatchSizeMax;
    }

    public void setMaxQueueSizeInBytes(long maxQueueSizeInBytes) {
        this.maxQueueSizeInBytes = maxQueueSizeInBytes;
    }

    public long getMaxQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public void setTransactionTopic(String transactionTopic) {
        this.transactionTopic = transactionTopic;
    }

    public String getTransactionTopic() {
        return this.transactionTopic;
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public void setTimePrecisionMode(String timePrecisionMode) {
        this.timePrecisionMode = timePrecisionMode;
    }

    public String getTimePrecisionMode() {
        return this.timePrecisionMode;
    }

    public void setDatabaseServerName(String databaseServerName) {
        this.databaseServerName = databaseServerName;
    }

    public String getDatabaseServerName() {
        return this.databaseServerName;
    }

    public void setDatabasePort(int databasePort) {
        this.databasePort = databasePort;
    }

    public int getDatabasePort() {
        return this.databasePort;
    }

    public void setLogMiningSleepTimeIncrementMs(long logMiningSleepTimeIncrementMs) {
        this.logMiningSleepTimeIncrementMs = logMiningSleepTimeIncrementMs;
    }

    public long getLogMiningSleepTimeIncrementMs() {
        return this.logMiningSleepTimeIncrementMs;
    }

    public void setColumnExcludeList(String columnExcludeList) {
        this.columnExcludeList = columnExcludeList;
    }

    public String getColumnExcludeList() {
        return this.columnExcludeList;
    }

    public void setLogMiningSessionMaxMs(long logMiningSessionMaxMs) {
        this.logMiningSessionMaxMs = logMiningSessionMaxMs;
    }

    public long getLogMiningSessionMaxMs() {
        return this.logMiningSessionMaxMs;
    }

    public void setDatabaseHostname(String databaseHostname) {
        this.databaseHostname = databaseHostname;
    }

    public String getDatabaseHostname() {
        return this.databaseHostname;
    }

    public void setLogMiningBatchSizeMin(long logMiningBatchSizeMin) {
        this.logMiningBatchSizeMin = logMiningBatchSizeMin;
    }

    public long getLogMiningBatchSizeMin() {
        return this.logMiningBatchSizeMin;
    }

    public void setSnapshotEnhancePredicateScn(String snapshotEnhancePredicateScn) {
        this.snapshotEnhancePredicateScn = snapshotEnhancePredicateScn;
    }

    public String getSnapshotEnhancePredicateScn() {
        return this.snapshotEnhancePredicateScn;
    }

    protected Configuration createConnectorConfiguration() {
        Configuration.Builder configBuilder = Configuration.create();
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.locking.mode", (Object)this.snapshotLockingMode);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.buffer.drop.on.stop", (Object)this.logMiningBufferDropOnStop);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"message.key.columns", (Object)this.messageKeyColumns);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.archive.destination.name", (Object)this.logMiningArchiveDestinationName);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"column.blacklist", (Object)this.columnBlacklist);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"include.schema.changes", (Object)this.includeSchemaChanges);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"signal.data.collection", (Object)this.signalDataCollection);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"converters", (Object)this.converters);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.fetch.size", (Object)this.snapshotFetchSize);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.lock.timeout.ms", (Object)this.snapshotLockTimeoutMs);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.kafka.query.timeout.ms", (Object)this.databaseHistoryKafkaQueryTimeoutMs);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.scn.gap.detection.gap.size.min", (Object)this.logMiningScnGapDetectionGapSizeMin);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.dbname", (Object)this.databaseDbname);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.sleep.time.default.ms", (Object)this.logMiningSleepTimeDefaultMs);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.select.statement.overrides", (Object)this.snapshotSelectStatementOverrides);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"source.struct.version", (Object)this.sourceStructVersion);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"column.whitelist", (Object)this.columnWhitelist);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.archive.log.only.scn.poll.interval.ms", (Object)this.logMiningArchiveLogOnlyScnPollIntervalMs);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"table.exclude.list", (Object)this.tableExcludeList);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"max.batch.size", (Object)this.maxBatchSize);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.buffer.infinispan.cache.transactions", (Object)this.logMiningBufferInfinispanCacheTransactions);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.mode", (Object)this.snapshotMode);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.kafka.topic", (Object)this.databaseHistoryKafkaTopic);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"retriable.restart.connector.wait.ms", (Object)this.retriableRestartConnectorWaitMs);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.delay.ms", (Object)this.snapshotDelayMs);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.strategy", (Object)this.logMiningStrategy);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"table.whitelist", (Object)this.tableWhitelist);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"tombstones.on.delete", (Object)this.tombstonesOnDelete);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"decimal.handling.mode", (Object)this.decimalHandlingMode);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"binary.handling.mode", (Object)this.binaryHandlingMode);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.out.server.name", (Object)this.databaseOutServerName);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.include.collection.list", (Object)this.snapshotIncludeCollectionList);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.file.filename", (Object)this.databaseHistoryFileFilename);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.pdb.name", (Object)this.databasePdbName);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.connection.adapter", (Object)this.databaseConnectionAdapter);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.buffer.type", (Object)this.logMiningBufferType);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"event.processing.failure.handling.mode", (Object)this.eventProcessingFailureHandlingMode);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.max.threads", (Object)this.snapshotMaxThreads);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"schema.name.adjustment.mode", (Object)this.schemaNameAdjustmentMode);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.batch.size.default", (Object)this.logMiningBatchSizeDefault);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"table.include.list", (Object)this.tableIncludeList);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"query.fetch.size", (Object)this.queryFetchSize);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.sleep.time.min.ms", (Object)this.logMiningSleepTimeMinMs);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"table.blacklist", (Object)this.tableBlacklist);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"unavailable.value.placeholder", (Object)this.unavailableValuePlaceholder);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"heartbeat.action.query", (Object)this.heartbeatActionQuery);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"poll.interval.ms", (Object)this.pollIntervalMs);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.kafka.recovery.poll.interval.ms", (Object)this.databaseHistoryKafkaRecoveryPollIntervalMs);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"lob.enabled", (Object)this.lobEnabled);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"interval.handling.mode", (Object)this.intervalHandlingMode);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.store.only.captured.tables.ddl", (Object)this.databaseHistoryStoreOnlyCapturedTablesDdl);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"heartbeat.topics.prefix", (Object)this.heartbeatTopicsPrefix);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.archive.log.only.mode", (Object)this.logMiningArchiveLogOnlyMode);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.buffer.infinispan.cache.schema_changes", (Object)this.logMiningBufferInfinispanCacheSchemaChanges);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.sleep.time.max.ms", (Object)this.logMiningSleepTimeMaxMs);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.user", (Object)this.databaseUser);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"datatype.propagate.source.type", (Object)this.datatypePropagateSourceType);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"sanitize.field.names", (Object)this.sanitizeFieldNames);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.kafka.bootstrap.servers", (Object)this.databaseHistoryKafkaBootstrapServers);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"heartbeat.interval.ms", (Object)this.heartbeatIntervalMs);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"column.include.list", (Object)this.columnIncludeList);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.username.exclude.list", (Object)this.logMiningUsernameExcludeList);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"column.propagate.source.type", (Object)this.columnPropagateSourceType);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.buffer.infinispan.cache.processed_transactions", (Object)this.logMiningBufferInfinispanCacheProcessedTransactions);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.password", (Object)this.databasePassword);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.buffer.infinispan.cache.events", (Object)this.logMiningBufferInfinispanCacheEvents);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.store.only.monitored.tables.ddl", (Object)this.databaseHistoryStoreOnlyMonitoredTablesDdl);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"skipped.operations", (Object)this.skippedOperations);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.scn.gap.detection.time.interval.max.ms", (Object)this.logMiningScnGapDetectionTimeIntervalMaxMs);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history", (Object)this.databaseHistory);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"max.queue.size", (Object)this.maxQueueSize);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"rac.nodes", (Object)this.racNodes);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.kafka.recovery.attempts", (Object)this.databaseHistoryKafkaRecoveryAttempts);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"provide.transaction.metadata", (Object)this.provideTransactionMetadata);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"include.schema.comments", (Object)this.includeSchemaComments);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.skip.unparseable.ddl", (Object)this.databaseHistorySkipUnparseableDdl);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.archive.log.hours", (Object)this.logMiningArchiveLogHours);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.transaction.retention.hours", (Object)this.logMiningTransactionRetentionHours);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.batch.size.max", (Object)this.logMiningBatchSizeMax);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"max.queue.size.in.bytes", (Object)this.maxQueueSizeInBytes);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"transaction.topic", (Object)this.transactionTopic);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.url", (Object)this.databaseUrl);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"time.precision.mode", (Object)this.timePrecisionMode);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.server.name", (Object)this.databaseServerName);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.port", (Object)this.databasePort);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.sleep.time.increment.ms", (Object)this.logMiningSleepTimeIncrementMs);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"column.exclude.list", (Object)this.columnExcludeList);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.session.max.ms", (Object)this.logMiningSessionMaxMs);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.hostname", (Object)this.databaseHostname);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"log.mining.batch.size.min", (Object)this.logMiningBatchSizeMin);
        OracleConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.enhance.predicate.scn", (Object)this.snapshotEnhancePredicateScn);
        return configBuilder.build();
    }

    protected Class configureConnectorClass() {
        return OracleConnector.class;
    }

    protected ConfigurationValidation validateConnectorConfiguration() {
        if (OracleConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet((Object)this.databasePassword)) {
            return ConfigurationValidation.notValid((String)"Required field 'databasePassword' must be set.");
        }
        if (OracleConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet((Object)this.databaseServerName)) {
            return ConfigurationValidation.notValid((String)"Required field 'databaseServerName' must be set.");
        }
        return ConfigurationValidation.valid();
    }

    public String getConnectorDatabaseType() {
        return "oracle";
    }
}

