/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium;

import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.component.debezium.DebeziumComponent;
import org.apache.camel.component.debezium.DebeziumConstants;
import org.apache.camel.component.debezium.DebeziumEndpoint;
import org.apache.camel.component.debezium.DebeziumSqlserverComponent;
import org.apache.camel.component.debezium.configuration.SqlServerConnectorEmbeddedDebeziumConfiguration;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(firstVersion="3.0.0", scheme="debezium-sqlserver", title="Debezium SQL Server Connector", syntax="debezium-sqlserver:name", category={Category.DATABASE}, consumerOnly=true, headersClass=DebeziumConstants.class)
public final class DebeziumSqlserverEndpoint
extends DebeziumEndpoint<SqlServerConnectorEmbeddedDebeziumConfiguration>
implements EndpointServiceLocation {
    @UriParam
    private SqlServerConnectorEmbeddedDebeziumConfiguration configuration;

    public DebeziumSqlserverEndpoint(String uri, DebeziumSqlserverComponent component, SqlServerConnectorEmbeddedDebeziumConfiguration configuration) {
        super(uri, (DebeziumComponent)component);
        this.configuration = configuration;
    }

    public DebeziumSqlserverEndpoint() {
    }

    public String getServiceUrl() {
        return this.configuration.getDatabaseHostname() + ":" + this.configuration.getDatabasePort();
    }

    public String getServiceProtocol() {
        return "jdbc";
    }

    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getDatabaseUser() != null) {
            return Map.of("username", this.configuration.getDatabaseUser());
        }
        return null;
    }

    public SqlServerConnectorEmbeddedDebeziumConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SqlServerConnectorEmbeddedDebeziumConfiguration configuration) {
        this.configuration = configuration;
    }
}

