/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dhis2.internal;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.component.dhis2.Dhis2Configuration;
import org.apache.camel.component.dhis2.Dhis2DeleteEndpointConfiguration;
import org.apache.camel.component.dhis2.Dhis2GetEndpointConfiguration;
import org.apache.camel.component.dhis2.Dhis2PostEndpointConfiguration;
import org.apache.camel.component.dhis2.Dhis2PutEndpointConfiguration;
import org.apache.camel.component.dhis2.Dhis2ResourceTablesEndpointConfiguration;
import org.apache.camel.component.dhis2.internal.Dhis2ApiName;
import org.apache.camel.component.dhis2.internal.Dhis2DeleteApiMethod;
import org.apache.camel.component.dhis2.internal.Dhis2GetApiMethod;
import org.apache.camel.component.dhis2.internal.Dhis2PostApiMethod;
import org.apache.camel.component.dhis2.internal.Dhis2PutApiMethod;
import org.apache.camel.component.dhis2.internal.Dhis2ResourceTablesApiMethod;
import org.apache.camel.support.component.ApiCollection;
import org.apache.camel.support.component.ApiMethodHelper;

public final class Dhis2ApiCollection
extends ApiCollection<Dhis2ApiName, Dhis2Configuration> {
    private static Dhis2ApiCollection collection;

    private Dhis2ApiCollection() {
        HashMap aliases = new HashMap();
        EnumMap<Dhis2ApiName, ApiMethodHelper> apiHelpers = new EnumMap<Dhis2ApiName, ApiMethodHelper>(Dhis2ApiName.class);
        HashMap<Class<Dhis2PutApiMethod>, Dhis2ApiName> apiMethods = new HashMap<Class<Dhis2PutApiMethod>, Dhis2ApiName>();
        aliases.clear();
        List<String> nullableArgs = Arrays.asList("resource", "queryParams");
        apiHelpers.put(Dhis2ApiName.POST, new ApiMethodHelper(Dhis2PostApiMethod.class, aliases, nullableArgs));
        apiMethods.put(Dhis2PostApiMethod.class, Dhis2ApiName.POST);
        aliases.clear();
        nullableArgs = Arrays.asList("skipEvents", "skipAggregate", "lastYears", "interval");
        apiHelpers.put(Dhis2ApiName.RESOURCE_TABLES, new ApiMethodHelper(Dhis2ResourceTablesApiMethod.class, aliases, nullableArgs));
        apiMethods.put(Dhis2ResourceTablesApiMethod.class, Dhis2ApiName.RESOURCE_TABLES);
        aliases.clear();
        nullableArgs = Arrays.asList("paging", "fields", "filter", "rootJunction", "queryParams");
        apiHelpers.put(Dhis2ApiName.GET, new ApiMethodHelper(Dhis2GetApiMethod.class, aliases, nullableArgs));
        apiMethods.put(Dhis2GetApiMethod.class, Dhis2ApiName.GET);
        aliases.clear();
        nullableArgs = Arrays.asList("resource", "queryParams");
        apiHelpers.put(Dhis2ApiName.DELETE, new ApiMethodHelper(Dhis2DeleteApiMethod.class, aliases, nullableArgs));
        apiMethods.put(Dhis2DeleteApiMethod.class, Dhis2ApiName.DELETE);
        aliases.clear();
        nullableArgs = Arrays.asList("resource", "queryParams");
        apiHelpers.put(Dhis2ApiName.PUT, new ApiMethodHelper(Dhis2PutApiMethod.class, aliases, nullableArgs));
        apiMethods.put(Dhis2PutApiMethod.class, Dhis2ApiName.PUT);
        this.setApiHelpers(apiHelpers);
        this.setApiMethods(apiMethods);
    }

    public Dhis2Configuration getEndpointConfiguration(Dhis2ApiName apiName) {
        Dhis2Configuration result = null;
        switch (apiName) {
            case POST: {
                result = new Dhis2PostEndpointConfiguration();
                break;
            }
            case RESOURCE_TABLES: {
                result = new Dhis2ResourceTablesEndpointConfiguration();
                break;
            }
            case GET: {
                result = new Dhis2GetEndpointConfiguration();
                break;
            }
            case DELETE: {
                result = new Dhis2DeleteEndpointConfiguration();
                break;
            }
            case PUT: {
                result = new Dhis2PutEndpointConfiguration();
            }
        }
        return result;
    }

    public static synchronized Dhis2ApiCollection getCollection() {
        if (collection == null) {
            collection = new Dhis2ApiCollection();
        }
        return collection;
    }
}

